/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.CopyPasteAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.FindReferencesAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.LanguageNewAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.TranslationModifyAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.TranslationNewAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.TranslationRefreshAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.TranslationRemoveAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.UpdateReferenceCountAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTable;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableCell;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableController;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.importexport.TranslationExportAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.importexport.TranslationImportAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NlsTablePage
extends Composite {
    private final TranslationStoreStack m_stack;
    private Button m_hideReadOnly;
    private NlsTable m_view;
    private NlsTableController m_controller;

    public NlsTablePage(Composite parent, TranslationStoreStack stack) {
        super(parent, 0);
        this.m_stack = (TranslationStoreStack)Ensure.notNull((Object)stack);
        FormToolkit toolkit = new FormToolkit(this.getDisplay());
        Form form = toolkit.createForm((Composite)this);
        form.setText("Translations");
        this.createContent(toolkit, form.getBody());
        this.setLayout((Layout)new FillLayout());
        this.createFormMenu((IContributionManager)form.getToolBarManager());
        form.updateToolBar();
    }

    protected void createContent(FormToolkit toolkit, Composite parent) {
        this.m_controller = new NlsTableController(this.stack());
        Composite rootArea = toolkit.createComposite(parent);
        this.m_hideReadOnly = toolkit.createButton(rootArea, "Hide read-only rows", 32);
        this.m_hideReadOnly.setSelection(true);
        this.m_hideReadOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NlsTablePage.this.m_controller.setHideReadOnly(NlsTablePage.this.m_hideReadOnly.getSelection());
            }
        });
        this.m_view = new NlsTable(rootArea, this.m_controller);
        this.m_view.addMenuListener(new P_MenuListener());
        this.m_controller.bind(this.m_view);
        this.m_controller.setHideReadOnly(this.m_hideReadOnly.getSelection());
        parent.setLayout((Layout)new FillLayout());
        GridLayoutFactory.swtDefaults().applyTo(rootArea);
        GridDataFactory.defaultsFor((Control)this.m_hideReadOnly).align(4, 0x1000000).applyTo((Control)this.m_hideReadOnly);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.m_view);
    }

    protected void createFormMenu(IContributionManager manager) {
        manager.add((IAction)new TranslationRefreshAction(this.stack(), this.m_view));
        manager.add((IAction)new UpdateReferenceCountAction(this.m_controller, this.m_view.getDisplay()));
        manager.add((IAction)new TranslationNewAction(this.m_view.getShell(), this.stack(), this.m_controller));
        manager.add((IAction)new LanguageNewAction(this.stack(), this.m_view.getShell()));
        manager.add((IAction)new TranslationImportAction(this.stack(), this.m_view.getShell()));
        manager.add((IAction)new TranslationExportAction(this.stack(), this.m_view.getShell()));
    }

    public TranslationStoreStack stack() {
        return this.m_stack;
    }

    private final class P_MenuListener
    implements IMenuListener {
        private P_MenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            List<ITranslationEntry> entries = NlsTablePage.this.m_controller.getSelectedEntries();
            if (entries.size() == 1) {
                this.addSingleSelectMenus((IContributionManager)manager, NlsTablePage.this.m_view.getCursorSelection().get());
            } else if (entries.size() > 1) {
                this.addMultiSelectMenus((IContributionManager)manager, entries);
            }
        }

        private void addSingleSelectMenus(IContributionManager manager, NlsTableCell cursorSelection) {
            if (cursorSelection.store().isEditable()) {
                if (cursorSelection.column() == 1) {
                    manager.add((IAction)new Action("Edit key"){

                        public void run() {
                            NlsTablePage.this.m_view.showEditor();
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IAction)new TranslationModifyAction(NlsTablePage.this.getShell(), cursorSelection.entry(), NlsTablePage.this.stack()));
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new FindReferencesAction(NlsTablePage.this.stack(), cursorSelection.entry().key()));
            String text = cursorSelection.text();
            if (!Strings.isEmpty((CharSequence)text)) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new CopyPasteAction("Copy", text, NlsTablePage.this.m_view.getDisplay()));
            }
            if (cursorSelection.store().isEditable()) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new TranslationRemoveAction(NlsTablePage.this.stack(), (ITranslation)cursorSelection.entry()));
            }
        }

        private void addMultiSelectMenus(IContributionManager manager, List<ITranslationEntry> entries) {
            manager.add((IAction)new TranslationRemoveAction("Remove entries", NlsTablePage.this.stack(), entries));
        }
    }
}

