/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientEntry;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.ui.SharedObjectContainerUI;

public class CollabClient {
    public static final String WORKSPACE_NAME = Messages.CollabClient_WORKSPACE_NAME;
    public static final String GENERIC_CONTAINER_CLIENT_NAME = "ecf.generic.client";
    static Hashtable clients = new Hashtable();
    static CollabClient collabClient = new CollabClient();

    public void createAndConnectClient(String containerType, String uri, String nickname, Object connectData, IResource resource) throws Exception {
        IContainer newClient = ContainerFactory.getDefault().createContainer(containerType);
        ID targetID = IDFactory.getDefault().createID(newClient.getConnectNamespace(), uri);
        String username = this.setupUsername(targetID, nickname);
        ClientEntry newClientEntry = new ClientEntry(containerType, newClient);
        ISharedObjectContainer sharedObjectContainer = (ISharedObjectContainer)newClient.getAdapter(ISharedObjectContainer.class);
        SharedObjectContainerUI socui = new SharedObjectContainerUI(this, sharedObjectContainer);
        socui.setup(sharedObjectContainer, newClientEntry, resource, username);
        try {
            newClient.connect(targetID, ConnectContextFactory.createUsernamePasswordConnectContext((String)username, (Object)connectData));
        }
        catch (ContainerConnectException e) {
            EclipseCollabSharedObject so = newClientEntry.getSharedObject();
            if (so != null) {
                so.destroySelf();
            }
            throw e;
        }
        CollabClient.addClientForResource(newClientEntry, resource);
    }

    public ClientEntry isConnected(IResource project, String type) {
        ClientEntry entry = CollabClient.getClientEntry(project, type);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addClientForResource(ClientEntry entry, IResource proj) {
        Hashtable hashtable = clients;
        synchronized (hashtable) {
            String name = CollabClient.getNameForResource(proj);
            Vector<ClientEntry> v = (Vector<ClientEntry>)clients.get(name);
            if (v == null) {
                v = new Vector<ClientEntry>();
            }
            v.add(entry);
            clients.put(name, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientForResource(IResource proj, ID targetID) {
        Hashtable hashtable = clients;
        synchronized (hashtable) {
            String resourceName = CollabClient.getNameForResource(proj);
            Vector v = (Vector)clients.get(resourceName);
            if (v == null) {
                return;
            }
            ClientEntry remove = null;
            for (ClientEntry e : v) {
                ID connectedID = e.getContainer().getConnectedID();
                if (connectedID != null && !connectedID.equals((Object)targetID)) continue;
                remove = e;
            }
            if (remove != null) {
                v.remove(remove);
            }
            if (v.size() == 0) {
                clients.remove(resourceName);
            }
        }
    }

    public static String getNameForResource(IResource res) {
        String preName = res.getName().trim();
        if (preName == null || preName.equals("")) {
            preName = WORKSPACE_NAME;
        }
        return preName;
    }

    public static IResource getWorkspace() throws Exception {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Vector getClientEntries(IResource proj) {
        Hashtable hashtable = clients;
        synchronized (hashtable) {
            return (Vector)clients.get(CollabClient.getNameForResource(proj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClientEntry getClientEntry(IResource proj, ID targetID) {
        Hashtable hashtable = clients;
        synchronized (hashtable) {
            Vector v;
            block5: {
                v = CollabClient.getClientEntries(proj);
                if (v != null) break block5;
                return null;
            }
            for (ClientEntry e : v) {
                ID connectedID = e.getContainer().getConnectedID();
                if (connectedID == null || !connectedID.equals((Object)targetID)) continue;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClientEntry getClientEntry(IResource proj, String containerType) {
        Hashtable hashtable = clients;
        synchronized (hashtable) {
            Vector v;
            block5: {
                v = CollabClient.getClientEntries(proj);
                if (v != null) break block5;
                return null;
            }
            for (ClientEntry e : v) {
                String contType;
                ID connectedID = e.getContainer().getConnectedID();
                if (connectedID == null || !(contType = e.getContainerType()).equals(containerType)) continue;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean containsEntry(IResource proj, ID targetID) {
        Hashtable hashtable = clients;
        synchronized (hashtable) {
            ClientEntry e;
            ID connectedID;
            Vector v = (Vector)clients.get(CollabClient.getNameForResource(proj));
            if (v == null) {
                return false;
            }
            Iterator i = v.iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while ((connectedID = (e = (ClientEntry)i.next()).getContainer().getConnectedID()) == null || !connectedID.equals((Object)targetID));
            return true;
        }
    }

    public static synchronized ISharedObjectContainer getContainer(IResource proj) {
        ClientEntry entry = CollabClient.getClientEntry(proj, GENERIC_CONTAINER_CLIENT_NAME);
        if (entry == null) {
            entry = CollabClient.getClientEntry((IResource)ResourcesPlugin.getWorkspace().getRoot(), GENERIC_CONTAINER_CLIENT_NAME);
        }
        if (entry != null) {
            IContainer cont = entry.getContainer();
            if (cont != null) {
                return (ISharedObjectContainer)cont.getAdapter(ISharedObjectContainer.class);
            }
            return null;
        }
        return null;
    }

    public static CollabClient getDefault() {
        return collabClient;
    }

    public synchronized void disposeClient(IResource proj, ClientEntry entry) {
        entry.dispose();
        CollabClient.removeClientForResource(proj, entry.getContainer().getConnectedID());
    }

    protected String setupUsername(ID targetID, String nickname) throws URISyntaxException {
        String username = null;
        if (nickname != null) {
            username = nickname;
        } else {
            username = new URI(targetID.getName()).getUserInfo();
            if (username == null || username.equals("")) {
                username = System.getProperty("user.name");
            }
        }
        return username;
    }
}

