/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.serialization;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdAdapter
extends EContentAdapter {
    final Map<String, EObject> idToEObjectMap;
    final Map<EObject, String> eObjectToIDMap;
    final Collection<EPackage> createIdForPackages;

    public IdAdapter(Map<String, EObject> idToEObjectMap, Map<EObject, String> eObjectToIDMap, Collection<EPackage> createIdForPackages) {
        this.idToEObjectMap = idToEObjectMap;
        this.eObjectToIDMap = eObjectToIDMap;
        this.createIdForPackages = createIdForPackages;
    }

    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyChanged(Notification n) {
        assert (n.getNotifier() != null);
        super.notifyChanged(n);
        Object notifier_ = n.getNotifier();
        if (n.isTouch()) return;
        if (notifier_ instanceof EObject) {
            Object feature = n.getFeature();
            if (feature instanceof EAttribute) {
                EAttribute attribute = (EAttribute)feature;
                if (!attribute.isID()) return;
                String newId = n.getNewStringValue();
                String oldId = n.getOldStringValue();
                EObject objectWithId = (EObject)n.getNotifier();
                switch (n.getEventType()) {
                    case 1: {
                        if (newId == null) {
                            this.eObjectToIDMap.remove(objectWithId);
                        } else {
                            this.eObjectToIDMap.put(objectWithId, newId);
                            this.idToEObjectMap.put(newId, objectWithId);
                        }
                        if (oldId == null) return;
                        this.idToEObjectMap.remove(oldId);
                        return;
                    }
                    case 2: {
                        this.eObjectToIDMap.remove(objectWithId);
                        this.idToEObjectMap.remove(oldId);
                    }
                    default: {
                        return;
                    }
                }
            }
            EReference reference = (EReference)feature;
            if (!reference.isContainment()) return;
            switch (n.getEventType()) {
                case 1: 
                case 3: {
                    this.handleNewObjectAndSubObjects((EObject)n.getNewValue());
                    return;
                }
                case 5: {
                    EList newObjects = (EList)n.getNewValue();
                    int size = newObjects.size();
                    int i = 0;
                    while (i < size) {
                        this.handleNewObjectAndSubObjects((EObject)newObjects.get(i));
                        ++i;
                    }
                    return;
                }
                case 2: 
                case 4: {
                    this.handleRemoveObjectAndSubObjects((EObject)n.getOldValue());
                    return;
                }
                case 6: {
                    EList removeObjects = (EList)n.getOldValue();
                    int size = removeObjects.size();
                    int i = 0;
                    while (i < size) {
                        this.handleRemoveObjectAndSubObjects((EObject)removeObjects.get(i));
                        ++i;
                    }
                }
                default: {
                    return;
                }
            }
        }
        if (notifier_ instanceof Resource) {
            int featureID = n.getFeatureID(Resource.class);
            if (2 != featureID) return;
            switch (n.getEventType()) {
                case 1: 
                case 3: {
                    this.handleNewObjectAndSubObjects((EObject)n.getNewValue());
                    return;
                }
                case 5: {
                    EList newObjects = (EList)n.getNewValue();
                    int size = newObjects.size();
                    int i = 0;
                    while (i < size) {
                        this.handleNewObjectAndSubObjects((EObject)newObjects.get(i));
                        ++i;
                    }
                    return;
                }
                case 2: 
                case 4: {
                    this.handleRemoveObjectAndSubObjects((EObject)n.getOldValue());
                    return;
                }
                case 6: {
                    EList removeObjects = (EList)n.getOldValue();
                    int size = removeObjects.size();
                    int i = 0;
                    while (i < size) {
                        this.handleRemoveObjectAndSubObjects((EObject)removeObjects.get(i));
                        ++i;
                    }
                }
                default: {
                    return;
                }
            }
        }
        boolean cfr_ignored_0 = notifier_ instanceof ResourceSet;
    }

    void handleNewObjectAndSubObjects(EObject objectWithId) {
        if (objectWithId != null) {
            this.handleNewObject(objectWithId);
        }
        TreeIterator iterator = objectWithId.eAllContents();
        while (iterator.hasNext()) {
            this.handleNewObject((EObject)iterator.next());
        }
    }

    void handleNewObject(EObject objectWithId) {
        assert (objectWithId != null);
        EAttribute idAttribute = objectWithId.eClass().getEIDAttribute();
        if (idAttribute != null) {
            String id = (String)objectWithId.eGet((EStructuralFeature)idAttribute);
            if ((id == null || id.length() == 0) && this.createIdForPackages.contains(objectWithId.eClass().getEPackage())) {
                id = EcoreUtil.generateUUID();
                objectWithId.eSet((EStructuralFeature)idAttribute, (Object)id);
            } else {
                this.eObjectToIDMap.put(objectWithId, id);
                this.idToEObjectMap.put(id, objectWithId);
            }
        }
    }

    void handleRemoveObjectAndSubObjects(EObject objectWithId) {
        if (objectWithId != null) {
            this.handleRemoveObject(objectWithId);
        }
        TreeIterator iterator = objectWithId.eAllContents();
        while (iterator.hasNext()) {
            this.handleRemoveObject((EObject)iterator.next());
        }
    }

    void handleRemoveObject(EObject objectWithId) {
        assert (objectWithId != null);
        String id = this.eObjectToIDMap.remove(objectWithId);
        if (id != null) {
            this.idToEObjectMap.remove(id);
        }
    }
}

