/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rmf.reqif10.search.ui.ReqIFSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;

public class UsageSearchResult
implements ISearchResult {
    private final ReqIFSearchQuery query;
    private final Map<Resource, Collection<EObject>> searchEntries;
    private final Collection<ISearchResultListener> searchResultListeners = new ArrayList<ISearchResultListener>();

    public UsageSearchResult(ReqIFSearchQuery query) {
        this.query = query;
        this.searchEntries = new HashMap<Resource, Collection<EObject>>();
    }

    public void addListener(ISearchResultListener l) {
        this.searchResultListeners.add(l);
    }

    public void removeListener(ISearchResultListener l) {
        this.searchResultListeners.remove(l);
    }

    public String getLabel() {
        StringBuilder builder = new StringBuilder("Search in files '");
        int resultFoundSize = 0;
        for (Map.Entry<Resource, Collection<EObject>> entry : this.searchEntries.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ++resultFoundSize;
        }
        int max = resultFoundSize > 0 ? Math.min(3, resultFoundSize) : 3;
        int count = 0;
        Set<Resource> resources = this.searchEntries.keySet();
        Iterator iterator = resources.iterator();
        while (iterator.hasNext() && count < max) {
            Resource resource = (Resource)iterator.next();
            builder.append(resource.getURI().lastSegment()).append(" - ");
            ++count;
        }
        if (count < resultFoundSize) {
            builder.append("... - ");
        }
        builder.append("' result : ").append(resultFoundSize).append(" occurences");
        return builder.toString();
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public Map<Resource, Collection<EObject>> getSearchEntries() {
        return this.searchEntries;
    }
}

