/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.provider.VirtualSpecificationsItemProvider;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.provider.SpecElementWithAttributesTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificationTest
extends SpecElementWithAttributesTest {
    protected Specification getFixture() {
        return (Specification)this.fixture;
    }

    @Before
    public void setUpSpecificationTest() throws Exception {
        this.setFixture((Identifiable)ReqIF10Factory.eINSTANCE.createSpecification());
    }

    @After
    public void tearDownSpecificationTest() throws Exception {
        this.setFixture(null);
    }

    @Override
    protected void addFixtureToReqIf(ReqIF rif) {
        this.setViaCommand(rif.getCoreContent(), (EStructuralFeature)ReqIF10Package.Literals.REQ_IF_CONTENT__SPECIFICATIONS, this.getFixture());
    }

    @Override
    protected Set<String> getStandardPropertyNames() {
        return new HashSet<String>(Arrays.asList(STANDARD_PROPERTIES));
    }

    @Override
    protected void setFixtureType(SpecElementWithAttributes specElement, SpecType specType) {
        this.setViaCommand(specElement, (EStructuralFeature)ReqIF10Package.Literals.SPECIFICATION__TYPE, specType);
    }

    @Test
    public void testParentIsVirtual() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.getItemProvider(reqif.getCoreContent()).getChildren((Object)reqif.getCoreContent());
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.Literals.REQ_IF_CONTENT__SPECIFICATIONS, this.getFixture());
        ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.getFixture());
        Assert.assertTrue((boolean)(ip.getParent((Object)this.getFixture()) instanceof VirtualSpecificationsItemProvider));
    }

    @Test
    public void testCreateChildSpecObject() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.Literals.REQ_IF_CONTENT__SPECIFICATIONS, this.getFixture());
        ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.getFixture());
        List cds = (List)ip.getNewChildDescriptors((Object)this.getFixture(), (EditingDomain)this.editingDomain, null);
        Object specObjectChildDescriptor = cds.get(2);
        Command cmd = ip.createCommand((Object)this.getFixture(), (EditingDomain)this.editingDomain, CreateChildCommand.class, new CommandParameter((Object)this.getFixture(), (Object)ReqIF10Package.Literals.SPECIFICATION__CHILDREN, specObjectChildDescriptor));
        int specObjectCount = reqif.getCoreContent().getSpecObjects().size();
        this.commandStack.execute(cmd);
        Assert.assertEquals((long)1L, (long)this.getFixture().getChildren().size());
        Assert.assertEquals((long)1L, (long)cmd.getAffectedObjects().size());
        Assert.assertEquals((Object)this.getFixture().getChildren().get(0), cmd.getAffectedObjects().iterator().next());
        Assert.assertEquals((long)(specObjectCount + 1), (long)reqif.getCoreContent().getSpecObjects().size());
    }

    @Override
    protected SpecType getSpecTypeInstance() {
        return ReqIF10Factory.eINSTANCE.createSpecificationType();
    }

    @Override
    @Test
    public void testSetLastChangeAfterCreation() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        Specification id = this.getFixture();
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.eINSTANCE.getReqIFContent_Specifications(), id);
        junit.framework.Assert.assertNotNull((Object)id.getLastChange());
    }

    @Override
    protected EStructuralFeature getParentFeature() {
        return ReqIF10Package.eINSTANCE.getReqIFContent_Specifications();
    }
}

