/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.provider.VirtualSpecObjectItemProvider;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.provider.SpecElementWithAttributesTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecObjectTest
extends SpecElementWithAttributesTest {
    private ReqIF reqif;
    private SpecObject specObject;
    private SpecHierarchy specHierarchy;

    protected SpecObject getFixture() {
        return (SpecObject)this.fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture((Identifiable)ReqIF10Factory.eINSTANCE.createSpecObject());
        this.setupReqif();
    }

    @After
    public void tearDown() throws Exception {
        this.setFixture(null);
    }

    @Before
    public void setupReqif() throws URISyntaxException {
        this.reqif = this.getTestReqif("simple.reqif");
        this.specObject = (SpecObject)this.reqif.getCoreContent().getSpecObjects().get(0);
        this.specHierarchy = (SpecHierarchy)((Specification)this.reqif.getCoreContent().getSpecifications().get(0)).getChildren().get(0);
        Assert.assertEquals((Object)this.specObject, (Object)this.specHierarchy.getObject());
    }

    @Test
    public void testSpecObjectNotificationValueChanged() {
        ItemProviderAdapter ip = this.getItemProvider(this.specObject);
        ip.addListener(this.listener);
        Assert.assertEquals((long)0L, (long)this.notifications.size());
        ProrUtil.setTheValue((AttributeValue)((AttributeValue)this.specObject.getValues().get(0)), (Object)"newDescription", (EditingDomain)this.editingDomain);
        Assert.assertEquals((long)2L, (long)this.notifications.size());
        Assert.assertEquals((Object)this.specObject, (Object)((Notification)this.notifications.get(0)).getNotifier());
        Assert.assertEquals((Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)((Notification)this.notifications.get(0)).getFeature());
    }

    @Test
    public void testSpecHierarchyNotificationValueChanged() {
        this.adapterFactory.adapt((Notifier)this.specObject, IItemLabelProvider.class);
        ItemProviderAdapter ip = this.getItemProvider(this.specHierarchy);
        ip.addListener(this.listener);
        Assert.assertEquals((long)0L, (long)this.notifications.size());
        ProrUtil.setTheValue((AttributeValue)((AttributeValue)this.specObject.getValues().get(0)), (Object)"newDescription", (EditingDomain)this.editingDomain);
        Assert.assertEquals((long)2L, (long)this.notifications.size());
        Assert.assertEquals((Object)this.specHierarchy, (Object)((Notification)this.notifications.get(0)).getNotifier());
        Assert.assertEquals((Object)ReqIF10Package.Literals.SPEC_HIERARCHY__OBJECT, (Object)((Notification)this.notifications.get(0)).getFeature());
    }

    @Test
    public void testParentIsVirtual() throws URISyntaxException {
        this.reqif = this.getTestReqif("simple.reqif");
        this.getItemProvider(this.reqif.getCoreContent()).getChildren((Object)this.reqif.getCoreContent());
        this.specObject = (SpecObject)this.reqif.getCoreContent().getSpecObjects().get(0);
        ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.specObject);
        Assert.assertTrue((boolean)(ip.getParent((Object)this.specObject) instanceof VirtualSpecObjectItemProvider));
    }

    @Override
    public void addFixtureToReqIf(ReqIF reqif) {
        reqif.getCoreContent().getSpecObjects().add((Object)this.getFixture());
    }

    @Override
    protected Set<String> getStandardPropertyNames() {
        return new HashSet<String>(Arrays.asList(STANDARD_PROPERTIES));
    }

    @Override
    protected void setFixtureType(SpecElementWithAttributes specElement, SpecType specType) {
        this.setViaCommand(specElement, (EStructuralFeature)ReqIF10Package.Literals.SPEC_OBJECT__TYPE, specType);
    }

    @Override
    protected SpecType getSpecTypeInstance() {
        return ReqIF10Factory.eINSTANCE.createSpecObjectType();
    }

    @Override
    protected EStructuralFeature getParentFeature() {
        return ReqIF10Package.eINSTANCE.getReqIFContent_SpecObjects();
    }
}

