/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.core.model.review.ReviewFactory;
import org.eclipse.mylyn.reviews.core.model.review.ScopeItem;
import org.eclipse.mylyn.reviews.ui.CreateTask;
import org.eclipse.mylyn.reviews.ui.ReviewStatus;
import org.eclipse.mylyn.reviews.ui.wizard.ChooseReviewTypeWizardPage;
import org.eclipse.mylyn.reviews.ui.wizard.ReviewAssignmentPage;
import org.eclipse.mylyn.reviews.ui.wizard.ReviewScopeWizardPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Display;

public class CreateReviewWizard
extends Wizard {
    private TaskDataModel model;
    private ReviewAssignmentPage assignmentsPage;
    private ReviewScopeWizardPage scopePage;
    private ChooseReviewTypeWizardPage typePage;
    private ScopeItem scope;

    public CreateReviewWizard(TaskDataModel model) {
        this.model = model;
    }

    public CreateReviewWizard(TaskDataModel model, ScopeItem scope) {
        this(model);
        this.scope = scope;
    }

    public void addPages() {
        super.addPages();
        if (this.scope == null) {
            this.scopePage = new ReviewScopeWizardPage();
            this.typePage = new ChooseReviewTypeWizardPage();
            this.addPage((IWizardPage)this.typePage);
            this.addPage((IWizardPage)this.scopePage);
        }
        this.assignmentsPage = new ReviewAssignmentPage();
        this.addPage((IWizardPage)this.assignmentsPage);
    }

    public boolean performFinish() {
        try {
            Review review = ReviewFactory.eINSTANCE.createReview();
            review.getScope().add((Object)this.getScope());
            CreateTask createTask = new CreateTask(this.model, review, this.assignmentsPage.getReviewer());
            createTask.schedule();
            if (this.assignmentsPage.isOpenReviewOnFinish()) {
                createTask.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        super.done(event);
                        IStatus result = event.getResult();
                        if (result instanceof ReviewStatus) {
                            final ReviewStatus reviewResult = (ReviewStatus)result;
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    TasksUiInternal.synchronizeTaskInBackground((AbstractRepositoryConnector)TasksUi.getRepositoryConnector((String)reviewResult.getTask().getConnectorKind()), (ITask)reviewResult.getTask());
                                    TasksUiUtil.openTask((ITask)reviewResult.getTask());
                                }
                            });
                        }
                    }
                });
            }
        }
        catch (CoreException e1) {
            throw new RuntimeException(e1);
        }
        return true;
    }

    private ScopeItem getScope() throws CoreException {
        if (this.scope != null) {
            return this.scope;
        }
        return this.scopePage.getScope();
    }

    public TaskDataModel getModel() {
        return this.model;
    }
}

