/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.patch.IFilePatch2;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.patch.PatchParser;
import org.eclipse.compare.patch.ReaderCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.reviews.core.model.review.Patch;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.ui.Images;
import org.eclipse.mylyn.reviews.ui.ReviewDiffModel;
import org.eclipse.mylyn.reviews.ui.editors.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewTaskEditorInput
implements IEditorInput {
    private Review review;

    public ReviewTaskEditorInput(Review review) {
        this.review = review;
    }

    public Review getReview() {
        return this.review;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return Images.SMALL_ICON;
    }

    public String getName() {
        return Messages.ReviewTaskEditorInput_New_Review;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return Messages.NewReviewTaskEditorInput_Tooltip;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public List<ReviewDiffModel> getScope() {
        try {
            IFilePatch2[] patches = PatchParser.parsePatch((ReaderCreator)new ReaderCreator(){

                public Reader createReader() throws CoreException {
                    return new InputStreamReader(new ByteArrayInputStream(((Patch)ReviewTaskEditorInput.this.review.getScope().get(0)).getContents().getBytes()));
                }
            });
            ArrayList<ReviewDiffModel> model = new ArrayList<ReviewDiffModel>();
            int i = 0;
            while (i < patches.length) {
                PatchConfiguration configuration = new PatchConfiguration();
                IFilePatch2 currentPatch = patches[i];
                model.add(new ReviewDiffModel(currentPatch, configuration));
                ++i;
            }
            return model;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

