/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.reviews.core.model.review.Patch;
import org.eclipse.mylyn.reviews.core.model.review.ReviewFactory;
import org.eclipse.mylyn.reviews.ui.IPatchCreator;
import org.eclipse.mylyn.reviews.ui.Messages;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class PatchCreator
implements IPatchCreator {
    private static final Logger log = Logger.getAnonymousLogger();
    private TaskAttribute attribute;
    private ITaskAttachment taskAttachment;

    public PatchCreator(TaskAttribute attribute) {
        this.attribute = attribute;
    }

    public Patch create() throws CoreException {
        try {
            ITaskAttachment taskAttachment = this.getTaskAttachment();
            URL url = new URL(this.attribute.getMappedAttribute("task.common.attachment.url").getValue());
            Patch patch = ReviewFactory.eINSTANCE.createPatch();
            patch.setAuthor(taskAttachment.getAuthor().getName());
            patch.setCreationDate(taskAttachment.getCreationDate());
            patch.setContents(this.readContents(url));
            patch.setFileName(taskAttachment.getFileName());
            return patch;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warning(e.toString());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", Messages.PatchCreator_ReaderCreationFailed, (Throwable)e));
        }
    }

    private ITaskAttachment getTaskAttachment() {
        if (this.taskAttachment == null) {
            this.taskAttachment = ((RepositoryModel)TasksUi.getRepositoryModel()).createTaskAttachment(this.attribute);
        }
        return this.taskAttachment;
    }

    private String readContents(URL url) throws IOException {
        InputStream stream = null;
        try {
            stream = url.openStream();
            InputStreamReader reader = new InputStreamReader(stream);
            char[] buffer = new char[256];
            int readChars = 0;
            StringBuilder sb = new StringBuilder();
            while ((readChars = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, readChars);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String toString() {
        return this.attribute.getMappedAttribute("filename").getValue();
    }

    public String getFileName() {
        return this.getTaskAttachment().getFileName();
    }

    public String getAuthor() {
        return this.getTaskAttachment().getAuthor().getName();
    }

    public Date getCreationDate() {
        return this.getTaskAttachment().getCreationDate();
    }
}

