/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.eslint;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.ILog;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wildwebdeveloper.eslint.ESLintLanguageServerExtension;
import org.eclipse.wildwebdeveloper.jsts.ui.preferences.JSTSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.util.FileUtils;

public class ESLintClientImpl
extends LanguageClientImpl
implements ESLintLanguageServerExtension {
    @Override
    public CompletableFuture<Integer> confirmESLintExecution(Object param) {
        return CompletableFuture.completedFuture(4);
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        File highestPackageJsonDir;
        ConfigurationItem configurationItem = (ConfigurationItem)configurationParams.getItems().get(0);
        HashMap<String, Object> config = new HashMap<String, Object>(6, 1.0f);
        File parentFile = highestPackageJsonDir = FileUtils.uriToFile(configurationItem.getScopeUri()).getParentFile();
        while (parentFile != null) {
            if (new File(parentFile, "package.json").exists()) {
                highestPackageJsonDir = parentFile;
            }
            parentFile = parentFile.getParentFile();
        }
        config.put("experimental", Collections.emptyMap());
        config.put("problems", Collections.emptyMap());
        config.put("workspaceFolder", Collections.singletonMap("uri", FileUtils.toUri(highestPackageJsonDir).toString()));
        config.put("workingDirectory", Collections.singletonMap("mode", "auto"));
        config.put("nodePath", this.getESLintPackageDir(highestPackageJsonDir));
        config.put("validate", "on");
        config.put("run", "onType");
        config.put("rulesCustomizations", Collections.emptyList());
        config.put("codeAction", Map.of("disableRuleComment", Map.of("enable", "true", "location", "separateLine"), "showDocumentation", Collections.singletonMap("enable", "true")));
        return CompletableFuture.completedFuture(Collections.singletonList(config));
    }

    private String getESLintPackageDir(File highestPackageJsonDir) {
        String eslintNodePath = JSTSPreferenceServerConstants.getESLintNodePath();
        File eslintNodeFileUsingAbsolutePath = new File(eslintNodePath);
        if (eslintNodeFileUsingAbsolutePath.exists()) {
            return eslintNodeFileUsingAbsolutePath.getAbsolutePath();
        }
        File eslintNodeFileUsingProjectRelativePath = new File(highestPackageJsonDir.getAbsolutePath(), eslintNodePath);
        if (eslintNodeFileUsingProjectRelativePath.exists()) {
            return eslintNodeFileUsingProjectRelativePath.getAbsolutePath();
        }
        return highestPackageJsonDir.getAbsolutePath();
    }

    @Override
    public CompletableFuture<Void> eslintStatus(Object o) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> openDoc(Map<String, String> data) {
        if (data.containsKey("url")) {
            Display.getDefault().asyncExec(() -> {
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    browserSupport.createBrowser("openDoc").openURL(new URL((String)data.get("url")));
                }
                catch (Exception e) {
                    ILog.get().error(e.getMessage(), (Throwable)e);
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> noLibrary(Map<String, Map<String, String>> data) {
        MessageParams params = new MessageParams(MessageType.Info, "No ES Library found for file: " + data.get("source").get("uri"));
        this.logMessage(params);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> noConfig(Map<String, Map<String, String>> data) {
        MessageParams params = new MessageParams(MessageType.Info, "No ES Configuration found for file: " + data.get("source").get("uri") + ": " + String.valueOf(data.get("message")));
        this.logMessage(params);
        return CompletableFuture.completedFuture(null);
    }
}

