/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;

public abstract class BreakpointChange
extends Change {
    protected static final int NO_LINE_NUMBER = -1;
    private PHPLineBreakpoint fBreakpoint;
    private boolean fEnabled;

    public BreakpointChange(PHPLineBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        this.fEnabled = breakpoint.isEnabled();
    }

    protected void apply(PHPLineBreakpoint breakpoint) throws CoreException {
        breakpoint.setEnabled(this.fEnabled);
    }

    protected PHPLineBreakpoint getOriginalBreakpoint() {
        return this.fBreakpoint;
    }

    protected String getOriginalBreakpointTypeName() {
        return "";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.fBreakpoint;
    }

    protected int[] getNewLineNumberAndRange(IMember member) throws CoreException {
        ISourceRange nameRange = member.getNameRange();
        int offset = nameRange.getOffset();
        int lineNumber = this.getNewLineNumber(member, offset);
        return new int[]{lineNumber, offset, offset + nameRange.getLength()};
    }

    private int getNewLineNumber(IMember member, int offset) throws ModelException {
        int lineNumber = this.getLineNumber();
        Document document = new Document(member.getSource());
        try {
            lineNumber = document.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return lineNumber;
    }

    protected int getLineNumber() {
        return -1;
    }

    protected String getBreakpointLabel(IBreakpoint breakpoint) {
        return PHPDebugUIPlugin.getDefault().getModelPresentation().getText((Object)breakpoint);
    }
}

