/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.ui.Logger;

public class DebugServerConnectionTestRegistry {
    private static final String EXTENSION_ID = "org.eclipse.php.debug.ui.debugServerConnectionTest";
    private static final String PROP_TEST = "debugServerTest";
    private static final String PROP_DEBUGGER_TYPE = "debuggerTypeName";
    private static final String PROP_OVERRIDES_ID = "overridesId";
    private static final String PROP_ID = "id";

    private DebugServerConnectionTestRegistry() {
    }

    public static IDebugServerConnectionTest[] getTests(String debuggerId) {
        HashMap<String, IDebugServerConnectionTest> filtersMap = new HashMap<String, IDebugServerConnectionTest>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (PROP_TEST.equals(element.getName())) {
                String id;
                String debuggerTypeName = elements[i].getAttribute(PROP_DEBUGGER_TYPE);
                String overridesIds = elements[i].getAttribute(PROP_OVERRIDES_ID);
                if (debuggerTypeName.equals(PHPDebuggersRegistry.getDebuggerName((String)debuggerId)) && !filtersMap.containsKey(id = element.getAttribute(PROP_ID))) {
                    if (overridesIds != null) {
                        StringTokenizer st = new StringTokenizer(overridesIds, ", ");
                        while (st.hasMoreTokens()) {
                            filtersMap.put(st.nextToken(), null);
                        }
                    }
                    try {
                        filtersMap.put(id, (IDebugServerConnectionTest)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
            }
            ++i;
        }
        Collection testers = filtersMap.values();
        while (testers.remove(null)) {
        }
        IDebugServerConnectionTest[] debugTests = testers.toArray(new IDebugServerConnectionTest[testers.size()]);
        return debugTests;
    }
}

