/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;

public abstract class ObjectHelper {
    private ArrayList items = new ArrayList();

    public void clear() {
        this.items.clear();
        this.removeAll();
    }

    public void addItems(LabelValuePair[] newItems) {
        int i = 0;
        while (i < newItems.length) {
            this.addItem(newItems[i]);
            ++i;
        }
    }

    public void setItems(LabelValuePair[] newItems) {
        this.items.clear();
        this.removeAll();
        this.addItems(newItems);
    }

    public void addItem(LabelValuePair item) {
        this.items.add(item);
        this.addEntry(item.fLabel);
    }

    public abstract void removeAll();

    public abstract void addEntry(String var1);

    public abstract int getSelectionIndex();

    public abstract void selectIndex(int var1);

    public LabelValuePair getLabelValuePair(int index) {
        return (LabelValuePair)this.items.get(index);
    }

    public LabelValuePair getSelectedLabelValuePair() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            return this.getLabelValuePair(index);
        }
        return null;
    }

    public Object getSelectedObject() {
        LabelValuePair item = this.getSelectedLabelValuePair();
        if (item != null) {
            return this.getSelectedLabelValuePair().fValue;
        }
        return null;
    }

    public Object getObjectAt(int i) {
        if (i >= 0 && i < this.items.size()) {
            return this.getLabelValuePair((int)i).fValue;
        }
        return null;
    }

    public int indexOf(Object obj) {
        return this.indexOfValue(obj);
    }

    public int indexOfValue(Object obj) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.getLabelValuePair((int)i).fValue == null && obj == null || this.getLabelValuePair((int)i).fValue != null && this.getLabelValuePair((int)i).fValue.equals(obj)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String label) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.getLabelValuePair((int)i).fLabel.equals(label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void select(String label, Object value) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.getLabelValuePair((int)i).fValue == null && value == null || this.getLabelValuePair((int)i).fValue != null && this.getLabelValuePair((int)i).fValue.equals(value)) {
                if (label == null) {
                    this.selectIndex(i);
                    return;
                }
                if (label.equals(this.getLabelValuePair((int)i).fLabel)) {
                    this.selectIndex(i);
                    return;
                }
            }
            ++i;
        }
    }

    public void select(Object object) {
        this.select(null, object);
    }
}

