/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class ObjectArrayMapping
extends AbstractCompositeCollectionMapping {
    protected String structureName;

    @Override
    public String getStructureName() {
        return this.structureName;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getStructureName() == null || this.getStructureName().length() == 0) {
            throw DescriptorException.structureNameNotSetInMapping(this);
        }
        ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)this.getField();
        field.setSqlType(2003);
        field.setSqlTypeName(this.getStructureName());
        this.getDescriptor().setIsNativeConnectionRequired(true);
    }

    public void setFieldName(String fieldName) {
        this.setField(new ObjectRelationalDatabaseField(fieldName));
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    @Override
    protected Object buildCompositeObject(ClassDescriptor descriptor, AbstractRecord nestedRow, ObjectBuildingQuery query, CacheKey parentCacheKey, JoinedAttributeManager joinManager, AbstractSession targetSession) {
        Object element = descriptor.getObjectBuilder().buildNewInstance();
        descriptor.getObjectBuilder().buildAttributesIntoObject(element, parentCacheKey, nestedRow, query, joinManager, query.getExecutionFetchGroup(descriptor), false, targetSession);
        return element;
    }

    @Override
    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord parentRow, DatabaseMapping.WriteType writeType) {
        return this.getObjectBuilder(attributeValue, session).buildRow(attributeValue, session, writeType);
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }
}

