/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Objects;

public final class CleanerUtil {
    public static final boolean UNMAP_SUPPORTED;
    public static final String UNMAP_NOT_SUPPORTED_REASON;
    public static boolean JAVA8_OR_LESS;
    private static final MethodHandle CLEANER;

    private CleanerUtil() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object unmapHackImpl() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return unmapper.bindTo(theUnsafe);
        }
        catch (SecurityException se) {
            try {
                throw se;
                catch (ReflectiveOperationException | RuntimeException e) {
                    Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                    Method m = directBufferClass.getMethod("cleaner", new Class[0]);
                    m.setAccessible(true);
                    MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
                    TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
                    MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
                    MethodHandle nonNullTest = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
                    MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
                    MethodHandle unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                    JAVA8_OR_LESS = true;
                    return unmapper;
                }
            }
            catch (SecurityException se2) {
                return "Unmapping is not supported, because not all required permissions are given to the MapDB JAR file: " + se2 + " [Please grant at least the following permissions: RuntimePermission(\"accessClassInPackage.sun.misc\")  and ReflectPermission(\"suppressAccessChecks\")]";
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                return "Unmapping is not supported on this platform, because internal Java APIs are not compatible with this Hadoop version: " + e;
            }
        }
    }

    public static boolean freeBuffer(ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect() && UNMAP_SUPPORTED) {
            throw new IllegalArgumentException("unmapping only works with direct buffers");
        }
        try {
            CLEANER.invokeExact(buffer);
            if (JAVA8_OR_LESS) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                Object bb = directBufferClass.cast(buffer);
                Method m = directBufferClass.getMethod("attachment", new Class[0]);
                m.setAccessible(true);
                MethodHandle directBufferAttachmentMethod = lookup.unreflect(m);
                Object attachment = directBufferAttachmentMethod.invoke(bb);
                if (attachment != null) {
                    return CleanerUtil.freeBuffer((MappedByteBuffer)attachment);
                }
            }
            return true;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    static {
        Object hack = CleanerUtil.unmapHackImpl();
        if (hack instanceof MethodHandle) {
            CLEANER = (MethodHandle)CleanerUtil.unmapHackImpl();
            UNMAP_SUPPORTED = true;
            UNMAP_NOT_SUPPORTED_REASON = null;
        } else {
            CLEANER = null;
            UNMAP_SUPPORTED = false;
            UNMAP_NOT_SUPPORTED_REASON = hack.toString();
        }
    }
}

