/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;

public class DualUnionIteration<E>
implements CloseableIteration<E> {
    private final Comparator<E> cmp;
    private CloseableIteration<? extends E> iteration1;
    private CloseableIteration<? extends E> iteration2;
    private E nextElementIteration1;
    private E nextElementIteration2;
    private E nextElement;
    private boolean closed = false;

    private DualUnionIteration(CloseableIteration<? extends E> iteration1, CloseableIteration<? extends E> iteration2) {
        this.iteration1 = iteration1;
        this.iteration2 = iteration2;
        this.cmp = null;
    }

    @Experimental
    public DualUnionIteration(Comparator<E> cmp, CloseableIteration<? extends E> iteration1, CloseableIteration<? extends E> iteration2) {
        this.iteration1 = iteration1;
        this.iteration2 = iteration2;
        this.cmp = cmp;
    }

    public static <E> CloseableIteration<? extends E> getWildcardInstance(CloseableIteration<? extends E> leftIteration, CloseableIteration<? extends E> rightIteration) {
        if (leftIteration == EMPTY_STATEMENT_ITERATION) {
            return rightIteration;
        }
        if (rightIteration == EMPTY_STATEMENT_ITERATION) {
            return leftIteration;
        }
        if (rightIteration instanceof EmptyIteration) {
            return leftIteration;
        }
        if (leftIteration instanceof EmptyIteration) {
            return rightIteration;
        }
        return new DualUnionIteration<E>(leftIteration, rightIteration);
    }

    @Experimental
    public static <E> CloseableIteration<? extends E> getWildcardInstance(Comparator<E> cmp, CloseableIteration<? extends E> leftIteration, CloseableIteration<? extends E> rightIteration) {
        if (leftIteration == EMPTY_STATEMENT_ITERATION) {
            return rightIteration;
        }
        if (rightIteration == EMPTY_STATEMENT_ITERATION) {
            return leftIteration;
        }
        if (rightIteration instanceof EmptyIteration) {
            return leftIteration;
        }
        if (leftIteration instanceof EmptyIteration) {
            return rightIteration;
        }
        return new DualUnionIteration<E>(cmp, leftIteration, rightIteration);
    }

    public static <E> CloseableIteration<E> getInstance(CloseableIteration<E> leftIteration, CloseableIteration<E> rightIteration) {
        if (leftIteration == EMPTY_STATEMENT_ITERATION) {
            return rightIteration;
        }
        if (rightIteration == EMPTY_STATEMENT_ITERATION) {
            return leftIteration;
        }
        if (rightIteration instanceof EmptyIteration) {
            return leftIteration;
        }
        if (leftIteration instanceof EmptyIteration) {
            return rightIteration;
        }
        return new DualUnionIteration<E>(leftIteration, rightIteration);
    }

    @Override
    public final boolean hasNext() {
        if (this.closed) {
            return false;
        }
        return this.lookAhead() != null;
    }

    @Override
    public final E next() {
        if (this.closed) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        E result = this.lookAhead();
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private E lookAhead() {
        if (this.nextElement == null) {
            if (this.cmp == null) {
                this.lookaheadWithoutOrder();
            } else {
                this.lookaheadWithOrder();
            }
            if (this.nextElement == null) {
                this.close();
            }
        }
        return this.nextElement;
    }

    private void lookaheadWithOrder() {
        assert (this.cmp != null);
        if (this.nextElementIteration1 == null && this.iteration1 != null) {
            if (this.iteration1.hasNext()) {
                this.nextElementIteration1 = this.iteration1.next();
            } else {
                this.iteration1.close();
                this.iteration1 = null;
            }
        }
        if (this.nextElementIteration2 == null && this.iteration2 != null) {
            if (this.iteration2.hasNext()) {
                this.nextElementIteration2 = this.iteration2.next();
            } else {
                this.iteration2.close();
                this.iteration2 = null;
            }
        }
        if (this.nextElementIteration1 != null && this.nextElementIteration2 != null) {
            int compare = this.cmp.compare(this.nextElementIteration1, this.nextElementIteration2);
            if (compare <= 0) {
                this.nextElement = this.nextElementIteration1;
                this.nextElementIteration1 = null;
            } else {
                this.nextElement = this.nextElementIteration2;
                this.nextElementIteration2 = null;
            }
        } else if (this.nextElementIteration1 != null) {
            this.nextElement = this.nextElementIteration1;
            this.nextElementIteration1 = null;
        } else if (this.nextElementIteration2 != null) {
            this.nextElement = this.nextElementIteration2;
            this.nextElementIteration2 = null;
        }
    }

    private void lookaheadWithoutOrder() {
        assert (this.cmp == null);
        if (this.iteration1 == null && this.iteration2 != null) {
            if (this.iteration2.hasNext()) {
                this.nextElement = this.iteration2.next();
            } else {
                this.iteration2.close();
                this.iteration2 = null;
            }
        } else if (this.iteration1 != null) {
            if (this.iteration1.hasNext()) {
                this.nextElement = this.iteration1.next();
            } else if (this.iteration2.hasNext()) {
                this.iteration1.close();
                this.iteration1 = null;
                this.nextElement = this.iteration2.next();
            } else {
                this.iteration1.close();
                this.iteration1 = null;
                this.iteration2.close();
                this.iteration2 = null;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.nextElement = null;
            CloseableIteration<E> iteration1 = this.iteration1;
            try (CloseableIteration<E> iteration2 = this.iteration2;){
                if (iteration1 != null) {
                    iteration1.close();
                }
            }
        }
    }
}

