/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.processor;

import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import java.net.URI;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.deseralization.JsonLdToRdf;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.flattening.NodeMap;
import no.hasmac.jsonld.flattening.NodeMapBuilder;
import no.hasmac.jsonld.loader.DocumentLoaderOptions;
import no.hasmac.jsonld.processor.ExpansionProcessor;
import no.hasmac.rdf.Rdf;
import no.hasmac.rdf.RdfConsumer;
import no.hasmac.rdf.RdfDataset;
import no.hasmac.rdf.RdfValueFactory;

public final class ToRdfProcessor<Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> {
    private ToRdfProcessor() {
    }

    public static RdfDataset toRdf(URI input, JsonLdOptions options) throws JsonLdError {
        RdfDataset dataset = Rdf.createDataset();
        ToRdfProcessor.toRdf(input, options, dataset, Rdf.createValueFactory());
        return dataset;
    }

    public static RdfDataset toRdf(Document input, JsonLdOptions options) throws JsonLdError {
        RdfDataset dataset = Rdf.createDataset();
        ToRdfProcessor.toRdf(input, options, dataset, Rdf.createValueFactory());
        return dataset;
    }

    public static <Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> void toRdf(URI input, JsonLdOptions options, RdfConsumer<Triple, Quad> rdfConsumer, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(input) + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        ToRdfProcessor.toRdf(remoteDocument, options, rdfConsumer, rdfValueFactory);
    }

    public static <Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> void toRdf(Document input, JsonLdOptions options, RdfConsumer<Triple, Quad> rdfConsumer, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setProcessingMode(options.getProcessingMode());
        expansionOptions.setBase(options.getBase());
        expansionOptions.setExpandContext(options.getExpandContext());
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonLdToRdf.with(NodeMapBuilder.with((JsonStructure)expandedInput, new NodeMap()).build(), rdfConsumer, rdfValueFactory, expansionOptions).rdfDirection(options.getRdfDirection()).uriValidation(options.isUriValidation()).build();
    }
}

