/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComboViewerPart {
    private Control fCombo;
    private ComboViewer fComboViewer;
    private List<Object> fObjects;
    public static Object NULL_OBJECT = new Object();

    public void createControl(Composite parent, FormToolkit toolkit, int style) {
        if (toolkit.getBorderStyle() == 2048) {
            this.fCombo = new Combo(parent, style | 0x800);
            this.fComboViewer = new ComboViewer((Combo)this.fCombo);
        } else {
            this.fCombo = new CCombo(parent, style | 0x800000);
            this.fComboViewer = new ComboViewer((CCombo)this.fCombo);
        }
        this.fObjects = new ArrayList<Object>();
        this.fComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fComboViewer.setInput(this.fObjects);
    }

    public Control getControl() {
        return this.fCombo;
    }

    public void setEnabled(boolean enabled) {
        this.fCombo.setEnabled(enabled);
    }

    public void refresh() {
        this.fComboViewer.refresh();
    }

    public void addItem(Object item) {
        this.fObjects.add(item == null ? NULL_OBJECT : item);
        this.refresh();
    }

    public void addItem(Object item, int index) {
        this.fObjects.add(index, item == null ? NULL_OBJECT : item);
        this.refresh();
    }

    public Collection<Object> getItems() {
        return this.fObjects;
    }

    public void setItems(Object[] items) {
        this.fObjects.clear();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.fObjects.add(item == null ? NULL_OBJECT : item);
            ++n2;
        }
        this.refresh();
    }

    public void select(Object item) {
        if (item != null) {
            this.fComboViewer.setSelection((ISelection)new StructuredSelection(item));
        } else {
            this.fComboViewer.setSelection(null);
        }
    }

    public void select(int index) {
        if (index < this.fObjects.size()) {
            this.select(this.fObjects.get(index));
        }
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fComboViewer.setLabelProvider(labelProvider);
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComboViewer.setComparator(comparator);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fComboViewer.addSelectionChangedListener(listener);
    }

    public Object getSelection() {
        return this.fComboViewer.getStructuredSelection().getFirstElement();
    }
}

