/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.ui.editors.INamedElementEditor;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class ScenariosActionHandler
extends AbstractHandler {
    private final String title;

    protected ScenariosActionHandler(String title) {
        this.title = title;
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        Job job = new Job(this.title){

            protected IStatus run(final IProgressMonitor monitor) {
                ScenariosActionHandler.this.onStart();
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                IResource[] resources = LaunchUtils.getContext(selection);
                IQ7NamedElement[] scenarios = TestSuiteUtils.getElements((IResource[])resources, (boolean)true);
                monitor.beginTask(ScenariosActionHandler.this.title, scenarios.length);
                ArrayList<IStatus> errors = new ArrayList<IStatus>();
                IQ7NamedElement[] iQ7NamedElementArray = scenarios;
                int n = scenarios.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement ne = iQ7NamedElementArray[n2];
                    if (monitor.isCanceled()) break;
                    ITestCase scenario = null;
                    scenario = (ITestCase)RcpttCore.create((IResource)((IFile)ne.getResource()));
                    try {
                        final INamedElementEditor editor = ModelUtils.findEditor(ne);
                        if (editor != null) {
                            boolean wasDirty = editor.isDirty();
                            scenario = editor.getAdapter(ITestCase.class);
                            boolean changed = ScenariosActionHandler.this.doExecute(scenario);
                            if (changed && !wasDirty) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        editor.doSave(monitor);
                                    }
                                });
                            }
                        } else {
                            ScenariosActionHandler.this.doExecute(scenario);
                        }
                    }
                    catch (Throwable e) {
                        errors.add(Q7UIPlugin.createStatus(e));
                    }
                    monitor.worked(1);
                    ++n2;
                }
                ScenariosActionHandler.this.onFinish();
                if (errors.isEmpty()) {
                    return Status.OK_STATUS;
                }
                return new MultiStatus("org.eclipse.rcptt.ui", 0, errors.toArray(new IStatus[0]), null, null);
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    protected void onStart() {
    }

    protected void onFinish() {
    }

    protected abstract boolean doExecute(ITestCase var1);
}

