/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SWTUtil;
import org.eclipse.pde.internal.ds.ui.SharedImages;
import org.eclipse.pde.internal.ds.ui.wizards.DSNewClassCreationWizard;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class DSFileWizardPage
extends WizardNewFileCreationPage {
    public static final String F_PAGE_NAME = "ds";
    private static final String F_FILE_EXTENSION = "xml";
    private static final String F_DEFAULT_COMPONENT_NAME = "component.xml";
    private static final String S_COMPONENT_NAME = "component";
    private Group fGroup;
    private Text fDSComponentNameText;
    private Label fDSComponentNameLabel;
    private Text fDSImplementationClassText;
    private Link fDSImplementationClassHyperlink;
    private Button fDSImplementationClassButton;
    private final IStructuredSelection fSelection;

    public DSFileWizardPage(IStructuredSelection selection) {
        super(F_PAGE_NAME, selection);
        this.fSelection = selection;
        this.initialize();
    }

    protected void initialize() {
        this.setTitle(Messages.DSFileWizardPage_title);
        this.setDescription(Messages.DSFileWizardPage_description);
        this.setImageDescriptor(SharedImages.getImageDescriptor("icons/wizban/defcon_wiz.svg"));
        this.setFileExtension(F_FILE_EXTENSION);
    }

    private void setComponentName() {
        IProject project;
        Object element = this.fSelection.getFirstElement();
        if (element != null && (project = this.getProject(element)) != null) {
            this.setComponentNameText(project);
        }
        if (this.fDSComponentNameText.getText().trim().length() == 0) {
            this.fDSComponentNameText.setText(Messages.DSFileWizardPage_ExampleComponentName);
        }
    }

    private IProject getProject(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getProject();
        }
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            return javaElement.getJavaProject().getProject();
        }
        return null;
    }

    private void setComponentNameText(IProject project) {
        if (PluginProject.isPluginProject((IProject)project)) {
            WorkspaceBundlePluginModel model = new WorkspaceBundlePluginModel(PDEProject.getManifest((IProject)project), null);
            model.load();
            String header = model.getBundleModel().getBundle().getHeader("Bundle-SymbolicName");
            String[] h = header.split(";");
            this.fDSComponentNameText.setText(h[0]);
        }
    }

    protected void createAdvancedControls(Composite parent) {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String component = settings.get(S_COMPONENT_NAME);
            if (component != null && !component.equals("")) {
                this.setFileName(component);
            } else {
                this.setFileName(F_DEFAULT_COMPONENT_NAME);
            }
        } else {
            this.setFileName(F_DEFAULT_COMPONENT_NAME);
        }
        this.fGroup = new Group(parent, 0);
        this.fGroup.setText(Messages.DSFileWizardPage_group);
        this.fGroup.setLayout((Layout)new GridLayout(3, false));
        this.fGroup.setLayoutData((Object)new GridData(768));
        GridData nameTextGridData = new GridData(768);
        nameTextGridData.horizontalSpan = 2;
        nameTextGridData.horizontalIndent = 3;
        this.fDSComponentNameLabel = new Label((Composite)this.fGroup, 0);
        this.fDSComponentNameLabel.setText(Messages.DSFileWizardPage_component_name);
        this.fDSComponentNameText = new Text((Composite)this.fGroup, 2052);
        this.fDSComponentNameText.setLayoutData((Object)nameTextGridData);
        this.fDSComponentNameText.setText("");
        this.fDSComponentNameText.addModifyListener(e -> this.setPageComplete(this.isPageComplete()));
        this.setComponentName();
        this.fDSImplementationClassHyperlink = new Link((Composite)this.fGroup, 0);
        this.fDSImplementationClassHyperlink.setText("<a>" + Messages.DSFileWizardPage_implementation_class + "</a>");
        this.fDSImplementationClassHyperlink.setForeground(Display.getDefault().getSystemColor(9));
        this.fDSImplementationClassHyperlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = DSFileWizardPage.this.fDSImplementationClassText.getText();
                if ((value = this.handleLinkActivated(value, false)) != null) {
                    DSFileWizardPage.this.fDSImplementationClassText.setText(value);
                }
            }

            private String handleLinkActivated(String value, boolean isInter) {
                Object object = DSFileWizardPage.this.fSelection.getFirstElement();
                if (object != null) {
                    IProject project = DSFileWizardPage.this.getProject(object);
                    try {
                        if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            IType element = javaProject.findType(value.replace('$', '.'));
                            if (element != null) {
                                JavaUI.openInEditor((IJavaElement)element);
                            } else {
                                DSNewClassCreationWizard wizard = new DSNewClassCreationWizard(project, isInter, value);
                                WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
                                dialog.create();
                                SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                                if (dialog.open() == 0) {
                                    return wizard.getQualifiedName();
                                }
                            }
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        this.fDSImplementationClassText = new Text((Composite)this.fGroup, 2052);
        GridData classTextGridData = new GridData(768);
        classTextGridData.horizontalSpan = 1;
        classTextGridData.horizontalIndent = 3;
        this.fDSImplementationClassText.setLayoutData((Object)classTextGridData);
        this.fDSImplementationClassText.setText("Component");
        this.fDSImplementationClassText.addModifyListener(e -> this.setPageComplete(this.isPageComplete()));
        this.fDSImplementationClassButton = new Button((Composite)this.fGroup, 0);
        this.fDSImplementationClassButton.setText(Messages.DSFileWizardPage_browse);
        this.fDSImplementationClassButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                this.doOpenSelectionDialog(2, DSFileWizardPage.this.fDSImplementationClassText);
            }

            private void doOpenSelectionDialog(int scopeType, Text entry) {
                try {
                    String filter = entry.getText();
                    filter = filter.substring(filter.lastIndexOf(".") + 1);
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
                    dialog.setTitle(Messages.DSFileWizardPage_selectType);
                    if (dialog.open() == 0) {
                        IType type = (IType)dialog.getResult()[0];
                        entry.setText(type.getFullyQualifiedName('$'));
                    }
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
        });
    }

    public String getDSComponentNameValue() {
        return this.fDSComponentNameText.getText();
    }

    public String getDSImplementationClassValue() {
        return this.fDSImplementationClassText.getText();
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    protected void createLinkTarget() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.fGroup);
    }

    public boolean isPageComplete() {
        return this.validatePage();
    }

    public void saveSettings(IDialogSettings settings) {
        settings.put(S_COMPONENT_NAME, this.getFileName());
    }

    protected boolean validatePage() {
        if (this.fDSComponentNameText == null || this.fDSImplementationClassText == null) {
            return false;
        }
        if (this.getFileName() == null || this.getFileName().length() == 0) {
            this.setErrorMessage(Messages.DSFileWizardPage_ComponentNeedsFileName);
            return false;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(this.fDSImplementationClassText.getText().trim(), 1);
        if (!status.isOK()) {
            this.setErrorMessage(Messages.DSFileWizardPage_ComponentNeedsClass);
            return false;
        }
        return super.validatePage();
    }
}

