/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.delete.AbstractDeleteVerificationReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.UndoDeleteVerificationReferenceChange;

public class DeleteVerificationReferenceChange
extends AbstractDeleteVerificationReferenceChange {
    public DeleteVerificationReferenceChange(IQ7Element element, IVerification verification, String id) {
        super(element, verification, id);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            IQ7NamedElement e = (IQ7NamedElement)this.getElement();
            IQ7NamedElement copy = null;
            try {
                copy = e.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                List<String> references = this.getVerificationReferences(copy);
                int index = references.indexOf(this.getVerificationId());
                if (index != -1) {
                    NamedElement namedElement;
                    references.remove(index);
                    if (copy instanceof ITestCase) {
                        ((ITestCase)copy).setVerifications(references.toArray(new String[references.size()]));
                    } else if (copy instanceof IQ7ProjectMetadata && (namedElement = copy.getNamedElement()) instanceof ProjectMetadata) {
                        ProjectMetadata meta = (ProjectMetadata)namedElement;
                        meta.getVerifications().clear();
                        meta.getVerifications().addAll(references);
                    }
                    copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                    UndoDeleteVerificationReferenceChange undoDeleteVerificationReferenceChange = new UndoDeleteVerificationReferenceChange(this.getElement(), (IFile)this.getElement().getResource(), this.getVerification(), this.getVerificationId(), index);
                    return undoDeleteVerificationReferenceChange;
                }
            }
            finally {
                copy.discardWorkingCopy();
            }
            {
            }
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return Messages.bind((String)Messages.DeleteContextReferenceChange_Name, (Object)this.getVerification().getName(), (Object)this.getElement().getName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.DeleteContextReferenceChange_InvalidRefMsg);
        }
        return new RefactoringStatus();
    }

    @Override
    protected boolean isValid() throws ModelException {
        if (!super.isValid()) {
            return false;
        }
        IQ7NamedElement element = (IQ7NamedElement)this.getElement();
        IQ7NamedElement copy = null;
        try {
            copy = element.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            List<String> references = this.getVerificationReferences(copy);
            boolean bl = references.contains(this.getVerificationId());
            return bl;
        }
        finally {
            copy.discardWorkingCopy();
        }
    }
}

