/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.CachingRepository;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.RepositoryListener;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.FS;

class RepositoryHandle
extends Repository {
    private final Repository delegate;
    private final List<ListenerHandle> listeners = new ArrayList<ListenerHandle>();

    RepositoryHandle(Repository delegate) {
        super((BaseRepositoryBuilder)new RepositoryBuilder());
        Assert.isLegal((!(delegate instanceof RepositoryHandle) ? 1 : 0) != 0, (String)"Delegate of a RepositoryHandle must not be another RepositoryHandle");
        this.delegate = delegate;
        RepositoryHandle.addListeners(this.listeners, delegate.getListenerList(), new WeakReference<RepositoryHandle>(this));
    }

    private static void addListeners(List<ListenerHandle> listeners, ListenerList list, WeakReference<RepositoryHandle> ref) {
        listeners.add(list.addConfigChangedListener(event -> {
            Repository repo = (Repository)ref.get();
            if (repo != null) {
                RepositoryHandle.fireEvent(repo, (RepositoryEvent<? extends RepositoryListener>)new ConfigChangedEvent());
            }
        }));
        listeners.add(list.addIndexChangedListener(event -> {
            Repository repo = (Repository)ref.get();
            if (repo != null) {
                RepositoryHandle.fireEvent(repo, (RepositoryEvent<? extends RepositoryListener>)new IndexChangedEvent(event.isInternal()));
            }
        }));
        listeners.add(list.addRefsChangedListener(event -> {
            Repository repo = (Repository)ref.get();
            if (repo != null) {
                RepositoryHandle.fireEvent(repo, (RepositoryEvent<? extends RepositoryListener>)new RefsChangedEvent());
            }
        }));
        listeners.add(list.addWorkingTreeModifiedListener(event -> {
            Repository repo = (Repository)ref.get();
            if (repo != null) {
                RepositoryHandle.fireEvent(repo, (RepositoryEvent<? extends RepositoryListener>)new WorkingTreeModifiedEvent(event.getModified(), event.getDeleted()));
            }
        }));
    }

    private static void fireEvent(Repository repo, RepositoryEvent<? extends RepositoryListener> event) {
        event.setRepository(repo);
        repo.getListenerList().dispatch(event);
    }

    Repository getDelegate() {
        return this.delegate;
    }

    public final ListenerList getListenerList() {
        return super.getListenerList();
    }

    public final void fireEvent(RepositoryEvent<?> event) {
        super.fireEvent(event);
    }

    public final void incrementOpen() {
        super.incrementOpen();
    }

    public final void close() {
        if (this.delegate instanceof CachingRepository) {
            ((CachingRepository)this.delegate).clearConfigCache();
        }
        super.close();
    }

    protected void doClose() {
        this.listeners.forEach(ListenerHandle::remove);
        this.listeners.clear();
        this.delegate.close();
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.delegate.toString() + "]";
    }

    public void create() throws IOException {
        this.delegate.create();
    }

    public void create(boolean bare) throws IOException {
        this.delegate.create(bare);
    }

    public File getDirectory() {
        return this.delegate.getDirectory();
    }

    public String getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public ObjectDatabase getObjectDatabase() {
        return this.delegate.getObjectDatabase();
    }

    public ObjectInserter newObjectInserter() {
        return this.delegate.newObjectInserter();
    }

    public ObjectReader newObjectReader() {
        return this.delegate.newObjectReader();
    }

    public RefDatabase getRefDatabase() {
        return this.delegate.getRefDatabase();
    }

    public StoredConfig getConfig() {
        return this.delegate.getConfig();
    }

    public AttributesNodeProvider createAttributesNodeProvider() {
        return this.delegate.createAttributesNodeProvider();
    }

    public FS getFS() {
        return this.delegate.getFS();
    }

    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.delegate.open(objectId);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.delegate.open(objectId, typeHint);
    }

    public RefUpdate updateRef(String ref) throws IOException {
        return this.delegate.updateRef(ref);
    }

    public RefUpdate updateRef(String ref, boolean detach) throws IOException {
        return this.delegate.updateRef(ref, detach);
    }

    public RefRename renameRef(String fromRef, String toRef) throws IOException {
        return this.delegate.renameRef(fromRef, toRef);
    }

    public ObjectId resolve(String revstr) throws AmbiguousObjectException, IncorrectObjectTypeException, RevisionSyntaxException, IOException {
        return this.delegate.resolve(revstr);
    }

    public String simplify(String revstr) throws AmbiguousObjectException, IOException {
        return this.delegate.simplify(revstr);
    }

    public String getFullBranch() throws IOException {
        return this.delegate.getFullBranch();
    }

    public String getBranch() throws IOException {
        return this.delegate.getBranch();
    }

    public Set<ObjectId> getAdditionalHaves() throws IOException {
        return this.delegate.getAdditionalHaves();
    }

    public Map<AnyObjectId, Set<Ref>> getAllRefsByPeeledObjectId() throws IOException {
        return this.delegate.getAllRefsByPeeledObjectId();
    }

    public File getIndexFile() throws NoWorkTreeException {
        return this.delegate.getIndexFile();
    }

    public RevCommit parseCommit(AnyObjectId id) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        return this.delegate.parseCommit(id);
    }

    public DirCache readDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return this.delegate.readDirCache();
    }

    public DirCache lockDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return this.delegate.lockDirCache();
    }

    public RepositoryState getRepositoryState() {
        return this.delegate.getRepositoryState();
    }

    public boolean isBare() {
        return this.delegate.isBare();
    }

    public File getWorkTree() throws NoWorkTreeException {
        return this.delegate.getWorkTree();
    }

    public void scanForRepoChanges() throws IOException {
        this.delegate.scanForRepoChanges();
    }

    public void notifyIndexChanged(boolean internal) {
        this.delegate.notifyIndexChanged(internal);
    }

    public String shortenRemoteBranchName(String refName) {
        return this.delegate.shortenRemoteBranchName(refName);
    }

    public String getRemoteName(String refName) {
        return this.delegate.getRemoteName(refName);
    }

    public String getGitwebDescription() throws IOException {
        return this.delegate.getGitwebDescription();
    }

    public void setGitwebDescription(String description) throws IOException {
        this.delegate.setGitwebDescription(description);
    }

    public ReflogReader getReflogReader(String refName) throws IOException {
        return this.delegate.getReflogReader(refName);
    }

    public String readMergeCommitMsg() throws IOException, NoWorkTreeException {
        return this.delegate.readMergeCommitMsg();
    }

    public void writeMergeCommitMsg(String msg) throws IOException {
        this.delegate.writeMergeCommitMsg(msg);
    }

    public String readCommitEditMsg() throws IOException, NoWorkTreeException {
        return this.delegate.readCommitEditMsg();
    }

    public void writeCommitEditMsg(String msg) throws IOException {
        this.delegate.writeCommitEditMsg(msg);
    }

    public List<ObjectId> readMergeHeads() throws IOException, NoWorkTreeException {
        return this.delegate.readMergeHeads();
    }

    public void writeMergeHeads(List<? extends ObjectId> heads) throws IOException {
        this.delegate.writeMergeHeads(heads);
    }

    public ObjectId readCherryPickHead() throws IOException, NoWorkTreeException {
        return this.delegate.readCherryPickHead();
    }

    public ObjectId readRevertHead() throws IOException, NoWorkTreeException {
        return this.delegate.readRevertHead();
    }

    public void writeCherryPickHead(ObjectId head) throws IOException {
        this.delegate.writeCherryPickHead(head);
    }

    public void writeRevertHead(ObjectId head) throws IOException {
        this.delegate.writeRevertHead(head);
    }

    public void writeOrigHead(ObjectId head) throws IOException {
        this.delegate.writeOrigHead(head);
    }

    public ObjectId readOrigHead() throws IOException, NoWorkTreeException {
        return this.delegate.readOrigHead();
    }

    public String readSquashCommitMsg() throws IOException {
        return this.delegate.readSquashCommitMsg();
    }

    public void writeSquashCommitMsg(String msg) throws IOException {
        this.delegate.writeSquashCommitMsg(msg);
    }

    public List<RebaseTodoLine> readRebaseTodo(String path, boolean includeComments) throws IOException {
        return this.delegate.readRebaseTodo(path, includeComments);
    }

    public void writeRebaseTodoFile(String path, List<RebaseTodoLine> steps, boolean append) throws IOException {
        this.delegate.writeRebaseTodoFile(path, steps, append);
    }

    public Set<String> getRemoteNames() {
        return this.delegate.getRemoteNames();
    }

    public void autoGC(ProgressMonitor monitor) {
        this.delegate.autoGC(monitor);
    }

    public File getCommonDirectory() {
        return this.delegate.getCommonDirectory();
    }
}

