/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.rcptt.internal.launching.ExecutionSession;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.util.FileUtil;
import org.osgi.framework.BundleContext;

public class Q7LaunchingPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.launching";
    public static final String EXECUTION_TIMEOUT = "EXECUTION_TIMEOUT";
    public static final String SHUTDOWN_TIMEOUT = "SHUTDOWN_TIMEOUT";
    private static Q7LaunchingPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job cleanPreviousExecutionSessions = new Job("RCPTT: Clean execution sessions"){

            protected IStatus run(IProgressMonitor monitor) {
                File root = Q7LaunchingPlugin.getDefault().getStateLocation().toFile();
                if (root.exists()) {
                    FileUtil.deleteFiles((File[])root.listFiles());
                }
                return Status.OK_STATUS;
            }
        };
        cleanPreviousExecutionSessions.setSystem(true);
        cleanPreviousExecutionSessions.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        Q7LaunchManager.getInstance().shutdown();
        plugin = null;
        super.stop(context);
    }

    public static Q7LaunchingPlugin getDefault() {
        return plugin;
    }

    public static void abort(String message, Throwable t) throws CoreException {
        throw new CoreException(Q7LaunchingPlugin.createStatus(message, t));
    }

    public static void abort(String message) throws CoreException {
        throw new CoreException(Q7LaunchingPlugin.createStatus(message));
    }

    public static void log(Throwable t) {
        Q7LaunchingPlugin.log(t.getMessage(), t);
    }

    public static void log(String message, Throwable t) {
        Q7LaunchingPlugin.log(Q7LaunchingPlugin.createStatus(message, t));
    }

    public static void log(String message) {
        Q7LaunchingPlugin.log(Q7LaunchingPlugin.createStatus(message));
    }

    public static void log(IStatus status) {
        if (Q7LaunchingPlugin.getDefault() != null) {
            Q7LaunchingPlugin.getDefault().getLog().log(status);
        }
    }

    public static void logInfo(String format, Object ... args) {
        Q7LaunchingPlugin.log((IStatus)new Status(1, PLUGIN_ID, String.format(format, args)));
    }

    public static IStatus createStatus(String message) {
        return Q7LaunchingPlugin.createStatus(message, null);
    }

    public static IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public static IStatus createStatus(String message, Throwable t) {
        if (t instanceof CoreException) {
            return new MultiStatus(PLUGIN_ID, 0, new IStatus[]{((CoreException)t).getStatus()}, message, null);
        }
        return new Status(4, PLUGIN_ID, message, t);
    }

    public static IStatus createStatus(Throwable t) {
        if (t instanceof CoreException) {
            return ((CoreException)t).getStatus();
        }
        return new Status(4, PLUGIN_ID, t.getMessage(), t);
    }

    public static IStatus createStatus(int state, String message, Throwable t) {
        return new Status(state, PLUGIN_ID, message, t);
    }

    public static synchronized File getExecutionSessionRoot(String name, ExecutionSession executionSession) {
        File bundles = Q7LaunchingPlugin.getDefault().getStateLocation().toFile();
        bundles.mkdirs();
        int index = 0;
        File f;
        while ((f = new File(bundles, FileUtil.rlimitSize((String)("s_" + name), (int)10) + "_" + index)).exists()) {
            ++index;
        }
        return f;
    }
}

