/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.releng;

import java.io.File;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ui.wizard.releng.Messages;
import org.eclipse.xtext.xtext.ui.wizard.releng.PDEUtils;
import org.eclipse.xtext.xtext.ui.wizard.releng.RelengProjectInfo;

public class ProjectInfoBinder {
    private final DataBindingContext dbc;
    private final RelengProjectInfo projectInfo;

    public ProjectInfoBinder(DataBindingContext dbc, RelengProjectInfo projectInfo) {
        this.dbc = dbc;
        this.projectInfo = projectInfo;
    }

    public IObservableValue bindFeatureProjectField(Control featureProjectField) {
        IObservableValue featPrjObserv = PojoObservables.observeValue((Object)((Object)this.projectInfo), (String)"buildFeatureName");
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)featureProjectField, (int)24), featPrjObserv, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setBeforeSetValidator((IValidator)new FeatureProjectValidator()), null);
        return featPrjObserv;
    }

    public void bindTestLaunchers(StructuredViewer testsList) {
        WritableList observeList = new WritableList(this.projectInfo.getTestLaunchers(), IFile.class);
        testsList.setInput((Object)observeList);
        testsList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
    }

    public void bindBuckyLocationField(Text buckyField) {
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)buckyField, (int)24), PojoObservables.observeValue((Object)((Object)this.projectInfo), (String)"buckyLocation"), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setBeforeSetValidator((IValidator)new BuckminsterLocationValidator()), null);
    }

    public void bindSiteProjectField(Text sitePrjField, IObservableValue featPrjObserv) {
        IObservableValue siteFeatureObservable = PojoObservables.observeValue((Object)((Object)this.projectInfo), (String)"siteFeatureProjectName");
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)sitePrjField, (int)24), siteFeatureObservable);
        this.dbc.bindValue(featPrjObserv, siteFeatureObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new SuffixedNameComputedValue(this.projectInfo, "site")), null);
    }

    public void bindProjectField(Text prjField, IObservableValue featPrjObserv) {
        IObservableValue prjObserv = PojoObservables.observeValue((Object)((Object)this.projectInfo), (String)"projectName");
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)prjField, (int)24), prjObserv);
        this.dbc.bindValue(featPrjObserv, prjObserv, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new SuffixedNameComputedValue(this.projectInfo, "buckminster")), null);
    }

    private static class BuckminsterLocationValidator
    implements IValidator {
        private BuckminsterLocationValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null || Strings.isEmpty((String)value.toString())) {
                return ValidationStatus.warning((String)Messages.ProjectInfoBinder_warnBuckyHeadlessNotSet);
            }
            File buckyHeadless = new File(value.toString());
            File[] files = buckyHeadless.listFiles();
            boolean buckminsterExecutableFound = false;
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile() && "buckminster".equals(file.getName())) {
                        buckminsterExecutableFound = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!buckminsterExecutableFound) {
                return ValidationStatus.warning((String)NLS.bind((String)Messages.ProjectInfoBinder_warnNotBucky, (Object)buckyHeadless));
            }
            return ValidationStatus.ok();
        }
    }

    private static class FeatureProjectValidator
    implements IValidator {
        private FeatureProjectValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null || Strings.isEmpty((String)value.toString())) {
                return ValidationStatus.error((String)Messages.ProjectInfoBinder_errorFeatureNotSelected);
            }
            String featureProjectName = value.toString();
            if (!PDEUtils.featureProjectExists(featureProjectName)) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.ProjectInfoBinder_errorFeatureNotExists, (Object)featureProjectName));
            }
            return ValidationStatus.ok();
        }
    }

    private static final class SuffixedNameComputedValue
    extends Converter {
        private final String suffix;
        private final RelengProjectInfo projectInfo;

        public SuffixedNameComputedValue(RelengProjectInfo projectInfo, String suffix) {
            super(String.class, String.class);
            this.projectInfo = projectInfo;
            this.suffix = suffix;
        }

        public Object convert(Object fromObject) {
            return this.calculateProjectName();
        }

        private String calculateProjectName() {
            String nameSpace = this.projectInfo.getProjectNameSpace();
            if (Strings.isEmpty((String)nameSpace)) {
                return "";
            }
            String projectsuffix = this.findNextValidProjectSuffix(nameSpace, this.suffix);
            return String.valueOf(nameSpace) + "." + projectsuffix;
        }

        private String findNextValidProjectSuffix(String prefix, String name) {
            String candidate = name;
            int suffix = 1;
            while (ResourcesPlugin.getWorkspace().getRoot().getProject((String.valueOf(prefix) + "." + candidate).toLowerCase()).exists()) {
                candidate = String.valueOf(name) + suffix;
                ++suffix;
            }
            return candidate;
        }
    }
}

