/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.interpreter;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValueBinaryOperation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class ConstantExpressionsInterpreter {
    public Object evaluate(XExpression expression, LightweightTypeReference expectedType) {
        Object _switchResult = null;
        boolean _matched = false;
        if (!_matched && expression instanceof XStringLiteral) {
            String _value_1;
            boolean _equals;
            XStringLiteral _xStringLiteral = (XStringLiteral)expression;
            _matched = true;
            String _xblockexpression = null;
            String _simpleName = null;
            if (expectedType != null) {
                _simpleName = expectedType.getSimpleName();
            }
            if (_equals = Objects.equal((Object)_simpleName, (Object)"char")) {
                String _value = _xStringLiteral.getValue();
                _value.charAt(0);
            }
            _xblockexpression = _value_1 = _xStringLiteral.getValue();
            _switchResult = _xblockexpression;
        }
        if (!_matched && expression instanceof XBooleanLiteral) {
            XBooleanLiteral _xBooleanLiteral = (XBooleanLiteral)expression;
            _matched = true;
            boolean _isIsTrue = _xBooleanLiteral.isIsTrue();
            _switchResult = _isIsTrue;
        }
        if (!_matched && expression instanceof XNumberLiteral) {
            XNumberLiteral _xNumberLiteral = (XNumberLiteral)expression;
            _matched = true;
            Number _switchResult_1 = null;
            boolean _matched_1 = false;
            if (!_matched_1) {
                boolean _equals;
                String _simpleName = null;
                if (expectedType != null) {
                    _simpleName = expectedType.getSimpleName();
                }
                if (_equals = Objects.equal((Object)_simpleName, (Object)"long")) {
                    _matched_1 = true;
                    String _value = _xNumberLiteral.getValue();
                    Long _valueOf = Long.valueOf(_value);
                    _switchResult_1 = _valueOf;
                }
            }
            if (!_matched_1) {
                boolean _equals_1;
                String _simpleName_1 = null;
                if (expectedType != null) {
                    _simpleName_1 = expectedType.getSimpleName();
                }
                if (_equals_1 = Objects.equal((Object)_simpleName_1, (Object)"short")) {
                    _matched_1 = true;
                    String _value_1 = _xNumberLiteral.getValue();
                    Short _valueOf_1 = Short.valueOf(_value_1);
                    _switchResult_1 = _valueOf_1;
                }
            }
            if (!_matched_1) {
                boolean _equals_2;
                String _simpleName_2 = null;
                if (expectedType != null) {
                    _simpleName_2 = expectedType.getSimpleName();
                }
                if (_equals_2 = Objects.equal((Object)_simpleName_2, (Object)"byte")) {
                    _matched_1 = true;
                    String _value_2 = _xNumberLiteral.getValue();
                    Byte _valueOf_2 = Byte.valueOf(_value_2);
                    _switchResult_1 = _valueOf_2;
                }
            }
            if (!_matched_1) {
                boolean _equals_3;
                String _simpleName_3 = null;
                if (expectedType != null) {
                    _simpleName_3 = expectedType.getSimpleName();
                }
                if (_equals_3 = Objects.equal((Object)_simpleName_3, (Object)"float")) {
                    _matched_1 = true;
                    String _value_3 = _xNumberLiteral.getValue();
                    Float _valueOf_3 = Float.valueOf(_value_3);
                    _switchResult_1 = _valueOf_3;
                }
            }
            if (!_matched_1) {
                boolean _equals_4;
                String _simpleName_4 = null;
                if (expectedType != null) {
                    _simpleName_4 = expectedType.getSimpleName();
                }
                if (_equals_4 = Objects.equal((Object)_simpleName_4, (Object)"double")) {
                    _matched_1 = true;
                    String _value_4 = _xNumberLiteral.getValue();
                    Double _valueOf_4 = Double.valueOf(_value_4);
                    _switchResult_1 = _valueOf_4;
                }
            }
            if (!_matched_1) {
                Integer _valueOf_5;
                String _value_5 = _xNumberLiteral.getValue();
                _switchResult_1 = _valueOf_5 = Integer.valueOf(_value_5);
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched && expression instanceof XTypeLiteral) {
            XTypeLiteral _xTypeLiteral = (XTypeLiteral)expression;
            _matched = true;
            JvmType _type = _xTypeLiteral.getType();
            _switchResult = _type;
        }
        if (!_matched && expression instanceof XAnnotation) {
            XAnnotation _xAnnotation = (XAnnotation)expression;
            _matched = true;
            _switchResult = _xAnnotation;
        }
        if (!_matched && expression instanceof XListLiteral) {
            Object[] _array;
            Object[] array;
            int _size;
            Object[] _xblockexpression_1;
            Object _head;
            XListLiteral _xListLiteral = (XListLiteral)expression;
            _matched = true;
            String[] _xblockexpression = null;
            EList<XExpression> _elements = _xListLiteral.getElements();
            Functions.Function1<XExpression, Object> _function = new Functions.Function1<XExpression, Object>(){

                public Object apply(XExpression it) {
                    Object _evaluate = ConstantExpressionsInterpreter.this.evaluate(it, null);
                    return _evaluate;
                }
            };
            List results = ListExtensions.map(_elements, (Functions.Function1)_function);
            Object[] _switchResult_1 = null;
            Object _switchValue = _head = IterableExtensions.head((Iterable)results);
            boolean _matched_1 = false;
            if (!_matched_1 && _switchValue instanceof String) {
                String _string = (String)_switchValue;
                _matched_1 = true;
                _xblockexpression_1 = null;
                _size = results.size();
                array = new String[_size];
                _array = results.toArray(array);
                _xblockexpression_1 = _array;
                _switchResult_1 = _xblockexpression_1;
            }
            if (!_matched_1 && _switchValue instanceof JvmType) {
                JvmType _jvmType = (JvmType)_switchValue;
                _matched_1 = true;
                _xblockexpression_1 = null;
                _size = results.size();
                array = new JvmType[_size];
                _array = (JvmType[])results.toArray(array);
                _xblockexpression_1 = _array;
                _switchResult_1 = _xblockexpression_1;
            }
            if (!_matched_1 && _switchValue instanceof Integer) {
                Integer _integer = (Integer)_switchValue;
                _matched_1 = true;
                _xblockexpression_1 = null;
                _size = results.size();
                array = new Integer[_size];
                _array = (Integer[])results.toArray(array);
                _xblockexpression_1 = _array;
                _switchResult_1 = _xblockexpression_1;
            }
            _xblockexpression = _switchResult_1;
            _switchResult = _xblockexpression;
        }
        if (!_matched && expression instanceof XBinaryOperation) {
            XBinaryOperation _xBinaryOperation = (XBinaryOperation)expression;
            _matched = true;
            XExpression _leftOperand = _xBinaryOperation.getLeftOperand();
            Object leftVal = this.evaluate(_leftOperand, null);
            XExpression _rightOperand = _xBinaryOperation.getRightOperand();
            Object rightVal = this.evaluate(_rightOperand, null);
            return this.plus(leftVal, rightVal);
        }
        if (!_matched && expression instanceof XAnnotationElementValueBinaryOperation) {
            String _operator;
            XAnnotationElementValueBinaryOperation _xAnnotationElementValueBinaryOperation = (XAnnotationElementValueBinaryOperation)expression;
            _matched = true;
            Object _switchResult_1 = null;
            String _switchValue = _operator = _xAnnotationElementValueBinaryOperation.getOperator();
            boolean _matched_1 = false;
            if (!_matched_1 && Objects.equal((Object)_switchValue, (Object)"+")) {
                _matched_1 = true;
                XExpression _leftOperand = _xAnnotationElementValueBinaryOperation.getLeftOperand();
                Object leftVal = this.evaluate(_leftOperand, null);
                XExpression _rightOperand = _xAnnotationElementValueBinaryOperation.getRightOperand();
                Object rightVal = this.evaluate(_rightOperand, null);
                return this.plus(leftVal, rightVal);
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched) {
            String _plus = "Couldn't interpret expression : " + expression;
            String _plus_1 = String.valueOf(_plus) + ".";
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_1);
            throw _illegalArgumentException;
        }
        return _switchResult;
    }

    protected Object _plus(Object a, Object b) {
        String _plus = "was left:" + a;
        String _plus_1 = String.valueOf(_plus) + ", right:";
        String _plus_2 = String.valueOf(_plus_1) + b;
        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_2);
        throw _illegalArgumentException;
    }

    protected int _plus(Integer a, Integer b) {
        int _plus = a + b;
        return _plus;
    }

    protected Object _plus(String a, Object b) {
        String _plus = String.valueOf(a) + b;
        return _plus;
    }

    public Object plus(Object a, Object b) {
        if (a instanceof Integer && b instanceof Integer) {
            return this._plus((Integer)a, (Integer)b);
        }
        if (a instanceof String && b != null) {
            return this._plus((String)a, b);
        }
        if (a != null && b != null) {
            return this._plus(a, b);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a, b).toString());
    }
}

