/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationValueArray;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.compiler.CompilationStrategyAdapter;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.util.ToStringHelper;
import org.eclipse.xtext.xbase.typing.NumberLiterals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class JvmTypesBuilder {
    private static final Logger LOG = Logger.getLogger(JvmTypesBuilder.class);
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private TypeReferences references;
    @Inject
    private ClassURIHelper uriHelper;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private NumberLiterals numberLiterals;
    @Inject
    private TypesFactory typesFactory;
    @Inject
    private VisibilityService visibilityService;
    private Map<EClass, AnnotationValueTranslator> translators = Maps.newLinkedHashMap();

    public <T> boolean operator_add(@Nullable EList<? super T> list, @Nullable T element) {
        if (list != null && element != null) {
            return list.add(element);
        }
        return false;
    }

    public <T> boolean operator_add(@Nullable EList<? super T> list, @Nullable Iterable<? extends T> elements) {
        boolean result = false;
        if (list != null && elements != null) {
            for (T element : elements) {
                result |= this.operator_add(list, element);
            }
        }
        return result;
    }

    public void setBody(@Nullable JvmExecutable logicalContainer, @Nullable XExpression expr) {
        if (logicalContainer == null || expr == null) {
            return;
        }
        this.removeExistingBody((JvmMember)logicalContainer);
        this.associator.associateLogicalContainer(expr, (JvmIdentifiableElement)logicalContainer);
    }

    protected void removeExistingBody(@Nullable JvmMember member) {
        if (member != null) {
            Iterator iterator = member.eAdapters().iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof CompilationStrategyAdapter)) continue;
                iterator.remove();
            }
            this.associator.removeLogicalChildAssociation((JvmIdentifiableElement)member);
        }
    }

    @Nullable
    protected <T extends EObject> T initializeSafely(@Nullable T targetElement, @Nullable Procedures.Procedure1<? super T> initializer) {
        if (targetElement != null && initializer != null) {
            try {
                initializer.apply(targetElement);
            }
            catch (Exception e) {
                LOG.error((Object)"Error initializing JvmElement", (Throwable)e);
            }
        }
        return targetElement;
    }

    public void setBody(@Nullable JvmExecutable executable, @Nullable Procedures.Procedure1<ITreeAppendable> strategy) {
        this.removeExistingBody((JvmMember)executable);
        this.setCompilationStrategy((JvmMember)executable, strategy);
    }

    @Nullable
    public String getDocumentation(@Nullable EObject source) {
        DocumentationAdapter adapter;
        if (source == null) {
            return null;
        }
        if (source instanceof JvmIdentifiableElement && (adapter = (DocumentationAdapter)EcoreUtil.getAdapter((List)source.eAdapters(), DocumentationAdapter.class)) != null) {
            return adapter.getDocumentation();
        }
        String documentation = this.documentationProvider.getDocumentation(source);
        return documentation;
    }

    public void setDocumentation(@Nullable JvmIdentifiableElement jvmElement, @Nullable String documentation) {
        if (jvmElement == null || documentation == null) {
            return;
        }
        DocumentationAdapter documentationAdapter = new DocumentationAdapter();
        documentationAdapter.setDocumentation(documentation);
        jvmElement.eAdapters().add((Object)documentationAdapter);
    }

    @Nullable
    public JvmGenericType toClass(@Nullable EObject sourceElement, @Nullable QualifiedName name) {
        return this.toClass(sourceElement, name != null ? name.toString() : null, null);
    }

    @Nullable
    public JvmGenericType toClass(@Nullable EObject sourceElement, @Nullable String name) {
        return this.toClass(sourceElement, name, null);
    }

    @Nullable
    public JvmGenericType toClass(@Nullable EObject sourceElement, @Nullable QualifiedName name, @Nullable Procedures.Procedure1<? super JvmGenericType> initializer) {
        return this.toClass(sourceElement, name != null ? name.toString() : null, initializer);
    }

    @Nullable
    public JvmGenericType toClass(@Nullable EObject sourceElement, @Nullable String name, @Nullable Procedures.Procedure1<? super JvmGenericType> initializer) {
        JvmGenericType result = this.createJvmGenericType(sourceElement, name);
        if (result == null) {
            return null;
        }
        this.associate(sourceElement, result);
        return this.initializeSafely((EObject)result, (Procedures.Procedure1)initializer);
    }

    @Nullable
    public JvmGenericType toInterface(@Nullable EObject sourceElement, @Nullable String name, @Nullable Procedures.Procedure1<? super JvmGenericType> initializer) {
        JvmGenericType result = this.createJvmGenericType(sourceElement, name);
        if (result == null) {
            return null;
        }
        result.setInterface(true);
        this.associate(sourceElement, result);
        return this.initializeSafely((EObject)result, (Procedures.Procedure1)initializer);
    }

    @Nullable
    public JvmAnnotationType toAnnotationType(@Nullable EObject sourceElement, @Nullable String name, @Nullable Procedures.Procedure1<? super JvmAnnotationType> initializer) {
        if (sourceElement == null || name == null) {
            return null;
        }
        Pair<String, String> fullName = this.splitQualifiedName(name);
        JvmAnnotationType annotationType = this.typesFactory.createJvmAnnotationType();
        annotationType.setSimpleName((String)fullName.getSecond());
        if (fullName.getFirst() != null) {
            annotationType.setPackageName((String)fullName.getFirst());
        }
        this.associate(sourceElement, annotationType);
        return this.initializeSafely((EObject)annotationType, (Procedures.Procedure1)initializer);
    }

    @Nullable
    public JvmEnumerationType toEnumerationType(@Nullable EObject sourceElement, @Nullable String name, @Nullable Procedures.Procedure1<? super JvmEnumerationType> initializer) {
        if (sourceElement == null || name == null) {
            return null;
        }
        Pair<String, String> fullName = this.splitQualifiedName(name);
        JvmEnumerationType result = this.typesFactory.createJvmEnumerationType();
        result.setSimpleName((String)fullName.getSecond());
        result.setVisibility(JvmVisibility.PUBLIC);
        if (fullName.getFirst() != null) {
            result.setPackageName((String)fullName.getFirst());
        }
        this.associate(sourceElement, result);
        return this.initializeSafely((EObject)result, (Procedures.Procedure1)initializer);
    }

    @Nullable
    public JvmEnumerationLiteral toEnumerationLiteral(@Nullable EObject sourceElement, @Nullable String name) {
        return this.toEnumerationLiteral(sourceElement, name, null);
    }

    @Nullable
    public JvmEnumerationLiteral toEnumerationLiteral(@Nullable EObject sourceElement, @Nullable String name, @Nullable Procedures.Procedure1<? super JvmEnumerationLiteral> initializer) {
        if (sourceElement == null || name == null) {
            return null;
        }
        JvmEnumerationLiteral result = this.typesFactory.createJvmEnumerationLiteral();
        result.setSimpleName(name);
        result.setVisibility(JvmVisibility.PUBLIC);
        this.associate(sourceElement, result);
        return this.initializeSafely((EObject)result, (Procedures.Procedure1)initializer);
    }

    @Nullable
    protected JvmGenericType createJvmGenericType(@Nullable EObject sourceElement, @Nullable String name) {
        if (sourceElement == null || name == null) {
            return null;
        }
        Pair<String, String> fullName = this.splitQualifiedName(name);
        JvmGenericType result = this.typesFactory.createJvmGenericType();
        result.setSimpleName((String)fullName.getSecond());
        if (fullName.getFirst() != null) {
            result.setPackageName((String)fullName.getFirst());
        }
        result.setVisibility(JvmVisibility.PUBLIC);
        return result;
    }

    protected Pair<String, String> splitQualifiedName(String name) {
        String simpleName = name;
        String packageName = null;
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx != -1) {
            simpleName = name.substring(dotIdx + 1);
            packageName = name.substring(0, dotIdx);
        }
        Pair fullName = Tuples.create(packageName, (Object)simpleName);
        return fullName;
    }

    @Nullable
    public JvmField toField(@Nullable EObject sourceElement, @Nullable String name, @Nullable JvmTypeReference typeRef) {
        return this.toField(sourceElement, name, typeRef, null);
    }

    @Nullable
    public JvmField toField(@Nullable EObject sourceElement, @Nullable String name, @Nullable JvmTypeReference typeRef, @Nullable Procedures.Procedure1<? super JvmField> initializer) {
        if (sourceElement == null || name == null) {
            return null;
        }
        JvmField result = this.typesFactory.createJvmField();
        result.setSimpleName(name);
        result.setVisibility(JvmVisibility.PRIVATE);
        result.setType(this.cloneWithProxies(typeRef));
        this.associate(sourceElement, result);
        return this.initializeSafely((EObject)result, (Procedures.Procedure1)initializer);
    }

    @Nullable
    public <T extends JvmIdentifiableElement> T associate(@Nullable EObject sourceElement, @Nullable T target) {
        if (sourceElement != null && target != null) {
            this.associator.associate(sourceElement, (EObject)target);
        }
        return target;
    }

    @Nullable
    public JvmOperation toMethod(@Nullable EObject sourceElement, @Nullable String name, @Nullable JvmTypeReference returnType, @Nullable Procedures.Procedure1<? super JvmOperation> initializer) {
        if (sourceElement == null || name == null) {
            return null;
        }
        JvmOperation result = this.typesFactory.createJvmOperation();
        result.setSimpleName(name);
        result.setVisibility(JvmVisibility.PUBLIC);
        result.setReturnType(this.cloneWithProxies(returnType));
        this.associate(sourceElement, result);
        return this.initializeSafely((EObject)result, (Procedures.Procedure1)initializer);
    }

    @Nullable
    public JvmOperation toGetter(@Nullable EObject sourceElement, @Nullable String name, @Nullable JvmTypeReference typeRef) {
        return this.toGetter(sourceElement, name, name, typeRef);
    }

    @Nullable
    public JvmOperation toGetter(final @Nullable EObject sourceElement, @Nullable String propertyName, final @Nullable String fieldName, @Nullable JvmTypeReference typeRef) {
        if (sourceElement == null || propertyName == null || fieldName == null) {
            return null;
        }
        JvmOperation result = this.typesFactory.createJvmOperation();
        result.setVisibility(JvmVisibility.PUBLIC);
        String prefix = "get";
        if (typeRef != null && !typeRef.eIsProxy() && !typeRef.getType().eIsProxy() && "boolean".equals(typeRef.getType().getIdentifier())) {
            prefix = "is";
        }
        result.setSimpleName(String.valueOf(prefix) + Strings.toFirstUpper((String)propertyName));
        result.setReturnType(this.cloneWithProxies(typeRef));
        this.setBody((JvmExecutable)result, new Procedures.Procedure1<ITreeAppendable>(){

            public void apply(@Nullable ITreeAppendable p) {
                if (p != null) {
                    p = p.trace(sourceElement);
                    p.append("return this.");
                    p.append(fieldName);
                    p.append(";");
                }
            }
        });
        return this.associate(sourceElement, result);
    }

    @Nullable
    public JvmOperation toSetter(@Nullable EObject sourceElement, @Nullable String name, @Nullable JvmTypeReference typeRef) {
        return this.toSetter(sourceElement, name, name, typeRef);
    }

    @Nullable
    public JvmOperation toSetter(final @Nullable EObject sourceElement, final @Nullable String propertyName, final @Nullable String fieldName, @Nullable JvmTypeReference typeRef) {
        if (sourceElement == null || propertyName == null || fieldName == null) {
            return null;
        }
        JvmOperation result = this.typesFactory.createJvmOperation();
        result.setVisibility(JvmVisibility.PUBLIC);
        result.setReturnType(this.references.getTypeForName(Void.TYPE, (Notifier)sourceElement, new JvmTypeReference[0]));
        result.setSimpleName("set" + Strings.toFirstUpper((String)propertyName));
        result.getParameters().add((Object)this.toParameter(sourceElement, propertyName, this.cloneWithProxies(typeRef)));
        this.setBody((JvmExecutable)result, new Procedures.Procedure1<ITreeAppendable>(){

            public void apply(@Nullable ITreeAppendable p) {
                if (p != null) {
                    p = p.trace(sourceElement);
                    p.append("this.");
                    p.append(fieldName);
                    p.append(" = ");
                    p.append(propertyName);
                    p.append(";");
                }
            }
        });
        return this.associate(sourceElement, result);
    }

    @Nullable
    public JvmFormalParameter toParameter(@Nullable EObject sourceElement, @Nullable String name, @Nullable JvmTypeReference typeRef) {
        if (sourceElement == null || name == null) {
            return null;
        }
        JvmFormalParameter result = this.typesFactory.createJvmFormalParameter();
        result.setName(name);
        result.setParameterType(this.cloneWithProxies(typeRef));
        return this.associate(sourceElement, result);
    }

    @Nullable
    public JvmConstructor toConstructor(@Nullable EObject sourceElement, @Nullable Procedures.Procedure1<? super JvmConstructor> initializer) {
        if (sourceElement == null) {
            return null;
        }
        JvmConstructor constructor = this.typesFactory.createJvmConstructor();
        constructor.setVisibility(JvmVisibility.PUBLIC);
        this.associate(sourceElement, constructor);
        return this.initializeSafely((EObject)constructor, (Procedures.Procedure1)initializer);
    }

    @Nullable
    public JvmOperation toToStringMethod(final @Nullable EObject sourceElement, @Nullable JvmDeclaredType declaredType) {
        if (sourceElement == null || declaredType == null) {
            return null;
        }
        JvmOperation result = this.toMethod(sourceElement, "toString", this.newTypeRef(sourceElement, String.class, new JvmTypeReference[0]), null);
        if (result == null) {
            return null;
        }
        result.getAnnotations().add((Object)this.toAnnotation(sourceElement, Override.class));
        this.setBody((JvmExecutable)result, new Procedures.Procedure1<ITreeAppendable>(){

            public void apply(@Nullable ITreeAppendable p) {
                if (p == null) {
                    return;
                }
                JvmTypeReference typeRef = JvmTypesBuilder.this.newTypeRef(sourceElement, ToStringHelper.class, new JvmTypeReference[0]);
                p.append("String result = new ");
                if (typeRef != null) {
                    p.append(typeRef.getType());
                } else {
                    p.append(ToStringHelper.class.getName());
                }
                p.append("().toString(this);");
                p.newLine().append("return result;");
            }
        });
        return result;
    }

    @Nullable
    public JvmOperation toHashCodeMethod(@Nullable EObject sourceElement, boolean extendsSomethingWithProperHashCode, @Nullable JvmDeclaredType declaredType) {
        if (sourceElement == null || declaredType == null) {
            return null;
        }
        return this.toHashCodeMethod(sourceElement, extendsSomethingWithProperHashCode, (JvmField[])Iterables.toArray((Iterable)Iterables.filter((Iterable)declaredType.getMembers(), JvmField.class), JvmField.class));
    }

    @Nullable
    public JvmOperation toHashCodeMethod(@Nullable EObject sourceElement, final boolean extendsSomethingWithProperHashCode, final JvmField ... jvmFields) {
        if (sourceElement == null) {
            return null;
        }
        JvmOperation result = this.toMethod(sourceElement, "hashCode", this.references.getTypeForName(Integer.TYPE, (Notifier)sourceElement, new JvmTypeReference[0]), null);
        if (result == null) {
            return null;
        }
        result.getAnnotations().add((Object)this.toAnnotation(sourceElement, Override.class));
        this.setBody((JvmExecutable)result, new Procedures.Procedure1<ITreeAppendable>(){

            public void apply(@Nullable ITreeAppendable p) {
                if (p == null) {
                    return;
                }
                p.append("final int prime = 31;");
                if (extendsSomethingWithProperHashCode) {
                    p.newLine().append("int result = super.hashCode();");
                } else {
                    p.newLine().append("int result = 1;");
                }
                JvmField[] jvmFieldArray = jvmFields;
                int n = jvmFields.length;
                int n2 = 0;
                while (n2 < n) {
                    JvmField field = jvmFieldArray[n2];
                    String typeName = field.getType().getIdentifier();
                    if (Boolean.TYPE.getName().equals(typeName)) {
                        p.newLine().append("result = prime * result + (" + field.getSimpleName() + " ? 1231 : 1237);");
                    } else if (Integer.TYPE.getName().equals(typeName) || Character.TYPE.getName().equals(typeName) || Byte.TYPE.getName().equals(typeName) || Short.TYPE.getName().equals(typeName)) {
                        p.newLine().append("result = prime * result + " + field.getSimpleName() + ";");
                    } else if (Long.TYPE.getName().equals(typeName)) {
                        p.newLine().append("result = prime * result + (int) (" + field.getSimpleName() + " ^ (" + field.getSimpleName() + " >>> 32));");
                    } else if (Float.TYPE.getName().equals(typeName)) {
                        p.newLine().append("result = prime * result + Float.floatToIntBits(" + field.getSimpleName() + ");");
                    } else if (Double.TYPE.getName().equals(typeName)) {
                        p.newLine().append("result = prime * result + (int) (Double.doubleToLongBits(" + field.getSimpleName() + ") ^ (Double.doubleToLongBits(" + field.getSimpleName() + ") >>> 32));");
                    } else {
                        p.newLine().append("result = prime * result + ((" + field.getSimpleName() + "== null) ? 0 : " + field.getSimpleName() + ".hashCode());");
                    }
                    ++n2;
                }
                p.newLine().append("return result;");
            }
        });
        return result;
    }

    @Nullable
    public JvmOperation toEqualsMethod(@Nullable EObject sourceElement, @Nullable JvmDeclaredType declaredType, boolean isDelegateToSuperEquals) {
        if (sourceElement == null || declaredType == null) {
            return null;
        }
        return this.toEqualsMethod(sourceElement, declaredType, isDelegateToSuperEquals, (JvmField[])Iterables.toArray((Iterable)Iterables.filter((Iterable)declaredType.getMembers(), JvmField.class), JvmField.class));
    }

    @Nullable
    public JvmOperation toEqualsMethod(@Nullable EObject sourceElement, final @Nullable JvmDeclaredType declaredType, final boolean isDelegateToSuperEquals, final JvmField ... jvmFields) {
        if (sourceElement == null || declaredType == null) {
            return null;
        }
        JvmOperation result = this.toMethod(sourceElement, "equals", this.references.getTypeForName(Boolean.TYPE, (Notifier)sourceElement, new JvmTypeReference[0]), null);
        if (result == null) {
            return null;
        }
        result.getAnnotations().add((Object)this.toAnnotation(sourceElement, Override.class));
        result.getParameters().add((Object)this.toParameter(sourceElement, "obj", this.references.getTypeForName(Object.class, (Notifier)sourceElement, new JvmTypeReference[0])));
        this.setBody((JvmExecutable)result, new Procedures.Procedure1<ITreeAppendable>(){

            public void apply(@Nullable ITreeAppendable p) {
                if (p == null) {
                    return;
                }
                p.append("if (this == obj)").increaseIndentation();
                p.newLine().append("return true;").decreaseIndentation();
                p.newLine().append("if (obj == null)").increaseIndentation();
                p.newLine().append("return false;").decreaseIndentation();
                p.newLine().append("if (getClass() != obj.getClass())").increaseIndentation();
                p.newLine().append("return false;").decreaseIndentation();
                if (isDelegateToSuperEquals) {
                    p.newLine().append("if (!super.equals(obj))").increaseIndentation();
                    p.newLine().append("return false;").decreaseIndentation();
                }
                p.newLine().append(String.valueOf(declaredType.getSimpleName()) + " other = (" + declaredType.getSimpleName() + ") obj;");
                JvmField[] jvmFieldArray = jvmFields;
                int n = jvmFields.length;
                int n2 = 0;
                while (n2 < n) {
                    JvmField field = jvmFieldArray[n2];
                    String typeName = field.getType().getIdentifier();
                    if (Boolean.TYPE.getName().equals(typeName) || Integer.TYPE.getName().equals(typeName) || Long.TYPE.getName().equals(typeName) || Character.TYPE.getName().equals(typeName) || Byte.TYPE.getName().equals(typeName) || Short.TYPE.getName().equals(typeName)) {
                        p.newLine().append("if (other." + field.getSimpleName() + " != " + field.getSimpleName() + ")").increaseIndentation();
                        p.newLine().append("return false;").decreaseIndentation();
                    } else if (Double.TYPE.getName().equals(typeName)) {
                        p.newLine().append("if (Double.doubleToLongBits(other." + field.getSimpleName() + ") != Double.doubleToLongBits(" + field.getSimpleName() + "))").increaseIndentation();
                        p.newLine().append("return false;").decreaseIndentation();
                    } else if (Float.TYPE.getName().equals(typeName)) {
                        p.newLine().append("if (Float.floatToIntBits(other." + field.getSimpleName() + ") != Float.floatToIntBits(" + field.getSimpleName() + "))").increaseIndentation();
                        p.newLine().append("return false;").decreaseIndentation();
                    } else {
                        p.newLine().append("if (" + field.getSimpleName() + " == null) {").increaseIndentation();
                        p.newLine().append("if (other." + field.getSimpleName() + " != null)").increaseIndentation();
                        p.newLine().append("return false;").decreaseIndentation();
                        p.decreaseIndentation();
                        p.newLine().append("} else if (!" + field.getSimpleName() + ".equals(other." + field.getSimpleName() + "))").increaseIndentation();
                        p.newLine().append("return false;").decreaseIndentation();
                    }
                    ++n2;
                }
                p.newLine().append("return true;");
            }
        });
        return result;
    }

    @Nullable
    public JvmAnnotationReference toAnnotation(@Nullable EObject sourceElement, @Nullable Class<?> annotationType) {
        return this.toAnnotation(sourceElement, annotationType, null);
    }

    @Nullable
    public JvmAnnotationReference toAnnotation(@Nullable EObject sourceElement, @Nullable String annotationTypeName) {
        return this.toAnnotation(sourceElement, annotationTypeName, null);
    }

    @Nullable
    public JvmAnnotationReference toAnnotation(@Nullable EObject sourceElement, @Nullable Class<?> annotationType, @Nullable Object value) {
        if (sourceElement == null || annotationType == null) {
            return null;
        }
        return this.toAnnotation(sourceElement, annotationType.getCanonicalName(), value);
    }

    @Nullable
    public JvmAnnotationReference toAnnotation(@Nullable EObject sourceElement, @Nullable String annotationTypeName, @Nullable Object value) {
        JvmAnnotationReference result = this.typesFactory.createJvmAnnotationReference();
        JvmType jvmType = this.references.findDeclaredType(annotationTypeName, (Notifier)sourceElement);
        if (!(jvmType instanceof JvmAnnotationType)) {
            throw new IllegalArgumentException("The given class " + annotationTypeName + " is not an annotation type.");
        }
        result.setAnnotation((JvmAnnotationType)jvmType);
        if (value != null && value instanceof String) {
            JvmStringAnnotationValue annotationValue = this.typesFactory.createJvmStringAnnotationValue();
            annotationValue.getValues().add((Object)((String)value));
            result.getValues().add((Object)annotationValue);
        }
        return result;
    }

    @Nullable
    public JvmTypeReference cloneWithProxies(@Nullable JvmTypeReference typeRef) {
        if (typeRef == null) {
            return null;
        }
        if (typeRef instanceof JvmParameterizedTypeReference && !typeRef.eIsProxy() && !typeRef.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)) {
            JvmUnknownTypeReference unknownTypeReference = this.typesFactory.createJvmUnknownTypeReference();
            unknownTypeReference.setException((Exception)new IllegalArgumentException("typeref#type was null"));
            return unknownTypeReference;
        }
        return this.cloneAndAssociate(typeRef);
    }

    @Nullable
    public <T extends JvmIdentifiableElement> T cloneWithProxies(@Nullable T original) {
        if (original == null) {
            return null;
        }
        return this.cloneAndAssociate(original);
    }

    protected <T extends EObject> T cloneAndAssociate(T original) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false){
            private static final long serialVersionUID = 1L;

            @Nullable
            protected EObject createCopy(@Nullable EObject eObject) {
                EObject result = super.createCopy(eObject);
                if (result != null && eObject != null && !eObject.eIsProxy()) {
                    JvmTypesBuilder.this.associator.associatePrimary(eObject, result);
                }
                return result;
            }
        };
        EObject copy = copier.copy(original);
        copier.copyReferences();
        return (T)copy;
    }

    protected <T extends JvmTypeReference> T cloneAndAssociate(T original) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false){
            private static final long serialVersionUID = 1L;

            @Nullable
            protected EObject createCopy(@Nullable EObject eObject) {
                EObject result = super.createCopy(eObject);
                if (result != null && eObject != null && !eObject.eIsProxy()) {
                    JvmTypesBuilder.this.associator.associatePrimary(eObject, result);
                }
                return result;
            }

            public EObject copy(@Nullable EObject eObject) {
                EObject result = super.copy(eObject);
                if (result instanceof JvmWildcardTypeReference) {
                    boolean upperBoundSeen = false;
                    for (JvmTypeConstraint constraint : ((JvmWildcardTypeReference)result).getConstraints()) {
                        if (!(constraint instanceof JvmUpperBound)) continue;
                        upperBoundSeen = true;
                        break;
                    }
                    if (!upperBoundSeen) {
                        JvmTypeReference object = JvmTypesBuilder.this.newObjectReference();
                        JvmUpperBound upperBound = JvmTypesBuilder.this.typesFactory.createJvmUpperBound();
                        upperBound.setTypeReference(object);
                        ((JvmWildcardTypeReference)result).getConstraints().add(0, (Object)upperBound);
                    }
                }
                return result;
            }
        };
        JvmTypeReference copy = (JvmTypeReference)copier.copy(original);
        copier.copyReferences();
        return (T)copy;
    }

    private JvmTypeReference newObjectReference() {
        URI objectURI = new ClassURIHelper().getFullURI(Object.class);
        JvmGenericType objectType = this.typesFactory.createJvmGenericType();
        ((InternalEObject)objectType).eSetProxyURI(objectURI);
        JvmParameterizedTypeReference result = this.typesFactory.createJvmParameterizedTypeReference();
        result.setType((JvmType)objectType);
        return result;
    }

    public void setInitializer(@Nullable JvmField field, @Nullable Procedures.Procedure1<ITreeAppendable> strategy) {
        if (field == null || strategy == null) {
            return;
        }
        this.removeExistingBody((JvmMember)field);
        this.setCompilationStrategy((JvmMember)field, strategy);
    }

    public void setInitializer(@Nullable JvmField field, @Nullable XExpression expr) {
        if (field == null || expr == null) {
            return;
        }
        this.removeExistingBody((JvmMember)field);
        this.associator.associateLogicalContainer(expr, (JvmIdentifiableElement)field);
    }

    protected void setCompilationStrategy(@Nullable JvmMember member, @Nullable Procedures.Procedure1<ITreeAppendable> strategy) {
        if (member == null || strategy == null) {
            return;
        }
        CompilationStrategyAdapter adapter = new CompilationStrategyAdapter();
        adapter.setCompilationStrategy(strategy);
        member.eAdapters().add((Object)adapter);
    }

    @Nullable
    public JvmTypeReference newTypeRef(@Nullable EObject ctx, @Nullable Class<?> clazz, JvmTypeReference ... typeArgs) {
        return this.references.getTypeForName(clazz, (Notifier)ctx, typeArgs);
    }

    @Nullable
    public JvmTypeReference newTypeRef(@Nullable EObject ctx, @Nullable String typeName, JvmTypeReference ... typeArgs) {
        return this.references.getTypeForName(typeName, (Notifier)ctx, typeArgs);
    }

    @Nullable
    public JvmTypeReference newTypeRef(@Nullable JvmDeclaredType type, JvmTypeReference ... typeArgs) {
        return this.references.createTypeRef((JvmType)type, typeArgs);
    }

    @Nullable
    public JvmTypeReference addArrayTypeDimension(@Nullable JvmTypeReference componentType) {
        return this.references.createArrayType(componentType);
    }

    public void translateAnnotationsTo(@Nullable Iterable<? extends XAnnotation> annotations, @Nullable JvmAnnotationTarget target) {
        if (annotations == null || target == null) {
            return;
        }
        for (XAnnotation xAnnotation : annotations) {
            JvmAnnotationReference annotationReference = this.getJvmAnnotationReference(xAnnotation);
            if (annotationReference == null) continue;
            target.getAnnotations().add((Object)annotationReference);
        }
    }

    @Nullable
    public JvmAnnotationReference getJvmAnnotationReference(@Nullable XAnnotation anno) {
        JvmAnnotationValue value;
        if (anno == null) {
            return null;
        }
        JvmAnnotationReference reference = this.typesFactory.createJvmAnnotationReference();
        JvmAnnotationType annotation = (JvmAnnotationType)anno.eGet((EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, false);
        reference.setAnnotation(annotation);
        for (XAnnotationElementValuePair val : anno.getElementValuePairs()) {
            XExpression valueExpression = val.getValue();
            JvmAnnotationValue annotationValue = this.getJvmAnnotationValue(valueExpression);
            if (annotationValue == null) continue;
            JvmOperation op = (JvmOperation)val.eGet((EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION_ELEMENT_VALUE_PAIR__ELEMENT, false);
            annotationValue.setOperation(op);
            reference.getValues().add((Object)annotationValue);
        }
        if (anno.getValue() != null && (value = this.getJvmAnnotationValue(anno.getValue())) != null) {
            Iterable allFeatures = anno.getAnnotationType().findAllFeaturesByName("value");
            for (JvmFeature jvmFeature : allFeatures) {
                if (!(jvmFeature instanceof JvmOperation)) continue;
                JvmOperation operation = (JvmOperation)jvmFeature;
                value.setOperation(operation);
            }
            reference.getValues().add((Object)value);
        }
        return reference;
    }

    @Nullable
    protected JvmAnnotationValue getJvmAnnotationValue(@Nullable XExpression value) {
        if (value instanceof XAnnotationValueArray) {
            EList<XExpression> values = ((XAnnotationValueArray)value).getValues();
            JvmAnnotationValue result = null;
            for (XExpression expr : values) {
                AnnotationValueTranslator translator = this.translator(expr);
                if (translator == null) {
                    return null;
                }
                if (result == null) {
                    result = translator.createValue(expr);
                }
                translator.appendValue(result, expr);
            }
            return result;
        }
        if (value != null) {
            AnnotationValueTranslator translator = this.translator(value);
            if (translator == null) {
                return null;
            }
            JvmAnnotationValue result = translator.createValue(value);
            translator.appendValue(result, value);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected AnnotationValueTranslator translator(@Nullable XExpression obj) {
        Map<EClass, AnnotationValueTranslator> map = this.translators;
        synchronized (map) {
            if (this.translators.isEmpty()) {
                this.translators.put(XAnnotationsPackage.Literals.XANNOTATION, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return JvmTypesBuilder.this.typesFactory.createJvmAnnotationAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmAnnotationAnnotationValue annotationValue = (JvmAnnotationAnnotationValue)value;
                        JvmAnnotationReference annotationReference = JvmTypesBuilder.this.getJvmAnnotationReference((XAnnotation)expr);
                        annotationValue.getAnnotations().add((Object)annotationReference);
                    }
                });
                this.translators.put(XbasePackage.Literals.XSTRING_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return JvmTypesBuilder.this.typesFactory.createJvmStringAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmStringAnnotationValue annotationValue = (JvmStringAnnotationValue)value;
                        String string = ((XStringLiteral)expr).getValue();
                        annotationValue.getValues().add((Object)string);
                    }
                });
                this.translators.put(XbasePackage.Literals.XBOOLEAN_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return JvmTypesBuilder.this.typesFactory.createJvmBooleanAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmBooleanAnnotationValue annotationValue = (JvmBooleanAnnotationValue)value;
                        boolean isTrue = ((XBooleanLiteral)expr).isIsTrue();
                        annotationValue.getValues().add((Object)isTrue);
                    }
                });
                this.translators.put(XbasePackage.Literals.XTYPE_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return JvmTypesBuilder.this.typesFactory.createJvmTypeAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmTypeAnnotationValue annotationValue = (JvmTypeAnnotationValue)value;
                        XTypeLiteral literal = (XTypeLiteral)expr;
                        JvmType proxy = (JvmType)literal.eGet((EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE, false);
                        JvmParameterizedTypeReference reference = JvmTypesBuilder.this.typesFactory.createJvmParameterizedTypeReference();
                        reference.setType(proxy);
                        annotationValue.getValues().add((Object)reference);
                    }
                });
                this.translators.put(XbasePackage.Literals.XNUMBER_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        String primitiveType = JvmTypesBuilder.this.numberLiterals.getJavaType((XNumberLiteral)expr).getName();
                        EClass eClass = (EClass)TypesPackage.eINSTANCE.getEClassifier("Jvm" + Strings.toFirstUpper((String)primitiveType) + "AnnotationValue");
                        return (JvmAnnotationValue)JvmTypesBuilder.this.typesFactory.create(eClass);
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        EStructuralFeature valueFeature = value.eClass().getEStructuralFeature("values");
                        List values = (List)value.eGet(valueFeature);
                        XNumberLiteral literal = (XNumberLiteral)expr;
                        Number number = JvmTypesBuilder.this.numberLiterals.numberValue(literal, JvmTypesBuilder.this.numberLiterals.getJavaType(literal));
                        values.add(number);
                    }
                });
                this.translators.put(XbasePackage.Literals.XFEATURE_CALL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return JvmTypesBuilder.this.typesFactory.createJvmCustomAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmCustomAnnotationValue annotationValue = (JvmCustomAnnotationValue)value;
                        annotationValue.getValues().add((Object)expr);
                    }
                });
            }
        }
        return obj == null ? null : this.translators.get(obj.eClass());
    }

    public static interface AnnotationValueTranslator {
        public JvmAnnotationValue createValue(XExpression var1);

        public void appendValue(JvmAnnotationValue var1, XExpression var2);
    }
}

