/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.views;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.util.DisplayRunHelper;
import org.eclipse.xtext.ui.views.DefaultWorkbenchPartSelection;
import org.eclipse.xtext.ui.views.IWorkbenchPartSelection;
import org.eclipse.xtext.util.ITextRegion;

public abstract class AbstractSourceView
extends ViewPart
implements IPartListener2,
ISelectionListener,
IPropertyChangeListener {
    @Inject
    @Named(value="languageName")
    private String languageName;
    private int computeCount;
    private RGB backgroundColorRGB;
    private Color backgroundColor;
    private SourceViewer sourceViewer;
    private IWorkbenchPartSelection workbenchPartSelection;

    public IWorkbenchPartSelection getWorkbenchPartSelection() {
        return this.workbenchPartSelection;
    }

    protected void setWorkbenchPartSelection(IWorkbenchPartSelection workbenchPartSelection) {
        this.workbenchPartSelection = workbenchPartSelection;
    }

    protected SourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void createPartControl(Composite parent) {
        this.sourceViewer = this.createSourceViewer(parent);
        this.inititalizeColors();
        this.inititalizeFont();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    protected abstract SourceViewer createSourceViewer(Composite var1);

    protected void inititalizeColors() {
        Color bgColor;
        Display display = this.getDisplay();
        if (display == null) {
            return;
        }
        this.getSourceViewer().getTextWidget().setForeground(display.getSystemColor(28));
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        this.backgroundColorRGB = JFaceResources.getColorRegistry().getRGB(Strings.nullToEmpty((String)this.getBackgroundColorKey()));
        if (this.backgroundColorRGB == null) {
            bgColor = display.getSystemColor(29);
            this.backgroundColorRGB = bgColor.getRGB();
        } else {
            this.backgroundColor = bgColor = new Color((Device)display, this.backgroundColorRGB);
        }
        this.getSourceViewer().getTextWidget().setBackground(bgColor);
    }

    protected String getBackgroundColorKey() {
        return null;
    }

    protected void inititalizeFont() {
        this.setViewerFont();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    private void setViewerFont() {
        Font font = JFaceResources.getFont((String)this.getViewerFontName());
        SourceViewer viewer = this.getSourceViewer();
        if (viewer.getDocument() != null) {
            Point selection = viewer.getSelectedRange();
            int topIndex = viewer.getTopIndex();
            StyledText styledText = viewer.getTextWidget();
            Control parent = viewer.getControl();
            parent.setRedraw(false);
            styledText.setFont(font);
            viewer.setSelectedRange(selection.x, selection.y);
            viewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = viewer.getTextWidget();
            styledText.setFont(font);
        }
    }

    protected String getViewerFontName() {
        return "org.eclipse.jface.defaultfont";
    }

    public void selectionChanged(IWorkbenchPart workbenchPart, ISelection selection) {
        this.computeAndSetInput(new DefaultWorkbenchPartSelection(workbenchPart, selection));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getSourceViewer() == null) {
            return;
        }
        if (event.getProperty().equals(this.getBackgroundColorKey())) {
            this.inititalizeColors();
        } else if (event.getProperty().equals(this.getViewerFontName())) {
            this.setViewerFont();
        }
    }

    public void partVisible(IWorkbenchPartReference ref) {
        if (ref.getId().equals(this.getSite().getId())) {
            IWorkbenchPart activePart = ref.getPage().getActivePart();
            if (activePart != null) {
                this.selectionChanged(activePart, ref.getPage().getSelection());
            }
            this.addPostSelectionListener();
        }
    }

    public void partHidden(IWorkbenchPartReference ref) {
        if (ref.getId().equals(this.getSite().getId())) {
            this.removePostSelectionListener();
        }
    }

    public void partInputChanged(IWorkbenchPartReference ref) {
        if (!ref.getId().equals(this.getSite().getId())) {
            IWorkbenchPart workbenchPart = ref.getPart(false);
            ISelectionProvider provider = workbenchPart.getSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            ISelection selection = provider.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            this.computeAndSetInput(new DefaultWorkbenchPartSelection(ref.getPart(false), selection));
        }
    }

    public void partActivated(IWorkbenchPartReference ref) {
    }

    public void partBroughtToTop(IWorkbenchPartReference ref) {
    }

    public void partClosed(IWorkbenchPartReference ref) {
    }

    public void partDeactivated(IWorkbenchPartReference ref) {
    }

    public void partOpened(IWorkbenchPartReference ref) {
    }

    protected void addPostSelectionListener() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void removePostSelectionListener() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void computeAndSetInput(IWorkbenchPartSelection workbenchPartSelection) {
        this.computeAndSetInput(workbenchPartSelection, false);
    }

    public void computeAndSetInput(IWorkbenchPartSelection workbenchPartSelection, boolean forceSelection) {
        if (!this.isValidSelection(workbenchPartSelection)) {
            return;
        }
        this.internalComputeAndSetInput(workbenchPartSelection, forceSelection);
    }

    protected void internalComputeAndSetInput(final IWorkbenchPartSelection workbenchPartSelection, boolean forceSelection) {
        if (!forceSelection && this.isIgnored(workbenchPartSelection)) {
            return;
        }
        this.workbenchPartSelection = workbenchPartSelection;
        final int currentCount = ++this.computeCount;
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        Thread thread = threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                if (currentCount != AbstractSourceView.this.computeCount) {
                    return;
                }
                final String input = AbstractSourceView.this.computeInput(workbenchPartSelection);
                if (input == null) {
                    return;
                }
                Display display = AbstractSourceView.this.getDisplay();
                if (display == null) {
                    return;
                }
                DisplayRunHelper.runAsyncInDisplayThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractSourceView.this.computeCount != currentCount || AbstractSourceView.this.getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        String description = AbstractSourceView.this.computeDescription(workbenchPartSelection);
                        AbstractSourceView.this.setContentDescription(description);
                        AbstractSourceView.this.setInput(input);
                        AbstractSourceView.this.selectAndReveal(workbenchPartSelection);
                    }
                });
            }
        });
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    protected boolean isValidSelection(IWorkbenchPartSelection workbenchPartSelection) {
        return !((Object)((Object)this)).equals(workbenchPartSelection.getWorkbenchPart()) && workbenchPartSelection.getWorkbenchPart() instanceof XtextEditor && workbenchPartSelection.getSelection() instanceof ITextSelection && ((XtextEditor)workbenchPartSelection.getWorkbenchPart()).getLanguageName().equalsIgnoreCase(this.languageName);
    }

    protected boolean isIgnored(IWorkbenchPartSelection workbenchPartSelection) {
        return workbenchPartSelection.equals(this.workbenchPartSelection);
    }

    protected String computeInput(IWorkbenchPartSelection workbenchPartSelection) {
        return null;
    }

    protected String computeDescription(IWorkbenchPartSelection workbenchPartSelection) {
        return "";
    }

    protected void setInput(String input) {
        IDocument document = this.createDocument(input);
        this.getSourceViewer().setDocument(document, (IAnnotationModel)this.createAnnotationModel());
    }

    protected AnnotationModel createAnnotationModel() {
        return new AnnotationModel();
    }

    protected IDocument createDocument(String input) {
        Document document = new Document(input);
        return document;
    }

    protected void selectAndReveal(IWorkbenchPartSelection workbenchPartSelection) {
        ITextRegion textSelection = this.computeSelectedText(workbenchPartSelection);
        if (textSelection != null && !ITextRegion.EMPTY_REGION.equals(textSelection)) {
            this.setSelection(textSelection, true);
        }
    }

    protected void setSelection(ITextRegion textSelection, boolean reveal) {
        StyledText text = this.getSourceViewer().getTextWidget();
        if (text.getText().length() >= textSelection.getEndOffset()) {
            this.getSourceViewer().setSelection((ISelection)new TextSelection(textSelection.getOffset(), textSelection.getLength()), reveal);
        }
    }

    protected ITextRegion computeSelectedText(IWorkbenchPartSelection workbenchPartSelection) {
        return ITextRegion.EMPTY_REGION;
    }

    protected Display getDisplay() {
        Shell shell = this.getSite().getShell();
        if (shell == null || shell.isDisposed()) {
            return null;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    public void setFocus() {
        StyledText styledText = this.getTextWidget();
        if (styledText != null) {
            styledText.setFocus();
        }
    }

    private StyledText getTextWidget() {
        SourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            return viewer.getTextWidget();
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        ++this.computeCount;
        this.removePostSelectionListener();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        this.backgroundColorRGB = null;
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
            this.backgroundColor = null;
        }
        this.sourceViewer = null;
    }

    protected IStorage getEditorResource(IWorkbenchPartSelection workbenchPartSelection) {
        IWorkbenchPart workbenchPart = workbenchPartSelection.getWorkbenchPart();
        return (IStorage)(workbenchPart instanceof XtextEditor ? ((XtextEditor)workbenchPart).getResource() : null);
    }
}

