/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtCompilerFacade;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtPosition;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final int MAX_LOGGED_COMPILATION_EXCEPTIONS = 5;
    private IProgressMonitor myMonitor;
    private IDocument myDocument;
    private final QvtEditor myEditor;
    private int loggedCompilationExceptionsCount = 0;

    public QvtReconcilingStrategy(QvtEditor editor) {
        this.myEditor = editor;
    }

    public void setDocument(IDocument document) {
        this.myDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcileInternal();
    }

    public void reconcile(IRegion partition) {
        this.reconcileInternal();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.myMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcileInternal();
    }

    /*
     * Unable to fully structure code
     */
    private void reconcileInternal() {
        block11: {
            block10: {
                block12: {
                    positions = new ArrayList<Position>();
                    options = new QvtCompilerOptions();
                    options.setShowAnnotations(QvtCompilerFacade.isEditingInQvtSourceContainer(this.myEditor));
                    options.setSourceLineNumbersEnabled(false);
                    reconcilingListener = this.myEditor.getReconcilingListener();
                    compilationResult = null;
                    try {
                        try {
                            reconcilingListener.aboutToBeReconciled();
                            compilationResult = QvtCompilerFacade.getInstance().compile(this.myEditor, this.myDocument, options, this.myMonitor);
                            break block10;
                        }
                        catch (Exception ex) {
                            if (this.loggedCompilationExceptionsCount < 5) {
                                ++this.loggedCompilationExceptionsCount;
                                Activator.log(ex);
                                if (this.loggedCompilationExceptionsCount == 5) {
                                    Activator.log((IStatus)new Status(2, "org.eclipse.m2m.qvt.oml.editor.ui", Messages.QvtReconcilingStrategy_TooManyExceptions));
                                }
                            }
                            compiledModule = compilationResult != null ? compilationResult.getModule() : null;
                            reconcilingListener.reconciled(compiledModule);
                            if (compiledModule == null) break block11;
                            mappingModuleCS = compiledModule.getSyntaxElement().getModuleCS();
                            this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getImports(), positions);
                            this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getImports(), positions);
                            this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getMetamodels(), positions);
                            this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getProperties(), positions);
                            this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getRenamings(), positions);
                            ** for (method : mappingModuleCS.getMethods())
                        }
                    }
                    catch (Throwable var6_18) {
                        compiledModule = compilationResult != null ? compilationResult.getModule() : null;
                        reconcilingListener.reconciled(compiledModule);
                        if (compiledModule == null) break block12;
                        mappingModuleCS = compiledModule.getSyntaxElement().getModuleCS();
                        this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getImports(), positions);
                        this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getImports(), positions);
                        this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getMetamodels(), positions);
                        this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getProperties(), positions);
                        this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getRenamings(), positions);
                        ** for (method : mappingModuleCS.getMethods())
                    }
lbl-1000:
                    // 1 sources

                    {
                        positions.add(this.createPosition(method.getStartOffset(), method.getEndOffset()));
                        continue;
lbl31:
                        // 1 sources

                        break block11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        positions.add(this.createPosition(method.getStartOffset(), method.getEndOffset()));
                        continue;
                    }
                }
                throw var6_18;
            }
            compiledModule = compilationResult != null ? compilationResult.getModule() : null;
            reconcilingListener.reconciled(compiledModule);
            if (compiledModule != null) {
                mappingModuleCS = compiledModule.getSyntaxElement().getModuleCS();
                this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getImports(), positions);
                this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getImports(), positions);
                this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getMetamodels(), positions);
                this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getProperties(), positions);
                this.addListPosition((List<? extends CSTNode>)mappingModuleCS.getRenamings(), positions);
                for (MappingMethodCS method : mappingModuleCS.getMethods()) {
                    positions.add(this.createPosition(method.getStartOffset(), method.getEndOffset()));
                }
            }
        }
        this.myEditor.refresh();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                QvtReconcilingStrategy.this.myEditor.updateFoldingStructure(positions);
            }
        });
    }

    private void addListPosition(List<? extends CSTNode> list, List<Position> positionList) {
        if (!list.isEmpty()) {
            int start = this.getStart(list);
            int end = this.getEnd(list);
            if (start >= 0 && end >= start) {
                positionList.add(this.createPosition(start, end));
            }
        }
    }

    private int getStart(List<? extends CSTNode> list) {
        int start = Integer.MAX_VALUE;
        for (CSTNode cSTNode : list) {
            if (cSTNode == null) continue;
            start = Math.min(start, cSTNode.getStartOffset());
        }
        return start;
    }

    private int getEnd(List<? extends CSTNode> list) {
        int end = -1;
        for (CSTNode cSTNode : list) {
            if (cSTNode == null) continue;
            end = Math.max(end, cSTNode.getEndOffset());
        }
        return end;
    }

    private QvtPosition createPosition(int start, int end) {
        Region region = new Region(start, end - start);
        IRegion normalized = this.alignRegion((IRegion)region);
        if (normalized != null) {
            region = normalized;
        }
        return new QvtPosition(region.getOffset(), region.getLength());
    }

    protected final IRegion alignRegion(IRegion region) {
        int end;
        int start;
        block4: {
            if (region == null) {
                return null;
            }
            try {
                start = this.myDocument.getLineOfOffset(region.getOffset());
                end = this.myDocument.getLineOfOffset(region.getOffset() + region.getLength());
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int offset = this.myDocument.getLineOffset(start);
        int endOffset = this.myDocument.getNumberOfLines() > end + 1 ? this.myDocument.getLineOffset(end + 1) : this.myDocument.getLineOffset(end) + this.myDocument.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }
}

