/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtcore.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.qvt.declarative.ecore.QVTCore.BottomPattern;
import org.eclipse.qvt.declarative.ecore.QVTCore.CorePattern;
import org.eclipse.qvt.declarative.ecore.QVTCore.GuardPattern;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.PatternCS;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcAreaEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QVTcPatternEnvironment<AST extends CorePattern>
extends QVTcEnvironment<IQVTcNodeEnvironment, QVTcAreaEnvironment<?>, AST, PatternCS>
implements IQVTcEnvironment {
    protected final Map<String, Variable> variableDefinitions = new HashMap<String, Variable>();

    public QVTcPatternEnvironment(QVTcAreaEnvironment<?> domainEnvironment, AST astNode, PatternCS patternCS) {
        super(domainEnvironment, astNode, patternCS);
    }

    public void computeBindsTo() {
        EList bindsTo = ((CorePattern)this.ast).getBindsTo();
        for (QVTcPatternEnvironment<?> env : this.getPatternEnvironmentClosure()) {
            if (env == this || env == null) continue;
            for (Variable var : ((CorePattern)env.getASTNode()).getBindsTo()) {
                if (bindsTo.contains(var)) continue;
                bindsTo.add(var);
            }
        }
    }

    public Variable createUnrealizedVariableDefinition(String name, EClassifier type, CSTNode cstNode) {
        Variable variable = this.variableDefinitions.get(name);
        if (variable != null) {
            if (variable.getType() != type) {
                String message = "Conflicting type '" + this.formatType(type) + "' for variable of type '" + this.formatType(variable.getType()) + "'";
                this.analyzerError(message, "explicit varDeclarationCS", cstNode);
            }
        } else {
            variable = EcoreFactory.eINSTANCE.createVariable();
            this.initASTMapping(variable, cstNode);
            UMLReflection uml = this.getUMLReflection();
            uml.setName((TypedElement)variable, name);
            uml.setType((TypedElement)variable, (Object)type);
            this.variableDefinitions.put(name, variable);
            ((CorePattern)this.ast).getVariable().add((Object)variable);
            this.addElement(name, (org.eclipse.ocl.expressions.Variable)variable, true);
            ((CorePattern)this.ast).getBindsTo().add((Object)variable);
        }
        return variable;
    }

    public String formatName(Object object) {
        if (object instanceof BottomPattern) {
            return "bottom";
        }
        if (object instanceof GuardPattern) {
            return "guard";
        }
        return super.formatName(object);
    }

    public abstract Set<? extends QVTcPatternEnvironment<?>> getPatternEnvironmentClosure();

    public Variable getVariable(String name) {
        return this.variableDefinitions.get(name);
    }

    public org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> lookup(String name) {
        try {
            return this.tryLookupVariable(name);
        }
        catch (LookupException e) {
            this.analyzerError(this.formatLookupException(e), "lookup", this.getCSTNode());
            List ambiguousMatches = e.getAmbiguousMatches();
            if (ambiguousMatches.size() <= 0) {
                return null;
            }
            List sortedMatches = this.getFormatter().sort((Collection)ambiguousMatches);
            org.eclipse.ocl.expressions.Variable firstMatch = (org.eclipse.ocl.expressions.Variable)sortedMatches.get(0);
            return firstMatch;
        }
    }

    public Variable tryLookupVariable(String name) throws LookupException {
        Set<QVTcPatternEnvironment<?>> patterns = this.getPatternEnvironmentClosure();
        Variable variable = null;
        ArrayList<Variable> variables = null;
        for (QVTcPatternEnvironment<?> pattern : patterns) {
            Variable v = pattern.getVariable(name);
            if (v == null) continue;
            if (variables != null) {
                variables.add(v);
                continue;
            }
            if (variable != null) {
                variables = new ArrayList<Variable>();
                variables.add(variable);
                variables.add(v);
                variable = null;
                continue;
            }
            variable = v;
        }
        if (variables != null) {
            throw new LookupException("Ambiguous variable", variables);
        }
        return variable;
    }
}

