/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetResourceURICommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = "SetURILabel";
    protected static final String DESCRIPTION = "SetURIDescription";
    protected Resource owner;
    protected URI value;
    protected URI oldValue;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;

    public SetResourceURICommand(EditingDomain domain, Resource owner, URI value) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.value = value;
    }

    public void doExecute() {
        this.owner.setURI(this.value);
    }

    public boolean doCanUndo() {
        return true;
    }

    public Collection<?> doGetAffectedObjects() {
        return Collections.singleton(this.owner);
    }

    public Collection<?> doGetResult() {
        return Collections.singleton(this.owner);
    }

    public void doRedo() {
        this.owner.setURI(this.value);
    }

    public void doUndo() {
        this.owner.setURI(this.oldValue);
    }

    public URI getOldValue() {
        return this.oldValue;
    }

    public Resource getOwner() {
        return this.owner;
    }

    public URI getValue() {
        return this.value;
    }

    protected boolean prepare() {
        this.oldValue = this.owner.getURI();
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: URI)");
        result.append(" (value: " + this.value + ")");
        result.append(" (oldValue: " + this.oldValue + ")");
        return result.toString();
    }
}

