/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.api.extensions.impl;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.eef.ide.api.extensions.AbstractRegistryEventListener;
import org.eclipse.eef.ide.api.extensions.IItemDescriptor;
import org.eclipse.eef.ide.api.extensions.IItemRegistry;
import org.eclipse.eef.ide.api.extensions.impl.ItemDescriptor;
import org.eclipse.eef.ide.internal.EEFIdePlugin;
import org.eclipse.eef.ide.internal.Messages;

public class DescriptorRegistryEventListener<T>
extends AbstractRegistryEventListener {
    public static final String ID_DESCRIPTOR_ATTR = "id";
    public static final String LABEL_DESCRIPTOR_ATTR = "label";
    public static final String DESCRIPTION_DESCRIPTOR_ATTR = "description";
    public static final String IMPL_CLASS_DESCRIPTOR_ATTR = "class";
    public static final String TAG_DESCRIPTOR = "descriptor";
    private IItemRegistry<T> itemRegistry;

    public DescriptorRegistryEventListener(String namespace, String extensionPointID, IItemRegistry<T> itemRegistry) {
        super(namespace, extensionPointID);
        this.itemRegistry = itemRegistry;
    }

    @Override
    protected boolean validateConfigurationElement(IConfigurationElement configurationElement) {
        boolean isValid = false;
        if (TAG_DESCRIPTOR.equals(configurationElement.getName())) {
            if (!this.isValidAttribute(configurationElement, ID_DESCRIPTOR_ATTR)) {
                String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), ID_DESCRIPTOR_ATTR);
                EEFIdePlugin.getPlugin().error(message);
            } else if (!this.isValidAttribute(configurationElement, LABEL_DESCRIPTOR_ATTR)) {
                String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), LABEL_DESCRIPTOR_ATTR);
                EEFIdePlugin.getPlugin().error(message);
            } else if (!this.isValidAttribute(configurationElement, DESCRIPTION_DESCRIPTOR_ATTR)) {
                String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), DESCRIPTION_DESCRIPTOR_ATTR);
                EEFIdePlugin.getPlugin().error(message);
            } else if (!this.isValidAttribute(configurationElement, IMPL_CLASS_DESCRIPTOR_ATTR)) {
                String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), IMPL_CLASS_DESCRIPTOR_ATTR);
                EEFIdePlugin.getPlugin().error(message);
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    private boolean isValidAttribute(IConfigurationElement configurationElement, String attributeName) {
        return configurationElement.getAttribute(attributeName) != null && !"".equals(configurationElement.getAttribute(attributeName));
    }

    @Override
    protected boolean processAddition(IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute(ID_DESCRIPTOR_ATTR);
        String label = configurationElement.getAttribute(LABEL_DESCRIPTOR_ATTR);
        String description = configurationElement.getAttribute(DESCRIPTION_DESCRIPTOR_ATTR);
        try {
            Object instance = configurationElement.createExecutableExtension(IMPL_CLASS_DESCRIPTOR_ATTR);
            ItemDescriptor<Object> descriptor = new ItemDescriptor<Object>(id, label, description, instance);
            IItemDescriptor<Object> previous = this.itemRegistry.add(descriptor);
            if (previous != null) {
                String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_extensionAlreadyContributed, configurationElement.getAttribute(ID_DESCRIPTOR_ATTR));
                EEFIdePlugin.getPlugin().warning(message);
            }
        }
        catch (CoreException e) {
            String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_cannotInstantiateExtension, configurationElement.getAttribute(IMPL_CLASS_DESCRIPTOR_ATTR));
            EEFIdePlugin.getPlugin().error(message, (Exception)((Object)e));
            return false;
        }
        return true;
    }

    @Override
    protected boolean processRemoval(IConfigurationElement configurationElement) {
        return this.itemRegistry.remove(configurationElement.getAttribute(ID_DESCRIPTOR_ATTR)) != null;
    }
}

