/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.internal.page.propertylist;

import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFTabbedPropertyList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class EEFTopNavigationElement
extends Canvas {
    private EEFTabbedPropertyList tabPropertyList;

    public EEFTopNavigationElement(final EEFTabbedPropertyList tabbedPropertyList) {
        super((Composite)tabbedPropertyList, 524288);
        this.tabPropertyList = tabbedPropertyList;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                EEFTopNavigationElement.this.paint(event);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tabbedPropertyList.isUpScrollRequired()) {
                    tabbedPropertyList.setBottomVisibleIndex(tabbedPropertyList.getBottomVisibleIndex() - 1);
                    if (tabbedPropertyList.getTopVisibleIndex() != 0) {
                        tabbedPropertyList.setTopVisibleIndex(tabbedPropertyList.getTopVisibleIndex() - 1);
                    }
                    tabbedPropertyList.layoutTabs();
                    tabbedPropertyList.getTopNavigationElement().redraw();
                    tabbedPropertyList.getBottomNavigationElement().redraw();
                }
            }
        });
    }

    protected void paint(PaintEvent event) {
        event.gc.setBackground(this.tabPropertyList.getColorHolder().getWidgetBackground());
        event.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetForeground());
        Rectangle bounds = this.getBounds();
        if (this.tabPropertyList.getNumberOfElements() != 0) {
            event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            event.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetNormalShadow());
            event.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
        } else {
            event.gc.setBackground(this.tabPropertyList.getColorHolder().getListBackground());
            event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            int textIndent = 7;
            FontMetrics fm = event.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            event.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetForeground());
            String propertiesNotAvailable = "No properties available";
            event.gc.drawText(propertiesNotAvailable, textIndent, textMiddle);
        }
        if (this.tabPropertyList.isUpScrollRequired()) {
            event.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetDarkShadow());
            int middle = bounds.width / 2;
            event.gc.drawLine(middle + 1, 3, middle + 5, 7);
            event.gc.drawLine(middle, 3, middle - 4, 7);
            event.gc.drawLine(middle - 3, 7, middle + 4, 7);
            event.gc.setForeground(this.tabPropertyList.getColorHolder().getListBackground());
            event.gc.drawLine(middle, 4, middle + 1, 4);
            event.gc.drawLine(middle - 1, 5, middle + 2, 5);
            event.gc.drawLine(middle - 2, 6, middle + 3, 6);
            event.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetNormalShadow());
            event.gc.drawLine(0, 0, bounds.width - 2, 0);
            event.gc.setForeground(this.tabPropertyList.getColorHolder().getNavigationElementShadowStroke());
            event.gc.drawLine(0, 1, bounds.width - 2, 1);
            event.gc.drawLine(0, bounds.height - 1, bounds.width - 2, bounds.height - 1);
        }
    }
}

