/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.internal.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.eef.properties.ui.api.AbstractEEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFSectionDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptorProvider;
import org.eclipse.eef.properties.ui.internal.EEFTabbedPropertyViewPlugin;
import org.eclipse.eef.properties.ui.internal.Messages;
import org.eclipse.eef.properties.ui.internal.extension.IItemDescriptor;
import org.eclipse.eef.properties.ui.internal.extension.IItemRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class EEFTabbedPropertyRegistry {
    private static EEFTabbedPropertyRegistry instance = new EEFTabbedPropertyRegistry();

    public static EEFTabbedPropertyRegistry getDefault() {
        return instance;
    }

    private List<IEEFTabDescriptor> getAllTabDescriptors(IWorkbenchPart part, ISelection input) {
        LinkedHashMap<String, IEEFTabDescriptor> eefTabDescriptors = new LinkedHashMap<String, IEEFTabDescriptor>();
        IItemRegistry<IEEFTabDescriptorProvider> eefTabDescriptorProviderRegistry = EEFTabbedPropertyViewPlugin.getPlugin().getEEFTabDescriptorProviderRegistry();
        for (IItemDescriptor<IEEFTabDescriptorProvider> itemDescriptor : eefTabDescriptorProviderRegistry.getItemDescriptors()) {
            IEEFTabDescriptorProvider eefTabDescriptorProvider = itemDescriptor.getItem();
            for (IEEFTabDescriptor eefTabDescriptor : eefTabDescriptorProvider.get(part, input)) {
                String eefTabDescriptorId = eefTabDescriptor.getId();
                if (eefTabDescriptors.containsKey(eefTabDescriptorId)) continue;
                eefTabDescriptors.put(eefTabDescriptorId, eefTabDescriptor);
            }
        }
        return new ArrayList<IEEFTabDescriptor>(eefTabDescriptors.values());
    }

    public List<IEEFTabDescriptor> getTabDescriptors(IWorkbenchPart part, ISelection input) {
        if (input == null || input.isEmpty()) {
            return new ArrayList<IEEFTabDescriptor>();
        }
        List<IEEFTabDescriptor> descriptors = this.getAllTabDescriptors(part, input);
        List<IEEFTabDescriptor> result = this.filterTabDescriptors(descriptors, part, input);
        return result;
    }

    private List<IEEFTabDescriptor> filterTabDescriptors(List<IEEFTabDescriptor> eefTabDescriptors, IWorkbenchPart part, ISelection input) {
        ArrayList<IEEFTabDescriptor> filteredEefTabDescriptors = new ArrayList<IEEFTabDescriptor>();
        for (IEEFTabDescriptor eefTabDescriptor : eefTabDescriptors) {
            IEEFTabDescriptor filteredEefTabDescriptor = this.adaptDescriptorFor(eefTabDescriptor, part, input);
            if (filteredEefTabDescriptor.getSectionDescriptors().isEmpty()) continue;
            filteredEefTabDescriptors.add(filteredEefTabDescriptor);
        }
        return filteredEefTabDescriptors;
    }

    private IEEFTabDescriptor adaptDescriptorFor(IEEFTabDescriptor target, IWorkbenchPart part, ISelection selection) {
        ArrayList<IEEFSectionDescriptor> filteredEefSectionDescriptors = new ArrayList<IEEFSectionDescriptor>();
        List<IEEFSectionDescriptor> eefSectionDescriptors = target.getSectionDescriptors();
        for (IEEFSectionDescriptor eefSectionDescriptor : eefSectionDescriptors) {
            if (!eefSectionDescriptor.appliesTo(part, selection)) continue;
            if (eefSectionDescriptor.getId() != null) {
                filteredEefSectionDescriptors.add(eefSectionDescriptor);
                continue;
            }
            EEFTabbedPropertyViewPlugin.getPlugin().error(Messages.EEFTabbedPropertyRegistry_MissingSectionDescriptorId);
        }
        AbstractEEFTabDescriptor filteredEefTabDescriptor = (AbstractEEFTabDescriptor)((AbstractEEFTabDescriptor)target).clone();
        filteredEefTabDescriptor.setSectionDescriptors(filteredEefSectionDescriptors);
        return filteredEefTabDescriptor;
    }
}

