/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.platform;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.platform.xdk110.connectivity.AdcGenerator;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Xdk110PlatformGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    @Extension
    private GeneratorUtils _generatorUtils;
    @Inject
    private AdcGenerator adcGenerator;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                AdcGenerator.SignalInfo _signalInfo = new AdcGenerator.SignalInfo("XDK110_powerStatus_ADC", "ADC_ACQ_TIME_64", "ADC_ENABLE_CH7", "ADC_REF_2V5", "ADC_RESOLUTION_12BIT");
                CodeFragment _generateSetup = Xdk110PlatformGenerator.this.adcGenerator.generateSetup(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AdcGenerator.SignalInfo[]{_signalInfo})));
                _builder.append((Object)_generateSetup);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateAdditionalHeaderContent() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T XDK110_powerStatus_read(PowerStatus* result);");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("xdk110Types.h", false);
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T XDK110_powerStatus_read(PowerStatus* result) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"uint16_t batteryVoltage = 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"uint16_t* batteryVoltagePtr = &batteryVoltage;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"Retcode_T exception = NO_EXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateSignalInstanceGetter = Xdk110PlatformGenerator.this.adcGenerator.generateSignalInstanceGetter("XDK110_powerStatus_ADC", 2500, 12, "batteryVoltagePtr");
                _builder.append((Object)_generateSignalInstanceGetter, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                CharSequence _generateExceptionHandler = Xdk110PlatformGenerator.this._generatorUtils.generateExceptionHandler(null, "exception");
                _builder.append((Object)_generateExceptionHandler, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"// 0% is 3V, internal voltage divider -> 1.5V");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"batteryVoltage -= 1500;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"// experimentally determined threshold");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if(batteryVoltage > 600) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"result->tag = PowerStatus_Corded_e;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"result->tag = PowerStatus_Battery_e;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"result->data.Battery = 100 * batteryVoltage / 587.0f;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1).addHeader("xdk110Types.h", false);
    }

    public String powerStatusReadMethod() {
        return "XDK110_powerStatus_read";
    }

    public CodeFragment generateAccessPreparationFor(final ModalityAccessPreparation accessPreparation) {
        final String varName = StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)accessPreparation));
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"PowerStatus ");
                _builder.append((Object)varName);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = ");
                String _powerStatusReadMethod = Xdk110PlatformGenerator.this.powerStatusReadMethod();
                _builder.append((Object)_powerStatusReadMethod);
                _builder.append((Object)"(&");
                _builder.append((Object)varName);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = Xdk110PlatformGenerator.this._generatorUtils.generateExceptionHandler((EObject)accessPreparation, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("xdk110Types.h", false);
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modality) {
        final String varName = StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)modality.getPreparation()));
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)varName);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("xdk110Types.h", false);
    }
}

