/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.platform;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.mita.program.generator.IPlatformTimeGenerator;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TimeGenerator
implements IPlatformTimeGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected IPlatformEventLoopGenerator eventLoopGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateTimeGoLive(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateTimeSetup(final CompilationContext context) {
        final Iterable allTimeEvents = this._generatorUtils.getAllTimeEvents(context);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.newLine();
                for (EventHandlerDeclaration handler : allTimeEvents) {
                    String name = TimeGenerator.this.getTimerName((EObject)handler);
                    _builder.newLineIfNotEmpty();
                    EventSource _event = handler.getEvent();
                    int period = ModelUtils.getIntervalInMilliseconds((TimeIntervalEvent)((TimeIntervalEvent)_event));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)name);
                    _builder.append((Object)" = xTimerCreate(\"");
                    _builder.append((Object)name);
                    _builder.append((Object)"\", UINT32_C(");
                    _builder.append((Object)period);
                    _builder.append((Object)"), pdTRUE, NULL, ");
                    String _internalHandlerName = TimeGenerator.this.getInternalHandlerName((EObject)handler);
                    _builder.append((Object)_internalHandlerName);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
                _builder.append((Object)"if(");
                Functions.Function1<EventHandlerDeclaration, String> _function = new Functions.Function1<EventHandlerDeclaration, String>(){

                    public String apply(EventHandlerDeclaration x) {
                        String _timerName = TimeGenerator.this.getTimerName((EObject)x.getEvent());
                        return String.valueOf(_timerName) + " == NULL";
                    }
                };
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)allTimeEvents, (Functions.Function1)_function), (CharSequence)" || ");
                _builder.append((Object)_join);
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        CodeFragment body = this.codeFragmentProvider.create(_client);
        CodeFragment _create = this.codeFragmentProvider.create((CompositeGeneratorNode)body);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                for (EventHandlerDeclaration handler : allTimeEvents) {
                    _builder.append((Object)"static TimerHandle_t ");
                    String _timerName = TimeGenerator.this.getTimerName((EObject)handler);
                    _builder.append((Object)_timerName);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                for (EventHandlerDeclaration handler_1 : allTimeEvents) {
                    _builder.append((Object)"static void ");
                    String _internalHandlerName = TimeGenerator.this.getInternalHandlerName((EObject)handler_1);
                    _builder.append((Object)_internalHandlerName);
                    _builder.append((Object)"(TimerHandle_t xTimer)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"BCDS_UNUSED(xTimer);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    CodeFragment _generateEventLoopInject = TimeGenerator.this.eventLoopGenerator.generateEventLoopInject(context, TimeGenerator.this._generatorUtils.getHandlerName((EObject)handler_1));
                    _builder.append((Object)_generateEventLoopInject, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                }
            }
        };
        return _create.setPreamble(_client_1).addHeader("FreeRTOS.h", true, 1000).addHeader("BCDS_Basics.h", true, 750).addHeader("timers.h", true).addHeader("MitaEvents.h", false).addHeader("MitaExceptions.h", false).addHeader("MitaTime.h", false, 750).addHeader("BCDS_CmdProcessor.h", true);
    }

    public CodeFragment generateTimeEnable(CompilationContext context, final EventHandlerDeclaration handler) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"xTimerStart(");
                String _timerName = TimeGenerator.this.getTimerName((EObject)handler);
                _builder.append((Object)_timerName);
                _builder.append((Object)", 0);");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("timers.h", true);
    }

    protected String getTimerName(EObject event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("timer");
        String _handlerName = this._generatorUtils.getHandlerName(event);
        _builder.append(_handlerName);
        return _builder.toString();
    }

    protected String getInternalHandlerName(EObject event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Internal");
        String _firstUpper = StringExtensions.toFirstUpper((String)this._generatorUtils.getHandlerName(event));
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    public CodeFragment generateAdditionalHeaderContent(CompilationContext context) {
        return CodeFragment.EMPTY;
    }
}

