/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.platform.xdk110.connectivity.LedGenerator;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LedValidator
implements IResourceValidator {
    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            this.validateUniqueColorUse(program, (SystemResourceSetup)context, acceptor);
        }
    }

    private void validateUniqueColorUse(Program program, SystemResourceSetup setup, ValidationMessageAcceptor acceptor) {
        Map<SignalInstance, String> colorAssignment = LedGenerator.getSignalToColorAssignment(setup);
        List colors = IterableExtensions.toList(colorAssignment.values());
        Set<Map.Entry<SignalInstance, String>> _entrySet = colorAssignment.entrySet();
        for (final Map.Entry<SignalInstance, String> vciAndColor : _entrySet) {
            boolean _greaterThan;
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String x) {
                    String _value = (String)vciAndColor.getValue();
                    return Objects.equal((Object)_value, (Object)x);
                }
            };
            int _length = ((Object[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)colors, (Functions.Function1)_function), Object.class)).length;
            boolean bl = _greaterThan = _length > 1;
            if (!_greaterThan) continue;
            String _lowerCase = vciAndColor.getValue().toLowerCase();
            String _plus = "The " + _lowerCase;
            String _plus_1 = String.valueOf(_plus) + " LED can only be used once in the setup.";
            acceptor.acceptError(_plus_1, (EObject)vciAndColor.getKey(), (EStructuralFeature)ProgramPackage.eINSTANCE.getVariableDeclaration_Initialization(), 0, "LED_USE_NOT_UNIQUE", new String[0]);
        }
    }
}

