/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.TypeGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class BleGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    protected ITypeSystemInferrer typeInferrer;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected TypeGenerator typeGenerator;
    public static final String MAC_ADDRESS_REGEX = "^([Ff][Cc]:[Dd]6:[Bb][Dd]:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2})|([Ff][Cc]-[Dd]6-[Bb][Dd]-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2})$";
    public static final Pattern MAC_ADDRESS_PATTERN = Pattern.compile("^([Ff][Cc]:[Dd]6:[Bb][Dd]:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2})|([Ff][Cc]-[Dd]6-[Bb][Dd]-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2})$");

    public CodeFragment generateSetup() {
        CodeFragment _xblockexpression = null;
        Object _elvis = null;
        _elvis = this.setup != null ? this.setup : this.component;
        final String baseName = this._generatorUtils.getBaseName(_elvis);
        String _elvis_1 = null;
        String _string = this.configuration.getString("deviceName");
        _elvis_1 = _string != null ? _string : baseName;
        final String deviceName = _elvis_1;
        Integer _elvis_2 = null;
        Integer _integer = this.configuration.getInteger("serviceUID");
        if (_integer != null) {
            _elvis_2 = _integer;
        } else {
            int _hashCode = baseName.hashCode();
            _elvis_2 = _hashCode;
        }
        final Integer serviceUid = _elvis_2;
        final String macAddressStr = this.configuration.getString("macAddress");
        boolean macAdressConfigured = false;
        String _xifexpression = null;
        if (macAddressStr != null) {
            String _xblockexpression_1 = null;
            Matcher macAddressMatcher = MAC_ADDRESS_PATTERN.matcher(macAddressStr);
            macAdressConfigured = macAddressMatcher.matches();
            String _xifexpression_1 = null;
            if (macAdressConfigured) {
                _xifexpression_1 = macAddressStr.replaceAll("[:-]", "").toUpperCase();
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        final String macAddress = _xifexpression;
        final boolean macAdressConfiguredFinal = macAdressConfigured;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"BleEventSignal = xSemaphoreCreateBinary();");
                _builder.newLine();
                _builder.append((Object)"if (NULL == BleEventSignal)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BleSendCompleteSignal = xSemaphoreCreateBinary();");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (NULL == BleSendCompleteSignal)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"vSemaphoreDelete(BleEventSignal);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}  ");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BleSendGuardMutex = xSemaphoreCreateMutex();");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (NULL == BleSendGuardMutex)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"vSemaphoreDelete(BleEventSignal);");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"vSemaphoreDelete(BleSendCompleteSignal);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"retcode =  BlePeripheral_Initialize(");
                _builder.append((Object)baseName, "    ");
                _builder.append((Object)"_OnEvent, ");
                _builder.append((Object)baseName, "    ");
                _builder.append((Object)"_ServiceRegistry);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"retcode = BlePeripheral_SetDeviceName((uint8_t*) _BLE_DEVICE_NAME);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                if (macAdressConfiguredFinal) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"// macAddress = ");
                    _builder.append((Object)macAddressStr, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"uint64_t macAddress = 0x");
                    _builder.append((Object)macAddress, "\t");
                    _builder.append((Object)"ll;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"retcode = BlePeripheral_SetMacAddress(macAddress);");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return retcode;");
                _builder.newLine();
                _builder.newLine();
            }
        };
        CodeFragment _addHeader = this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_Retcode.h", true, 1000).addHeader("BCDS_BlePeripheral.h", true, 750).addHeader("attserver.h", true).addHeader("FreeRTOS.h", true, 750).addHeader("task.h", true).addHeader("semphr.h", true).addHeader("stdio.h", true).addHeader("XdkCommonInfo.h", true).addHeader("string.h", true).addHeader("stdlib.h", true);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#define _BLE_DEVICE_NAME \"");
                _builder.append((Object)deviceName);
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"#define BLE_EVENT_SYNC_TIMEOUT                  UINT32_C(1000)");
                _builder.newLine();
                _builder.append((Object)"static bool BleIsConnected = false;");
                _builder.newLine();
                _builder.append((Object)"/**< Handle for BLE peripheral event signal synchronization */");
                _builder.newLine();
                _builder.append((Object)"static SemaphoreHandle_t BleEventSignal = (SemaphoreHandle_t) NULL;");
                _builder.newLine();
                _builder.append((Object)"/**< Handle for BLE data send complete signal synchronization */");
                _builder.newLine();
                _builder.append((Object)"static SemaphoreHandle_t BleSendCompleteSignal = (SemaphoreHandle_t) NULL;");
                _builder.newLine();
                _builder.append((Object)"/**< Handle for BLE data send Mutex guard */");
                _builder.newLine();
                _builder.append((Object)"static SemaphoreHandle_t BleSendGuardMutex = (SemaphoreHandle_t) NULL;");
                _builder.newLine();
                _builder.append((Object)"/**< BLE peripheral event */");
                _builder.newLine();
                _builder.append((Object)"static BlePeripheral_Event_T BleEvent = BLE_PERIPHERAL_EVENT_MAX;");
                _builder.newLine();
                _builder.append((Object)"/**< BLE send status */");
                _builder.newLine();
                _builder.append((Object)"static Retcode_T BleSendStatus;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* ");
                _builder.append((Object)baseName);
                _builder.append((Object)" service */");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"static uint8_t ");
                _builder.append((Object)baseName);
                _builder.append((Object)"ServiceUid[ATTPDU_SIZEOF_128_BIT_UUID] = { 0x66, 0x9A, 0x0C, 0x20, 0x00, 0x08, 0xF8, 0x82, 0xE4, 0x11, 0x66, 0x71, ");
                byte[] _array = ByteBuffer.allocate(4).putInt(serviceUid).array();
                boolean _hasElements = false;
                byte[] byArray = _array;
                int n = _array.length;
                int n2 = 0;
                while (n2 < n) {
                    byte i = byArray[n2];
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append((Object)"0x");
                    String _upperCase = Integer.toHexString(i & 0xFF).toUpperCase();
                    _builder.append((Object)_upperCase);
                    ++n2;
                }
                _builder.append((Object)" };");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"static AttServiceAttribute ");
                _builder.append((Object)baseName);
                _builder.append((Object)"Service;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"enum ");
                _builder.append((Object)baseName);
                _builder.append((Object)"_E {");
                _builder.newLineIfNotEmpty();
                EList _signalInstances = null;
                if (BleGenerator.this.setup != null) {
                    _signalInstances = BleGenerator.this.setup.getSignalInstances();
                }
                for (SignalInstance signalInstance : _signalInstances) {
                    _builder.append((Object)baseName);
                    _builder.append((Object)"_");
                    String _name = signalInstance.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"};");
                _builder.newLine();
                _builder.newLine();
                EList _signalInstances_1 = null;
                if (BleGenerator.this.setup != null) {
                    _signalInstances_1 = BleGenerator.this.setup.getSignalInstances();
                }
                for (SignalInstance signalInstance_1 : _signalInstances_1) {
                    _builder.append((Object)"/* ");
                    String _name_1 = signalInstance_1.getName();
                    _builder.append((Object)_name_1);
                    _builder.append((Object)" characteristic */");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"static Att16BitCharacteristicAttribute ");
                    _builder.append((Object)baseName);
                    String _firstUpper = StringExtensions.toFirstUpper((String)signalInstance_1.getName());
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)"CharacteristicAttribute;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"static uint8_t ");
                    _builder.append((Object)baseName);
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)signalInstance_1.getName());
                    _builder.append((Object)_firstUpper_1);
                    _builder.append((Object)"UuidValue[ATTPDU_SIZEOF_128_BIT_UUID] = { ");
                    CharSequence _characteristicUuid = BleGenerator.getCharacteristicUuid(signalInstance_1);
                    _builder.append((Object)_characteristicUuid);
                    _builder.append((Object)" };");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"static AttUuid ");
                    _builder.append((Object)baseName);
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)signalInstance_1.getName());
                    _builder.append((Object)_firstUpper_2);
                    _builder.append((Object)"Uuid;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"static ");
                    ITypeSystemInferrer.InferenceResult _infer = BleGenerator.this.typeInferrer.infer((EObject)signalInstance_1);
                    List _bindings = null;
                    if (_infer != null) {
                        _bindings = _infer.getBindings();
                    }
                    ITypeSystemInferrer.InferenceResult _head = null;
                    if (_bindings != null) {
                        _head = (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)_bindings);
                    }
                    CodeFragment _code = BleGenerator.this.typeGenerator.code(ModelUtils.toSpecifier((ITypeSystemInferrer.InferenceResult)_head));
                    _builder.append((Object)_code);
                    _builder.append((Object)" ");
                    _builder.append((Object)baseName);
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)signalInstance_1.getName());
                    _builder.append((Object)_firstUpper_3);
                    _builder.append((Object)"Value;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"static AttAttribute ");
                    _builder.append((Object)baseName);
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)signalInstance_1.getName());
                    _builder.append((Object)_firstUpper_4);
                    _builder.append((Object)"Attribute;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                CodeFragment _buildServiceCallback = BleGenerator.this.buildServiceCallback(BleGenerator.this.setup, BleGenerator.this.eventHandler);
                _builder.append((Object)_buildServiceCallback);
                _builder.newLineIfNotEmpty();
                CodeFragment _buildSetupCharacteristic = BleGenerator.this.buildSetupCharacteristic(BleGenerator.this.setup);
                _builder.append((Object)_buildSetupCharacteristic);
                _builder.newLineIfNotEmpty();
                CodeFragment _buildReadWriteCallback = BleGenerator.this.buildReadWriteCallback(BleGenerator.this.setup, BleGenerator.this.eventHandler);
                _builder.append((Object)_buildReadWriteCallback);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"static Retcode_T ");
                String _baseName = BleGenerator.this._generatorUtils.getBaseName((Object)BleGenerator.this.component);
                _builder.append((Object)_baseName);
                _builder.append((Object)"_SendData(uint8_t* dataToSend, uint8_t dataToSendLen, void * param, uint32_t timeout)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (pdTRUE == xSemaphoreTake(BleSendGuardMutex, pdMS_TO_TICKS(BLE_EVENT_SYNC_TIMEOUT)))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (BleIsConnected == true)");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"BleSendStatus = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"/* This is a dummy take. In case of any callback received");
                _builder.newLine();
                _builder.append((Object)"\t\t\t ");
                _builder.append((Object)"* after the previous timeout will be cleared here. */");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"(void) xSemaphoreTake(BleSendCompleteSignal, pdMS_TO_TICKS(0));");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"// tell the world via BLE");
                _builder.newLine();
                EList _signalInstances_2 = null;
                if (BleGenerator.this.setup != null) {
                    _signalInstances_2 = BleGenerator.this.setup.getSignalInstances();
                }
                for (SignalInstance signalInstance_2 : _signalInstances_2) {
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"if((enum ");
                    _builder.append((Object)baseName, "\t\t\t");
                    _builder.append((Object)"_E)param == ");
                    _builder.append((Object)baseName, "\t\t\t");
                    _builder.append((Object)"_");
                    String _name_2 = signalInstance_2.getName();
                    _builder.append((Object)_name_2, "\t\t\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"ATT_SERVER_SecureDatabaseAccess();");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"AttStatus status = ATT_SERVER_WriteAttributeValue(");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t    ");
                    _builder.append((Object)"&");
                    _builder.append((Object)baseName, "\t\t\t\t    ");
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)signalInstance_2.getName());
                    _builder.append((Object)_firstUpper_5, "\t\t\t\t    ");
                    _builder.append((Object)"Attribute,");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t    ");
                    _builder.append((Object)"dataToSend,");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t    ");
                    _builder.append((Object)"dataToSendLen");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)");");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (status == BLESTATUS_SUCCESS) /* send notification */");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"status = ATT_SERVER_SendNotification(&");
                    _builder.append((Object)baseName, "\t\t\t \t\t");
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)signalInstance_2.getName());
                    _builder.append((Object)_firstUpper_6, "\t\t\t \t\t");
                    _builder.append((Object)"Attribute, 1);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"/* BLESTATUS_SUCCESS and BLESTATUS_PENDING are fine */");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"if ((status == BLESTATUS_FAILED) || (status == BLESTATUS_INVALID_PARMS))");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t \t");
                    _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, (Retcode_T ) RETCODE_SEND_NOTIFICATION_FAILED);");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"if (BLESTATUS_SUCCESS != status)");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t\t");
                    _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, (Retcode_T ) RETCODE_REWRITE_OF_ATT_FAILED);");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"ATT_SERVER_ReleaseDatabaseAccess();");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"if (pdTRUE != xSemaphoreTake(BleSendCompleteSignal, pdMS_TO_TICKS(timeout)))");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t\t");
                    _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_BLE_START_FAILED);");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)" \t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.newLine();
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t \t");
                _builder.append((Object)"retcode = EXCEPTION_NODEVICECONNECTEDEXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"\t    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(BleSendGuardMutex))");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"/* This is fatal since the BleSendGuardMutex must be given as the same thread takes this */");
                _builder.newLine();
                _builder.append((Object)"\t\t \t");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_FATAL, RETCODE_BLE_SEND_MUTEX_NOT_RELEASED);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return retcode;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = _addHeader.setPreamble(_client_1);
        return _xblockexpression;
    }

    private static CharSequence getCharacteristicUuid(SignalInstance value) {
        CharSequence _xblockexpression = null;
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object uuidRawValue = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)value, (String)"UUID"), (Procedures.Procedure1)_function);
        Integer _xifexpression = null;
        _xifexpression = uuidRawValue instanceof Integer ? (Integer)uuidRawValue : Integer.valueOf(value.getName().hashCode());
        Integer uuid = _xifexpression;
        _xblockexpression = BleGenerator.getUuidArrayCode(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{102, 154, 12, 32, 0, 8, 248, 130, 228, 17, 102, 113})), uuid);
        return _xblockexpression;
    }

    private static CharSequence getUuidArrayCode(List<Integer> header, Integer tail) {
        StringConcatenation _xblockexpression = null;
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(tail);
        StringConcatenation _builder = new StringConcatenation();
        List _reverse = ListExtensions.reverse((List)((List)Conversions.doWrapArray((Object)buffer.array())));
        boolean _hasElements = false;
        for (Byte i : _reverse) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("0x");
            String _upperCase = Integer.toHexString(i & 0xFF).toUpperCase();
            _builder.append(_upperCase);
        }
        _builder.append(", ");
        boolean _hasElements_1 = false;
        for (Integer i_1 : header) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("0x");
            String _upperCase_1 = Integer.toHexString(i_1 & 0xFF).toUpperCase();
            _builder.append(_upperCase_1);
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CodeFragment buildServiceCallback(final SystemResourceSetup component, Iterable<EventHandlerDeclaration> declarations) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static void ");
                String _baseName = BleGenerator.this._generatorUtils.getBaseName((Object)component);
                _builder.append((Object)_baseName);
                _builder.append((Object)"_ServiceCallback(AttServerCallbackParms *serverCallbackParams)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"switch (serverCallbackParams->event)");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"case ATTEVT_SERVER_HVI_SENT:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if (ATTSTATUS_SUCCESS != serverCallbackParams->status)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"Retcode_RaiseError(RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_DATA_SEND_FAIL));");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(BleSendCompleteSignal))");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"/* This is fatal since the BleSendGuardMutex must be given as the same thread takes this */");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"Retcode_RaiseError(RETCODE(RETCODE_SEVERITY_FATAL, RETCODE_BLE_SEND_MUTEX_NOT_RELEASED));");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"default:");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    private CodeFragment buildReadWriteCallback(SystemResourceSetup component, Iterable<EventHandlerDeclaration> eventHandler) {
        CodeFragment _xblockexpression = null;
        final String baseName = this._generatorUtils.getBaseName((Object)component);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static void ");
                _builder.append((Object)baseName);
                _builder.append((Object)"_OnEvent(BlePeripheral_Event_T event, void* data)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BCDS_UNUSED(data);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BleEvent = event;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"switch (event)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case BLE_PERIPHERAL_STARTED:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"printf(\"BleEventCallBack : BLE powered ON successfully \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(BleEventSignal))");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"/* We would not expect this call to fail because we expect the application thread to wait for this semaphore */");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"Retcode_RaiseError(RETCODE(RETCODE_SEVERITY_WARNING, RETCODE_SEMAPHORE_ERROR));");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case BLE_PERIPHERAL_SERVICES_REGISTERED:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case BLE_PERIPHERAL_SLEEP_SUCCEEDED:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"printf(\"BleEventCallBack : BLE successfully entered into sleep mode \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case BLE_PERIPHERAL_WAKEUP_SUCCEEDED:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"printf(\"BleEventCallBack : Device Wake up succeeded \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(BleEventSignal))");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"/* We would not expect this call to fail because we expect the application thread to wait for this semaphore */");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"Retcode_RaiseError(RETCODE(RETCODE_SEVERITY_WARNING, RETCODE_SEMAPHORE_ERROR));");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case BLE_PERIPHERAL_CONNECTED:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"printf(\"BleEventCallBack : Device connected \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"BleIsConnected = true;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case BLE_PERIPHERAL_DISCONNECTED:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"printf(\"BleEventCallBack : Device Disconnected \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"BleIsConnected = false;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case BLE_PERIPHERAL_ERROR:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"printf(\"BleEventCallBack : BLE Error Event \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"default:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"Retcode_RaiseError(RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_BLE_INVALID_EVENT_RECEIVED));");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000);
        return _xblockexpression;
    }

    private CodeFragment buildSetupCharacteristic(SystemResourceSetup component) {
        CodeFragment _xblockexpression = null;
        final String baseName = this._generatorUtils.getBaseName((Object)component);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static Retcode_T ");
                _builder.append((Object)baseName);
                _builder.append((Object)"_ServiceRegistry(void)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"// register service we'll connect our characteristics to");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"ATT_SERVER_SecureDatabaseAccess();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"AttStatus registerStatus = ATT_SERVER_RegisterServiceAttribute(");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"ATTPDU_SIZEOF_128_BIT_UUID,");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)baseName, "\t\t");
                _builder.append((Object)"ServiceUid,");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)baseName, "\t\t");
                _builder.append((Object)"_ServiceCallback,");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"&");
                _builder.append((Object)baseName, "\t\t");
                _builder.append((Object)"Service");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"ATT_SERVER_ReleaseDatabaseAccess();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if(registerStatus != BLESTATUS_SUCCESS)");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return registerStatus;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                EList _signalInstances = BleGenerator.this.setup.getSignalInstances();
                for (SignalInstance signalInstance : _signalInstances) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"// setup ");
                    String _name = signalInstance.getName();
                    _builder.append((Object)_name, "\t");
                    _builder.append((Object)" characteristics");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)baseName, "\t");
                    String _firstUpper = StringExtensions.toFirstUpper((String)signalInstance.getName());
                    _builder.append((Object)_firstUpper, "\t");
                    _builder.append((Object)"Uuid.size = ATT_UUID_SIZE_128;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)baseName, "\t");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)signalInstance.getName());
                    _builder.append((Object)_firstUpper_1, "\t");
                    _builder.append((Object)"Uuid.value.uuid128 = ");
                    _builder.append((Object)baseName, "\t");
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)signalInstance.getName());
                    _builder.append((Object)_firstUpper_2, "\t");
                    _builder.append((Object)"UuidValue;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"ATT_SERVER_SecureDatabaseAccess();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"registerStatus = ATT_SERVER_AddCharacteristic(");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"ATTPROPERTY_READ | ATTPROPERTY_WRITE | ATTPROPERTY_NOTIFY,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"&");
                    _builder.append((Object)baseName, "\t\t");
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)signalInstance.getName());
                    _builder.append((Object)_firstUpper_3, "\t\t");
                    _builder.append((Object)"CharacteristicAttribute,");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"&");
                    _builder.append((Object)baseName, "\t\t");
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)signalInstance.getName());
                    _builder.append((Object)_firstUpper_4, "\t\t");
                    _builder.append((Object)"Uuid,");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"ATT_PERMISSIONS_ALLACCESS, ");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    Integer _contentLength = BleGenerator.this.getContentLength(signalInstance);
                    _builder.append((Object)_contentLength, "\t\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"(uint8_t *) &");
                    _builder.append((Object)baseName, "\t\t");
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)signalInstance.getName());
                    _builder.append((Object)_firstUpper_5, "\t\t");
                    _builder.append((Object)"Value,");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"FALSE,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    Integer _contentLength_1 = BleGenerator.this.getContentLength(signalInstance);
                    _builder.append((Object)_contentLength_1, "\t\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"&");
                    _builder.append((Object)baseName, "\t\t");
                    _builder.append((Object)"Service,");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"&");
                    _builder.append((Object)baseName, "\t\t");
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)signalInstance.getName());
                    _builder.append((Object)_firstUpper_6, "\t\t");
                    _builder.append((Object)"Attribute");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)");");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if(registerStatus != BLESTATUS_SUCCESS)");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_FAILURE);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"ATT_SERVER_ReleaseDatabaseAccess();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"return (retcode);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client);
        return _xblockexpression;
    }

    private Integer getContentLength(SignalInstance value) {
        ITypeSystemInferrer.InferenceResult _infer = this.typeInferrer.infer((EObject)value);
        List _bindings = null;
        if (_infer != null) {
            _bindings = _infer.getBindings();
        }
        ITypeSystemInferrer.InferenceResult _head = null;
        if (_bindings != null) {
            _head = (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)_bindings);
        }
        Type _type = null;
        if (_head != null) {
            _type = _head.getType();
        }
        Type type = _type;
        Integer _switchResult = null;
        String _name = null;
        if (type != null) {
            _name = type.getName();
        }
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)"bool")) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"int32")) {
            _matched = true;
            _switchResult = 4;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"uint32")) {
            _matched = true;
            _switchResult = 4;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* @todo - BLE in XDK is unstable for wakeup upon bootup.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Added this delay for the same.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* This needs to be addressed in the HAL/BSP. */");
                _builder.newLine();
                _builder.append((Object)"vTaskDelay(pdMS_TO_TICKS(1000));");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* This is a dummy take. In case of any callback received");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* after the previous timeout will be cleared here. */");
                _builder.newLine();
                _builder.append((Object)"(void) xSemaphoreTake(BleEventSignal, pdMS_TO_TICKS(0));");
                _builder.newLine();
                _builder.append((Object)"retcode = BlePeripheral_Start();");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (pdTRUE != xSemaphoreTake(BleEventSignal, pdMS_TO_TICKS(BLE_EVENT_SYNC_TIMEOUT)))");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_BLE_START_FAILED);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"else if (BleEvent != BLE_PERIPHERAL_STARTED)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_BLE_START_FAILED);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"/* Do not disturb retcode */;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* This is a dummy take. In case of any callback received");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* after the previous timeout will be cleared here. */");
                _builder.newLine();
                _builder.append((Object)"(void) xSemaphoreTake(BleEventSignal, pdMS_TO_TICKS(0));");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"retcode = BlePeripheral_Wakeup();");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (pdTRUE != xSemaphoreTake(BleEventSignal, pdMS_TO_TICKS(BLE_EVENT_SYNC_TIMEOUT)))");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_BLE_WAKEUP_FAILED);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"else if (BleEvent != BLE_PERIPHERAL_WAKEUP_SUCCEEDED)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_BLE_WAKEUP_FAILED);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"/* Do not disturb retcode */;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return retcode;");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateSignalInstanceSetter(final SignalInstance signalInstance, final String resultName) {
        CodeFragment _xblockexpression = null;
        final String baseName = this._generatorUtils.getBaseName((Object)this.setup);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"if(");
                _builder.append((Object)resultName);
                _builder.append((Object)" == NULL)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_NULL_POINTER);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"memcpy(&");
                _builder.append((Object)baseName, "\t");
                String _firstUpper = StringExtensions.toFirstUpper((String)signalInstance.getName());
                _builder.append((Object)_firstUpper, "\t");
                _builder.append((Object)"Value, ");
                _builder.append((Object)resultName, "\t");
                _builder.append((Object)", sizeof(");
                CodeFragment _code = BleGenerator.this.typeGenerator.code(signalInstance.getInstanceOf().getTypeSpecifier());
                _builder.append((Object)_code, "\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"retcode = ");
                String _baseName = BleGenerator.this._generatorUtils.getBaseName((Object)BleGenerator.this.component);
                _builder.append((Object)_baseName, "\t");
                _builder.append((Object)"_SendData((uint8_t *) &");
                _builder.append((Object)baseName, "\t");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)signalInstance.getName());
                _builder.append((Object)_firstUpper_1, "\t");
                _builder.append((Object)"Value, sizeof(");
                CodeFragment _code_1 = BleGenerator.this.typeGenerator.code(signalInstance.getInstanceOf().getTypeSpecifier());
                _builder.append((Object)_code_1, "\t");
                _builder.append((Object)"), (void*)");
                _builder.append((Object)baseName, "\t");
                _builder.append((Object)"_");
                String _name = signalInstance.getName();
                _builder.append((Object)_name, "\t");
                _builder.append((Object)",1000);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return retcode;");
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client);
        return _xblockexpression;
    }

    public CodeFragment generateSignalInstanceGetter(final SignalInstance signalInstance, final String resultName) {
        CodeFragment _xblockexpression = null;
        final String baseName = this._generatorUtils.getBaseName((Object)this.setup);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(");
                _builder.append((Object)resultName);
                _builder.append((Object)" == NULL)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_NULL_POINTER);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"memcpy(");
                _builder.append((Object)resultName);
                _builder.append((Object)", &");
                _builder.append((Object)baseName);
                String _firstUpper = StringExtensions.toFirstUpper((String)signalInstance.getName());
                _builder.append((Object)_firstUpper);
                _builder.append((Object)"Value, sizeof(");
                CodeFragment _code = BleGenerator.this.typeGenerator.code(signalInstance.getInstanceOf().getTypeSpecifier());
                _builder.append((Object)_code);
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client).addHeader("string.h", true);
        return _xblockexpression;
    }
}

