/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class AdcGenerator
extends AbstractSystemResourceGenerator {
    public CodeFragment generateSetup(final Iterable<SignalInfo> signalInstances) {
        CodeFragment _xblockexpression = null;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = AdcCentral_Init();");
                _builder.newLine();
                _builder.append((Object)"if(exception != RETCODE_OK) return exception;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"AdcSampleSemaphore = xSemaphoreCreateBinary();");
                _builder.newLine();
                _builder.append((Object)"if(AdcSampleSemaphore == NULL) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        CodeFragment setupCode = this.codeFragmentProvider.create(_client).addHeader("FreeRTOS.h", true, 1000).addHeader("semphr.h", true).addHeader("BSP_Adc.h", true).addHeader("Mcu_Adc.h", true).addHeader("AdcCentral.h", true);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static uint16_t AdcResultBuffer = 0;");
                _builder.newLine();
                _builder.append((Object)"static SemaphoreHandle_t AdcSampleSemaphore = NULL;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"static void adcCallback(ADC_T adc, uint16_t* buffer) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BCDS_UNUSED(adc);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BCDS_UNUSED(buffer);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BaseType_t higherPriorityTaskWoken = pdFALSE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (pdTRUE == xSemaphoreGiveFromISR(AdcSampleSemaphore, &higherPriorityTaskWoken))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"portYIELD_FROM_ISR(higherPriorityTaskWoken);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"/* ignore... semaphore has already been given */");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                for (SignalInfo channel : signalInstances) {
                    _builder.append((Object)"AdcCentral_ConfigSingle_T ");
                    _builder.append((Object)channel.configName);
                    _builder.append((Object)" = {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".AcqTime = ");
                    _builder.append((Object)channel.sampleTime, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".Appcallback = adcCallback,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".BufferPtr = &AdcResultBuffer,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".Channel = ");
                    _builder.append((Object)channel.channel, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".Reference = ");
                    _builder.append((Object)channel.referenceVoltage, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".Resolution = ");
                    _builder.append((Object)channel.resolution, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"};");
                    _builder.newLine();
                    _builder.newLine();
                }
            }
        };
        _xblockexpression = setupCode.setPreamble((IGeneratorNode)this.codeFragmentProvider.create(_client_1));
        return _xblockexpression;
    }

    public CodeFragment generateSetup() {
        Functions.Function1<SignalInstance, SignalInfo> _function = new Functions.Function1<SignalInstance, SignalInfo>(){

            public SignalInfo apply(SignalInstance it) {
                String _configName = AdcGenerator.this.getConfigName(it);
                String _sampleTime = AdcGenerator.this.getSampleTime(it);
                String _channel = AdcGenerator.this.getChannel(it);
                String _referenceVoltage = AdcGenerator.this.getReferenceVoltage(it);
                String _resolution = AdcGenerator.this.getResolution(it);
                return new SignalInfo(_configName, _sampleTime, _channel, _referenceVoltage, _resolution);
            }
        };
        return this.generateSetup(ListExtensions.map((List)this.setup.getSignalInstances(), (Functions.Function1)_function));
    }

    public String getConfigName(SignalInstance inst) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = inst.getName();
        _builder.append(_name);
        _builder.append("_config");
        return _builder.toString();
    }

    public String getSampleTime(SignalInstance inst) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ADC_ACQ_");
        Enumerator _argumentEnum = this.getArgumentEnum(inst, "sampleTime");
        String _name = null;
        if (_argumentEnum != null) {
            _name = _argumentEnum.getName();
        }
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase);
        return _builder.toString();
    }

    public String getChannel(SignalInstance inst) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ADC_ENABLE_");
        Enumerator _argumentEnum = this.getArgumentEnum(inst, "channel");
        String _name = null;
        if (_argumentEnum != null) {
            _name = _argumentEnum.getName();
        }
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase);
        return _builder.toString();
    }

    public String getReferenceVoltage(SignalInstance inst) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ADC_");
        Enumerator _argumentEnum = this.getArgumentEnum(inst, "referenceVoltage");
        String _name = null;
        if (_argumentEnum != null) {
            _name = _argumentEnum.getName();
        }
        String _replace = _name.replace("Ref", "REF");
        _builder.append(_replace);
        return _builder.toString();
    }

    public String getResolution(SignalInstance inst) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ADC_");
        Enumerator _argumentEnum = this.getArgumentEnum(inst, "resolution");
        String _name = null;
        if (_argumentEnum != null) {
            _name = _argumentEnum.getName();
        }
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase);
        return _builder.toString();
    }

    public int getResolutionBits(SignalInstance instance) {
        Enumerator _argumentEnum = this.getArgumentEnum(instance, "resolution");
        String _name = null;
        if (_argumentEnum != null) {
            _name = _argumentEnum.getName();
        }
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)"Resolution_12Bit")) {
            _matched = true;
            return 12;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Resolution_8Bit")) {
            _matched = true;
            return 8;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Resolution_6Bit")) {
            _matched = true;
            return 6;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Resolution_OVS")) {
            _matched = true;
            return 16;
        }
        return -1;
    }

    public int getExternalReferenceVoltage() {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object v = StaticValueInferrer.infer((EObject)this.setup.getConfigurationItemValue("externalReferenceVoltage"), (Procedures.Procedure1)_function);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return -1;
    }

    public int getReferenceVoltageInMilliVolt(SignalInstance instance) {
        Enumerator _argumentEnum = this.getArgumentEnum(instance, "referenceVoltage");
        String _name = null;
        if (_argumentEnum != null) {
            _name = _argumentEnum.getName();
        }
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)"Ref_1V25")) {
            _matched = true;
            return 1250;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Ref_2V5")) {
            _matched = true;
            return 2500;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Ref_VDD")) {
            _matched = true;
            return 2500;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Ref_5VDiff")) {
            _matched = true;
            return 5000;
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Ref_ExtSingle")) {
            _matched = true;
            return this.getExternalReferenceVoltage();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Ref_ExtDiff")) {
            _matched = true;
            return this.getExternalReferenceVoltage();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Ref_2xVDD")) {
            _matched = true;
            return 5000;
        }
        return -1;
    }

    public Enumerator getArgumentEnum(SignalInstance inst, String name) {
        Procedures.Procedure1<EObject> _function;
        Expression argValue = ModelUtils.getArgumentValue((SignalInstance)inst, (String)name);
        Object _xifexpression = null;
        _xifexpression = argValue instanceof FeatureCall ? ((FeatureCall)argValue).getFeature() : argValue;
        Object value = StaticValueInferrer.infer((EObject)_xifexpression, (Procedures.Procedure1)(_function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        }));
        if (value instanceof Enumerator) {
            return (Enumerator)value;
        }
        return null;
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSignalInstanceSetter(SignalInstance signalInstance, String valueVariableName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_FAILURE);");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateSignalInstanceGetter(final String configName, final int refVoltageInMV, final int resolutionBits, final String resultName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"exception = AdcCentral_StartSingle(BSP_Adc_GetHandle(), &");
                _builder.append((Object)configName);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"if(exception != NO_EXCEPTION) return exception;");
                _builder.newLine();
                _builder.append((Object)"if (pdTRUE != xSemaphoreTake(AdcSampleSemaphore, (TickType_t) pdMS_TO_TICKS(100)))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_TIMEOUT);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"*");
                _builder.append((Object)resultName, "\t");
                _builder.append((Object)" = AdcResultBuffer * ");
                _builder.append((Object)refVoltageInMV, "\t");
                _builder.append((Object)" / ");
                _builder.append((Object)(1 << resolutionBits), "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateSignalInstanceGetter(final SignalInstance signalInstance, final String resultName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = NO_EXCEPTION;");
                _builder.newLine();
                CodeFragment _generateSignalInstanceGetter = AdcGenerator.this.generateSignalInstanceGetter(AdcGenerator.this.getConfigName(signalInstance), AdcGenerator.this.getReferenceVoltageInMilliVolt(signalInstance), AdcGenerator.this.getResolutionBits(signalInstance), resultName);
                _builder.append((Object)_generateSignalInstanceGetter);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"return exception;");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    @FinalFieldsConstructor
    @Accessors
    public static class SignalInfo {
        private final String configName;
        private final String sampleTime;
        private final String channel;
        private final String referenceVoltage;
        private final String resolution;

        public SignalInfo(String configName, String sampleTime, String channel, String referenceVoltage, String resolution) {
            this.configName = configName;
            this.sampleTime = sampleTime;
            this.channel = channel;
            this.referenceVoltage = referenceVoltage;
            this.resolution = resolution;
        }

        @Pure
        public String getConfigName() {
            return this.configName;
        }

        @Pure
        public String getSampleTime() {
            return this.sampleTime;
        }

        @Pure
        public String getChannel() {
            return this.channel;
        }

        @Pure
        public String getReferenceVoltage() {
            return this.referenceVoltage;
        }

        @Pure
        public String getResolution() {
            return this.resolution;
        }
    }
}

