/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.stdlib;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.ArrayLiteral;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.InvalidElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ArraySizeInferrer
extends ElementSizeInferrer {
    @Inject
    protected ITypeSystem registry;

    protected ElementSizeInferenceResult _doInfer(NewInstanceExpression obj) {
        TypeSpecifier parentType = ModelUtils.toSpecifier((ITypeSystemInferrer.InferenceResult)this.typeInferrer.infer(obj.eContainer()));
        EObject _reference = obj.getReference();
        Expression rawSizeValue = ModelUtils.getArgumentValue((Operation)((Operation)_reference), (ArgumentExpression)obj, (String)"size");
        if (rawSizeValue == null) {
            return new InvalidElementSizeInferenceResult((EObject)obj, parentType, "size missing");
        }
        if (parentType == null) {
            return new InvalidElementSizeInferenceResult((EObject)obj, parentType, "parent type unknown");
        }
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject x) {
            }
        };
        Object staticSizeValue = StaticValueInferrer.infer((EObject)rawSizeValue, (Procedures.Procedure1)_function);
        Object _xifexpression = null;
        _xifexpression = staticSizeValue == null ? this.newInvalidResult(obj.getReference(), "Cannot infer static value") : new ValidElementSizeInferenceResult((EObject)obj, parentType, ((Integer)staticSizeValue).intValue());
        InvalidElementSizeInferenceResult result = _xifexpression;
        TypeSpecifier typeOfChildren = (TypeSpecifier)IterableExtensions.head((Iterable)parentType.getTypeArguments());
        result.getChildren().add(this.inferFromType((EObject)obj, typeOfChildren));
        return result;
    }

    protected ElementSizeInferenceResult _doInfer(ArrayLiteral obj) {
        Type _type_1;
        boolean _tripleEquals;
        TypeSpecifier parentType = ModelUtils.toSpecifier((ITypeSystemInferrer.InferenceResult)this.typeInferrer.infer(obj.eContainer()));
        TypeSpecifier typeOfChildren = (TypeSpecifier)IterableExtensions.head((Iterable)parentType.getTypeArguments());
        int _length = ((Object[])Conversions.unwrapArray((Object)obj.getValues(), Object.class)).length;
        ValidElementSizeInferenceResult result = new ValidElementSizeInferenceResult((EObject)obj, parentType, _length);
        Type _type = typeOfChildren.getType();
        boolean bl = _tripleEquals = _type == (_type_1 = this.registry.getType("array"));
        if (_tripleEquals) {
            result.getChildren().add(this.infer((EObject)IterableExtensions.head((Iterable)obj.getValues())));
        } else {
            result.getChildren().add(super.infer((EObject)IterableExtensions.head((Iterable)obj.getValues())));
        }
        return result;
    }

    protected ElementSizeInferenceResult _doInfer(ElementReferenceExpression obj) {
        if (obj.isArrayAccess() && IterableExtensions.head((Iterable)obj.getArraySelector()) instanceof ValueRange) {
            Expression _head = (Expression)IterableExtensions.head((Iterable)obj.getArraySelector());
            ValueRange valRange = (ValueRange)_head;
            TypeSpecifier parentType = ModelUtils.toSpecifier((ITypeSystemInferrer.InferenceResult)this.typeInferrer.infer((EObject)obj));
            TypeSpecifier typeOfChildren = (TypeSpecifier)IterableExtensions.head((Iterable)parentType.getTypeArguments());
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject x) {
                }
            };
            Object lowerBound = StaticValueInferrer.infer((EObject)valRange.getLowerBound(), (Procedures.Procedure1)_function);
            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject x) {
                }
            };
            Object upperBound = StaticValueInferrer.infer((EObject)valRange.getUpperBound(), (Procedures.Procedure1)_function_1);
            if (!(lowerBound instanceof Integer) || !(upperBound instanceof Integer)) {
                return new InvalidElementSizeInferenceResult((EObject)obj, parentType, "can not infer size for this range");
            }
            int elCount = (Integer)upperBound - (Integer)lowerBound + 1;
            ValidElementSizeInferenceResult result = new ValidElementSizeInferenceResult((EObject)obj, parentType, elCount);
            result.getChildren().add(this.inferFromType((EObject)obj, typeOfChildren));
            return result;
        }
        return super._doInfer(obj);
    }

    protected ElementSizeInferenceResult doInfer(EObject obj) {
        if (obj instanceof FunctionDefinition) {
            return this._doInfer((FunctionDefinition)obj);
        }
        if (obj instanceof VariableDeclaration) {
            return this._doInfer((VariableDeclaration)obj);
        }
        if (obj instanceof NewInstanceExpression) {
            return this._doInfer((NewInstanceExpression)obj);
        }
        if (obj instanceof ElementReferenceExpression) {
            return this._doInfer((ElementReferenceExpression)obj);
        }
        if (obj instanceof PrimitiveValueExpression) {
            return this._doInfer((PrimitiveValueExpression)obj);
        }
        if (obj instanceof ArrayAccessExpression) {
            return this._doInfer((ArrayAccessExpression)obj);
        }
        if (obj instanceof ArrayLiteral) {
            return this._doInfer((ArrayLiteral)obj);
        }
        if (obj instanceof ReturnStatement) {
            return this._doInfer((ReturnStatement)obj);
        }
        if (obj != null) {
            return this._doInfer(obj);
        }
        if (obj == null) {
            return this._doInfer(null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(obj).toString());
    }
}

