/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.cli.commands;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import org.apache.commons.cli.Options;
import org.eclipse.mita.cli.commands.AbstractCommand;
import org.eclipse.mita.cli.loader.StandaloneModule;
import org.eclipse.mita.cli.loader.StandanloneLangServerModule;
import org.eclipse.mita.program.ProgramDslRuntimeModule;
import org.eclipse.xtext.ide.server.LaunchArgs;
import org.eclipse.xtext.ide.server.ServerLauncher;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;

public class LanguageServerCommand
extends AbstractCommand {
    @Override
    public Options getOptions() {
        Options result = new Options();
        result.addOption("t", "trace", false, "Enable tracing of incoming/outgoing messages");
        result.addOption("s", "should-validate", false, "Enable validation of incoming messages");
        result.addOption("d", "debug", false, "Log standard out for debugging");
        return result;
    }

    @Override
    public void run() {
        try {
            ProgramDslRuntimeModule _programDslRuntimeModule = new ProgramDslRuntimeModule();
            Modules.OverriddenModuleBuilder _override = Modules.override((Module[])new Module[]{_programDslRuntimeModule});
            StandaloneModule _standaloneModule = new StandaloneModule();
            ServerModule _serverModule = new ServerModule();
            Modules.OverriddenModuleBuilder _override_1 = Modules.override((Module[])new Module[]{_serverModule});
            StandanloneLangServerModule _standanloneLangServerModule = new StandanloneLangServerModule();
            Module programModule = _override.with(new Module[]{_standaloneModule, _override_1.with(new Module[]{_standanloneLangServerModule})});
            Injector programInjector = Guice.createInjector((Module[])new Module[]{programModule});
            IResourceServiceProvider.Registry languagesRegistry = (IResourceServiceProvider.Registry)programInjector.getInstance(IResourceServiceProvider.Registry.class);
            languagesRegistry.getExtensionToFactoryMap().put("mita", programInjector.getInstance(IResourceFactory.class));
            AsynchronousServerSocketChannel _open = AsynchronousServerSocketChannel.open();
            InetSocketAddress _inetSocketAddress = new InetSocketAddress("localhost", 5007);
            AsynchronousServerSocketChannel serverSocket = _open.bind(_inetSocketAddress);
            InputOutput.println((Object)"Language server started");
            while (true) {
                AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
                InputStream in = Channels.newInputStream(socketChannel);
                OutputStream out = Channels.newOutputStream(socketChannel);
                LaunchArgs launchArgs = new LaunchArgs();
                launchArgs.setIn(in);
                launchArgs.setOut(out);
                boolean _hasOption = this.commandLine.hasOption("t");
                if (_hasOption) {
                    FileOutputStream _fileOutputStream = new FileOutputStream("mita-language-server-trace.log");
                    PrintWriter _printWriter = new PrintWriter(_fileOutputStream);
                    launchArgs.setTrace(_printWriter);
                }
                launchArgs.setValidate(this.commandLine.hasOption("s"));
                ServerLauncher launcher = (ServerLauncher)programInjector.getInstance(ServerLauncher.class);
                launcher.start(launchArgs);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

