/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.types;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.types.NamedElement;
import org.eclipse.mita.base.types.TypesPackage;

public class TypesUtil {
    public static final String ID_SEPARATOR = ".";

    public static String computeQID(NamedElement element) {
        if (element.getName() == null) {
            return null;
        }
        StringBuilder id = new StringBuilder();
        id.append(element.getName());
        EObject container = element.eContainer();
        while (container != null) {
            if (container.eClass().getEAllStructuralFeatures().contains((Object)TypesPackage.Literals.NAMED_ELEMENT__NAME)) {
                TypesUtil.prependNamedElementName(id, container);
            } else {
                TypesUtil.prependContainingFeatureName(id, container);
            }
            container = container.eContainer();
        }
        return id.toString();
    }

    private static void prependNamedElementName(StringBuilder id, EObject container) {
        String name = (String)container.eGet((EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        if (name != null) {
            id.insert(0, ID_SEPARATOR);
            id.insert(0, name);
        }
    }

    private static void prependContainingFeatureName(StringBuilder id, EObject container) {
        EStructuralFeature feature = container.eContainingFeature();
        if (feature != null) {
            String name;
            if (feature.isMany()) {
                Object elements = container.eContainer().eGet(feature);
                int index = 0;
                if (elements instanceof BasicEList) {
                    BasicEList elementList = (BasicEList)elements;
                    index = elementList.indexOf((Object)container);
                }
                name = String.valueOf(feature.getName()) + index;
            } else {
                name = feature.getName();
            }
            id.insert(0, ID_SEPARATOR);
            id.insert(0, name);
        }
    }
}

