/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.ui.quickfix;

import com.google.inject.Inject;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.ImportStatement;
import org.eclipse.mita.base.types.TypesFactory;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.ui.quickfix.TypeDslQuickfixProvider;
import org.eclipse.mita.library.extension.LibraryExtensions;
import org.eclipse.mita.platform.ConfigurationItem;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramFactory;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.DefaultValueProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ProgramDslQuickfixProvider
extends TypeDslQuickfixProvider {
    @Inject
    protected IScopeProvider scopeProvider;
    @Inject
    protected ITypeSystem typeSystem;
    @Inject
    private DefaultValueProvider defaultValueProvider;

    @Fix(value="MissingPlatform")
    public void addMissingPlatform(final Issue issue, final IssueResolutionAcceptor acceptor) {
        Consumer<LibraryExtensions.LibraryDescriptor> _function = new Consumer<LibraryExtensions.LibraryDescriptor>(){

            @Override
            public void accept(final LibraryExtensions.LibraryDescriptor platform) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Import '");
                String _id = platform.getId();
                _builder.append(_id);
                _builder.append("' ");
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Add import for platform '");
                String _id_1 = platform.getId();
                _builder_1.append(_id_1);
                _builder_1.append("' ");
                ISemanticModification _function = new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        Program program = (Program)element;
                        EList _imports = program.getImports();
                        ImportStatement _createImportStatement = TypesFactory.eINSTANCE.createImportStatement();
                        Procedures.Procedure1<ImportStatement> _function = new Procedures.Procedure1<ImportStatement>(){

                            public void apply(ImportStatement it) {
                                it.setImportedNamespace(platform.getId());
                            }
                        };
                        ImportStatement _doubleArrow = (ImportStatement)ObjectExtensions.operator_doubleArrow((Object)_createImportStatement, (Procedures.Procedure1)_function);
                        _imports.add((Object)_doubleArrow);
                    }
                };
                acceptor.accept(issue, _builder.toString(), _builder_1.toString(), "", _function);
            }
        };
        LibraryExtensions.getAvailablePlatforms().forEach(_function);
    }

    @Fix(value="missing_config_item")
    public void addMissingConfigItem(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                final SystemResourceSetup setup = (SystemResourceSetup)element;
                Functions.Function1<ConfigurationItem, Boolean> _function = new Functions.Function1<ConfigurationItem, Boolean>(){

                    public Boolean apply(ConfigurationItem it) {
                        return it.getRequired();
                    }
                };
                Functions.Function1<ConfigurationItem, Boolean> _function_1 = new Functions.Function1<ConfigurationItem, Boolean>(){

                    public Boolean apply(ConfigurationItem it) {
                        Functions.Function1<ConfigurationItemValue, ConfigurationItem> _function = new Functions.Function1<ConfigurationItemValue, ConfigurationItem>(){

                            public ConfigurationItem apply(ConfigurationItemValue c) {
                                return c.getItem();
                            }
                        };
                        boolean _contains = ListExtensions.map((List)setup.getConfigurationItemValues(), (Functions.Function1)_function).contains(it);
                        return !_contains;
                    }
                };
                Consumer<ConfigurationItem> _function_2 = new Consumer<ConfigurationItem>(){

                    @Override
                    public void accept(ConfigurationItem missingItem) {
                        ConfigurationItemValue newConfigItemValue = ProgramFactory.eINSTANCE.createConfigurationItemValue();
                        setup.getConfigurationItemValues().add((Object)newConfigItemValue);
                        newConfigItemValue.setItem(missingItem);
                        newConfigItemValue.setValue(ProgramDslQuickfixProvider.this.defaultValueProvider.dummyExpression(missingItem.getType(), (EObject)newConfigItemValue));
                    }
                };
                IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)setup.getType().getConfigurationItems(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
            }
        };
        acceptor.accept(issue, "Add config items", "Add missing configuration items", "", _function);
    }
}

