/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.ExpressionsFactory;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.scoping.ILibraryProvider;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.PackageAssociation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.PrimitiveType;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypedElement;
import org.eclipse.mita.base.types.TypesFactory;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.util.BaseUtils;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.platform.Signal;
import org.eclipse.mita.platform.SignalParameter;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.TimeUnit;
import org.eclipse.mita.program.TryStatement;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.generator.internal.ProgramCopier;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ModelUtils {
    @Inject
    protected ILibraryProvider typesLibraryProvider;

    protected static VariableDeclaration _getUnderlyingVariableDeclaration(ArrayAccessExpression acc) {
        return ModelUtils.getUnderlyingVariableDeclaration((EObject)acc.getOwner());
    }

    protected static VariableDeclaration _getUnderlyingVariableDeclaration(FeatureCall fc) {
        return ModelUtils.getUnderlyingVariableDeclaration((EObject)fc.getOwner());
    }

    protected static VariableDeclaration _getUnderlyingVariableDeclaration(ElementReferenceExpression ere) {
        return ModelUtils.getUnderlyingVariableDeclaration(ere.getReference());
    }

    protected static VariableDeclaration _getUnderlyingVariableDeclaration(VariableDeclaration decl) {
        return decl;
    }

    protected static VariableDeclaration _getUnderlyingVariableDeclaration(EObject acc) {
        return null;
    }

    protected static VariableDeclaration _getUnderlyingVariableDeclaration(Void acc) {
        return null;
    }

    protected static Optional<EList<Parameter>> _getAccessorParameters(Operation op) {
        return Optional.of((Object)op.getParameters());
    }

    protected static Optional<EList<Parameter>> _getAccessorParameters(StructureType st) {
        return Optional.of((Object)st.getParameters());
    }

    protected static Optional<EList<Parameter>> _getAccessorParameters(AnonymousProductType apt) {
        boolean _equals;
        EList tss = apt.getTypeSpecifiers();
        int _length = ((Object[])Conversions.unwrapArray((Object)tss, Object.class)).length;
        boolean bl = _equals = _length == 1;
        if (_equals) {
            Type t0 = ((TypeSpecifier)IterableExtensions.head((Iterable)tss)).getType();
            return ModelUtils.getAccessorParameters((EObject)t0);
        }
        return Optional.absent();
    }

    protected static Optional<EList<Parameter>> _getAccessorParameters(NamedProductType npt) {
        return Optional.of((Object)npt.getParameters());
    }

    protected static Optional<EList<Parameter>> _getAccessorParameters(EObject obj) {
        return Optional.absent();
    }

    protected static Optional<EList<Parameter>> _getAccessorParameters(Void obj) {
        return Optional.absent();
    }

    public static <T> Optional<T> preventRecursion(EObject obj, final Functions.Function0<? extends T> action) {
        Functions.Function0 _function = new Functions.Function0<Optional<T>>(){

            public Optional<T> apply() {
                return Optional.fromNullable((Object)action.apply());
            }
        };
        Functions.Function0 _function_1 = new Functions.Function0<Optional<T>>(){

            public Optional<T> apply() {
                return Optional.absent();
            }
        };
        return (Optional)ModelUtils.preventRecursion(obj, _function, _function_1);
    }

    public static <T> T preventRecursion(EObject obj, Functions.Function0<? extends T> action, Functions.Function0<? extends T> onRecursion) {
        boolean _isMarked = PreventRecursionAdapter.isMarked(obj);
        if (_isMarked) {
            return (T)onRecursion.apply();
        }
        PreventRecursionAdapter adapter = PreventRecursionAdapter.applyTo(obj);
        try {
            Object object = action.apply();
            return (T)object;
        }
        finally {
            adapter.removeFrom(obj);
        }
    }

    public Platform getPlatform(Program program) {
        Functions.Function1<URI, Iterable<EObject>> _function_1;
        Functions.Function1<URI, Boolean> _function;
        Resource programResource = program.eResource();
        final ResourceSet resourceSet = programResource.getResourceSet();
        Iterable libraries = this.typesLibraryProvider.getImportedLibraries(programResource);
        Iterable platformResourceUris = IterableExtensions.filter((Iterable)libraries, (Functions.Function1)(_function = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI r) {
                String _fileExtension = r.fileExtension();
                return Objects.equal((Object)_fileExtension, (Object)"platform");
            }
        }));
        Iterable platforms = Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)platformResourceUris, (Functions.Function1)(_function_1 = new Functions.Function1<URI, Iterable<EObject>>(){

            public Iterable<EObject> apply(URI uri) {
                return IteratorExtensions.toIterable((Iterator)resourceSet.getResource(uri, true).getAllContents());
            }
        })), Platform.class);
        int _length = ((Object[])Conversions.unwrapArray((Object)platforms, Object.class)).length;
        boolean _greaterThan = _length > 1;
        return (Platform)IterableExtensions.head((Iterable)platforms);
    }

    public static PackageAssociation getPackageAssociation(EObject obj) {
        return (PackageAssociation)EcoreUtil2.getContainerOfType((EObject)obj, PackageAssociation.class);
    }

    public static boolean containsAbstractType(ITypeSystemInferrer.InferenceResult ir) {
        Predicate<Type> _function = new Predicate<Type>(){

            @Override
            public boolean test(Type t) {
                return t.isAbstract();
            }
        };
        return ModelUtils.containsTypeBy(true, _function, ir);
    }

    public static boolean containsTypeBy(final boolean onNull, final Predicate<Type> pred, ITypeSystemInferrer.InferenceResult ir) {
        Boolean _xblockexpression = null;
        if (ir == null) {
            return onNull;
        }
        boolean _test = pred.test(ir.getType());
        if (_test) {
            return true;
        }
        Functions.Function2<Boolean, ITypeSystemInferrer.InferenceResult, Boolean> _function = new Functions.Function2<Boolean, ITypeSystemInferrer.InferenceResult, Boolean>(){

            public Boolean apply(Boolean b, ITypeSystemInferrer.InferenceResult x) {
                return b != false || ModelUtils.containsTypeBy(onNull, pred, x);
            }
        };
        _xblockexpression = (Boolean)IterableExtensions.fold((Iterable)ir.getBindings(), (Object)false, (Functions.Function2)_function);
        return _xblockexpression;
    }

    public static boolean containsAbstractType(TypeSpecifier ts) {
        Boolean _xblockexpression = null;
        if (ts == null) {
            return true;
        }
        boolean _isAbstract = ts.getType().isAbstract();
        if (_isAbstract) {
            return true;
        }
        Functions.Function2<Boolean, TypeSpecifier, Boolean> _function = new Functions.Function2<Boolean, TypeSpecifier, Boolean>(){

            public Boolean apply(Boolean b, TypeSpecifier x) {
                return b != false || ModelUtils.containsAbstractType(x);
            }
        };
        _xblockexpression = (Boolean)IterableExtensions.fold((Iterable)ts.getTypeArguments(), (Object)false, (Functions.Function2)_function);
        return _xblockexpression;
    }

    public static int getIntervalInMilliseconds(TimeIntervalEvent event) {
        int base = event.getInterval().getValue();
        int _switchResult = 0;
        TimeUnit _unit = event.getUnit();
        if (_unit != null) {
            switch (_unit) {
                case MILLISECOND: {
                    _switchResult = 1;
                    break;
                }
                case SECOND: {
                    _switchResult = 1000;
                    break;
                }
                case MINUTE: {
                    _switchResult = 60000;
                    break;
                }
                case HOUR: {
                    _switchResult = 3600000;
                    break;
                }
            }
        }
        int factor = _switchResult;
        return base * factor;
    }

    public static boolean isModalityAccess(EObject statement) {
        EObject _feature;
        return statement instanceof FeatureCall && (_feature = ((FeatureCall)statement).getFeature()) instanceof Modality;
    }

    public static TypeSpecifier toSpecifier(ITypeSystemInferrer.InferenceResult inference) {
        if (inference == null) {
            return null;
        }
        TypeSpecifier result = TypesFactory.eINSTANCE.createTypeSpecifier();
        result.setType(inference.getType());
        Functions.Function1<ITypeSystemInferrer.InferenceResult, TypeSpecifier> _function = new Functions.Function1<ITypeSystemInferrer.InferenceResult, TypeSpecifier>(){

            public TypeSpecifier apply(ITypeSystemInferrer.InferenceResult x) {
                return ModelUtils.toSpecifier(x);
            }
        };
        result.getTypeArguments().addAll((Collection)ListExtensions.map((List)inference.getBindings(), (Functions.Function1)_function));
        return result;
    }

    public static String typeSpecifierIdentifier(TypeSpecifier x) {
        Functions.Function1<TypeSpecifier, String> _function = new Functions.Function1<TypeSpecifier, String>(){

            public String apply(TypeSpecifier it) {
                return ModelUtils.typeSpecifierIdentifier(it);
            }
        };
        Functions.Function2<String, String, String> _function_1 = new Functions.Function2<String, String, String>(){

            public String apply(String p1, String p2) {
                return String.valueOf(p1) + ", " + p2;
            }
        };
        String innerTypes = (String)IterableExtensions.reduce((Iterable)ListExtensions.map((List)x.getTypeArguments(), (Functions.Function1)_function), (Functions.Function2)_function_1);
        String _xifexpression = null;
        _xifexpression = innerTypes == null ? "" : "<" + innerTypes + ">";
        String innerString = _xifexpression;
        String _name = x.getType().getName();
        return String.valueOf(_name) + innerString;
    }

    public static boolean isInTryCatchFinally(EObject statement) {
        return statement != null && EcoreUtil2.getContainerOfType((EObject)statement, TryStatement.class) != null;
    }

    public static SystemResourceSetup findSetupFor(Program program, Class<? extends AbstractSystemResource> type, final String name) {
        Functions.Function1<SystemResourceSetup, Boolean> _function = new Functions.Function1<SystemResourceSetup, Boolean>(){

            public Boolean apply(SystemResourceSetup it) {
                AbstractSystemResource _type = it.getType();
                String _name = null;
                if (_type != null) {
                    _name = _type.getName();
                }
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return (SystemResourceSetup)IterableExtensions.findFirst(program.getSetup(), (Functions.Function1)_function);
    }

    public static TreeMap<Parameter, Argument> getSortedArgumentsAsMap(Iterable<Parameter> parameters, Iterable<Argument> arguments) {
        Iterable<Argument> args = ModelUtils.getSortedArguments(parameters, arguments);
        Comparator<Parameter> _function = new Comparator<Parameter>(){

            @Override
            public int compare(Parameter p1, Parameter p2) {
                return p1.getName().compareTo(p2.getName());
            }
        };
        final TreeMap<Parameter, Argument> map = new TreeMap<Parameter, Argument>(_function);
        Consumer<Pair<Parameter, Argument>> _function_1 = new Consumer<Pair<Parameter, Argument>>(){

            @Override
            public void accept(Pair<Parameter, Argument> it) {
                map.put((Parameter)it.getKey(), (Argument)it.getValue());
            }
        };
        BaseUtils.zip(parameters, args).forEach(_function_1);
        return map;
    }

    public static Iterable<Argument> getSortedArguments(Iterable<Parameter> parameters, final Iterable<Argument> arguments) {
        Iterable _xifexpression = null;
        if (IterableExtensions.isEmpty(arguments) || ((Argument)IterableExtensions.head(arguments)).getParameter() == null) {
            _xifexpression = arguments;
        } else {
            Functions.Function1<Parameter, Argument> _function = new Functions.Function1<Parameter, Argument>(){

                public Argument apply(final Parameter parm) {
                    Functions.Function1<Argument, Boolean> _function = new Functions.Function1<Argument, Boolean>(){

                        public Boolean apply(Argument it) {
                            Parameter _parameter = it.getParameter();
                            String _name = null;
                            if (_parameter != null) {
                                _name = _parameter.getName();
                            }
                            String _name_1 = parm.getName();
                            return Objects.equal((Object)_name, (Object)_name_1);
                        }
                    };
                    return (Argument)IterableExtensions.findFirst((Iterable)arguments, (Functions.Function1)_function);
                }
            };
            _xifexpression = IterableExtensions.map(parameters, (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    protected static Iterable<Pair<TypeSpecifier, Argument>> _getFunctionCallArguments(final FeatureCall functionCall) {
        Iterable<Pair<TypeSpecifier, Argument>> _xblockexpression = null;
        EObject fun = functionCall.getFeature();
        Iterable<Pair<TypeSpecifier, Argument>> _xifexpression = null;
        if (fun instanceof SumAlternative) {
            _xifexpression = ModelUtils.getFunctionCallArguments(fun, (Iterable<Argument>)functionCall.getArguments());
        } else if (fun instanceof TypedElement) {
            TypeSpecifier _typeSpecifier = ((TypedElement)fun).getTypeSpecifier();
            Argument _createArgument = ExpressionsFactory.eINSTANCE.createArgument();
            Procedures.Procedure1<Argument> _function = new Procedures.Procedure1<Argument>(){

                public void apply(Argument it) {
                    it.setValue(functionCall.getOwner());
                }
            };
            Argument _doubleArrow = (Argument)ObjectExtensions.operator_doubleArrow((Object)_createArgument, (Procedures.Procedure1)_function);
            Pair _mappedTo = Pair.of((Object)_typeSpecifier, (Object)_doubleArrow);
            Iterable<Pair<TypeSpecifier, Argument>> _functionCallArguments = ModelUtils.getFunctionCallArguments(fun, (Iterable<Argument>)functionCall.getArguments());
            return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo})), _functionCallArguments);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected static Iterable<Pair<TypeSpecifier, Argument>> _getFunctionCallArguments(ElementReferenceExpression functionCall) {
        Iterable<Pair<TypeSpecifier, Argument>> _xblockexpression = null;
        if (functionCall == null || !functionCall.isOperationCall() || functionCall.getArguments().isEmpty()) {
            return null;
        }
        EObject funRef = functionCall.getReference();
        EList arguments = functionCall.getArguments();
        _xblockexpression = ModelUtils.getFunctionCallArguments(funRef, (Iterable<Argument>)arguments);
        return _xblockexpression;
    }

    public static Iterable<Pair<TypeSpecifier, Argument>> getFunctionCallArguments(EObject funRef, Iterable<Argument> arguments) {
        Iterable _xifexpression = null;
        if (funRef instanceof FunctionDefinition) {
            Functions.Function1<Parameter, TypeSpecifier> _function = new Functions.Function1<Parameter, TypeSpecifier>(){

                public TypeSpecifier apply(Parameter it) {
                    return it.getTypeSpecifier();
                }
            };
            _xifexpression = BaseUtils.zip((Iterable)ListExtensions.map((List)((FunctionDefinition)funRef).getParameters(), (Functions.Function1)_function), ModelUtils.getSortedArguments((Iterable<Parameter>)((FunctionDefinition)funRef).getParameters(), arguments));
        } else {
            Iterable _xifexpression_1 = null;
            if (funRef instanceof StructureType) {
                Functions.Function1<Parameter, TypeSpecifier> _function_1 = new Functions.Function1<Parameter, TypeSpecifier>(){

                    public TypeSpecifier apply(Parameter it) {
                        return it.getTypeSpecifier();
                    }
                };
                _xifexpression_1 = BaseUtils.zip((Iterable)ListExtensions.map((List)((StructureType)funRef).getParameters(), (Functions.Function1)_function_1), ModelUtils.getSortedArguments((Iterable<Parameter>)((StructureType)funRef).getParameters(), arguments));
            } else {
                Iterable _xifexpression_2 = null;
                if (funRef instanceof NamedProductType) {
                    Functions.Function1<Parameter, TypeSpecifier> _function_2 = new Functions.Function1<Parameter, TypeSpecifier>(){

                        public TypeSpecifier apply(Parameter it) {
                            return it.getTypeSpecifier();
                        }
                    };
                    _xifexpression_2 = BaseUtils.zip((Iterable)ListExtensions.map((List)((NamedProductType)funRef).getParameters(), (Functions.Function1)_function_2), ModelUtils.getSortedArguments((Iterable<Parameter>)((NamedProductType)funRef).getParameters(), arguments));
                } else {
                    Iterable _xifexpression_3 = null;
                    if (!(funRef instanceof AnonymousProductType)) {
                        return null;
                    }
                    _xifexpression_3 = BaseUtils.zip((Iterable)((AnonymousProductType)funRef).accessorsTypes(), arguments);
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        Iterable typesAndArgsInOrder = _xifexpression;
        return typesAndArgsInOrder;
    }

    public static boolean typeSpecifierEqualsByName(TypeSpecifier ts, Object o) {
        Functions.Function2<Type, Type, Boolean> _function = new Functions.Function2<Type, Type, Boolean>(){

            public Boolean apply(Type t1, Type t2) {
                String _name = t1.getName();
                String _name_1 = t2.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            }
        };
        return ModelUtils.typeSpecifierEqualsWith((Functions.Function2<? super Type, ? super Type, ? extends Boolean>)_function, ts, o);
    }

    public static boolean typeSpecifierEqualsWith(final Functions.Function2<? super Type, ? super Type, ? extends Boolean> equalityCheck, TypeSpecifier ts1, Object o) {
        Boolean _xblockexpression = null;
        if (!(o instanceof TypeSpecifier)) {
            return false;
        }
        TypeSpecifier ts2 = (TypeSpecifier)o;
        if (!((Boolean)equalityCheck.apply((Object)ts1.getType(), (Object)ts2.getType())).booleanValue() || ((Object[])Conversions.unwrapArray((Object)ts1.getTypeArguments(), Object.class)).length != ((Object[])Conversions.unwrapArray((Object)ts2.getTypeArguments(), Object.class)).length) {
            return false;
        }
        Functions.Function2<Boolean, Pair<TypeSpecifier, TypeSpecifier>, Boolean> _function = new Functions.Function2<Boolean, Pair<TypeSpecifier, TypeSpecifier>, Boolean>(){

            public Boolean apply(Boolean eq, Pair<TypeSpecifier, TypeSpecifier> tss) {
                return eq != false && ModelUtils.typeSpecifierEqualsWith((Functions.Function2<? super Type, ? super Type, ? extends Boolean>)equalityCheck, (TypeSpecifier)tss.getKey(), tss.getValue());
            }
        };
        _xblockexpression = (Boolean)IterableExtensions.fold((Iterable)BaseUtils.zip((Iterable)ts1.getTypeArguments(), (Iterable)ts2.getTypeArguments()), (Object)true, (Functions.Function2)_function);
        return _xblockexpression;
    }

    public static boolean typeInferenceResultEqualsWith(final Functions.Function2<? super Type, ? super Type, ? extends Boolean> equalityCheck, ITypeSystemInferrer.InferenceResult ir1, Object o) {
        Boolean _xblockexpression = null;
        if (!(o instanceof ITypeSystemInferrer.InferenceResult)) {
            return false;
        }
        ITypeSystemInferrer.InferenceResult ir2 = (ITypeSystemInferrer.InferenceResult)o;
        if (!((Boolean)equalityCheck.apply((Object)ir1.getType(), (Object)ir2.getType())).booleanValue() || ((Object[])Conversions.unwrapArray((Object)ir1.getBindings(), Object.class)).length != ((Object[])Conversions.unwrapArray((Object)ir2.getBindings(), Object.class)).length) {
            return false;
        }
        Functions.Function2<Boolean, Pair<ITypeSystemInferrer.InferenceResult, ITypeSystemInferrer.InferenceResult>, Boolean> _function = new Functions.Function2<Boolean, Pair<ITypeSystemInferrer.InferenceResult, ITypeSystemInferrer.InferenceResult>, Boolean>(){

            public Boolean apply(Boolean eq, Pair<ITypeSystemInferrer.InferenceResult, ITypeSystemInferrer.InferenceResult> tss) {
                return eq != false && ModelUtils.typeInferenceResultEqualsWith((Functions.Function2<? super Type, ? super Type, ? extends Boolean>)equalityCheck, (ITypeSystemInferrer.InferenceResult)tss.getKey(), tss.getValue());
            }
        };
        _xblockexpression = (Boolean)IterableExtensions.fold((Iterable)BaseUtils.zip((Iterable)ir1.getBindings(), (Iterable)ir2.getBindings()), (Object)true, (Functions.Function2)_function);
        return _xblockexpression;
    }

    public static Expression getArgumentValue(Operation op, ArgumentExpression expr, final String name) {
        boolean _isOperationCall;
        Functions.Function1<Argument, Boolean> _function = new Functions.Function1<Argument, Boolean>(){

            public Boolean apply(Argument x) {
                Parameter _parameter = x.getParameter();
                String _name = null;
                if (_parameter != null) {
                    _name = _parameter.getName();
                }
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        Argument namedArg = (Argument)IterableExtensions.findFirst((Iterable)expr.getArguments(), (Functions.Function1)_function);
        if (namedArg != null) {
            return namedArg.getValue();
        }
        Iterable<Argument> sortedArgs = ModelUtils.getSortedArguments((Iterable<Parameter>)op.getParameters(), (Iterable<Argument>)expr.getArguments());
        Functions.Function1<Pair<Integer, Parameter>, Boolean> _function_1 = new Functions.Function1<Pair<Integer, Parameter>, Boolean>(){

            public Boolean apply(Pair<Integer, Parameter> x) {
                String _name = ((Parameter)x.getValue()).getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        Pair _findFirst = (Pair)IterableExtensions.findFirst((Iterable)IterableExtensions.indexed((Iterable)op.getParameters()), (Functions.Function1)_function_1);
        Integer _key = null;
        if (_findFirst != null) {
            _key = (Integer)_findFirst.getKey();
        }
        Integer argIndex = _key;
        if (expr instanceof FeatureCall && (_isOperationCall = ((FeatureCall)expr).isOperationCall())) {
            if (argIndex == 0) {
                return ((FeatureCall)expr).getOwner();
            }
            argIndex = argIndex - 1;
        }
        if (argIndex == null || argIndex >= ((Object[])Conversions.unwrapArray(sortedArgs, Object.class)).length) {
            return null;
        }
        Argument _get = ((Argument[])Conversions.unwrapArray(sortedArgs, Argument.class))[argIndex];
        Expression _value = null;
        if (_get != null) {
            _value = _get.getValue();
        }
        return _value;
    }

    public static Expression getArgumentValue(NamedProductType op, ArgumentExpression expr, final String name) {
        boolean _isOperationCall;
        Functions.Function1<Argument, Boolean> _function = new Functions.Function1<Argument, Boolean>(){

            public Boolean apply(Argument x) {
                Parameter _parameter = x.getParameter();
                String _name = null;
                if (_parameter != null) {
                    _name = _parameter.getName();
                }
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        Argument namedArg = (Argument)IterableExtensions.findFirst((Iterable)expr.getArguments(), (Functions.Function1)_function);
        if (namedArg != null) {
            return namedArg.getValue();
        }
        Iterable<Argument> sortedArgs = ModelUtils.getSortedArguments((Iterable<Parameter>)op.getParameters(), (Iterable<Argument>)expr.getArguments());
        Functions.Function1<Pair<Integer, Parameter>, Boolean> _function_1 = new Functions.Function1<Pair<Integer, Parameter>, Boolean>(){

            public Boolean apply(Pair<Integer, Parameter> x) {
                String _name = ((Parameter)x.getValue()).getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        Pair _findFirst = (Pair)IterableExtensions.findFirst((Iterable)IterableExtensions.indexed((Iterable)op.getParameters()), (Functions.Function1)_function_1);
        Integer _key = null;
        if (_findFirst != null) {
            _key = (Integer)_findFirst.getKey();
        }
        Integer argIndex = _key;
        if (expr instanceof FeatureCall && (_isOperationCall = ((FeatureCall)expr).isOperationCall())) {
            if (argIndex == 0) {
                return ((FeatureCall)expr).getOwner();
            }
            argIndex = argIndex - 1;
        }
        if (argIndex == null || argIndex >= ((Object[])Conversions.unwrapArray(sortedArgs, Object.class)).length) {
            return null;
        }
        Argument _get = ((Argument[])Conversions.unwrapArray(sortedArgs, Argument.class))[argIndex];
        Expression _value = null;
        if (_get != null) {
            _value = _get.getValue();
        }
        return _value;
    }

    public static Expression getArgumentValue(SignalInstance signalInstance, final String name) {
        Expression init = signalInstance.getInitialization();
        Expression _xifexpression = null;
        if (init instanceof ElementReferenceExpression) {
            Expression _xblockexpression = null;
            EObject ref = ((ElementReferenceExpression)init).getReference();
            Expression _xifexpression_1 = null;
            _xifexpression_1 = ref instanceof Operation ? ModelUtils.getArgumentValue((Operation)ref, (ArgumentExpression)init, name) : null;
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            _xifexpression = null;
        }
        Expression configuredValue = _xifexpression;
        Signal item = signalInstance.getInstanceOf();
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        Parameter _findFirst = (Parameter)IterableExtensions.findFirst((Iterable)item.getParameters(), (Functions.Function1)_function);
        Expression _defaultValue = null;
        if ((SignalParameter)_findFirst != null) {
            _defaultValue = ((SignalParameter)_findFirst).getDefaultValue();
        }
        Expression defaultValue = _defaultValue;
        Expression _elvis = null;
        _elvis = configuredValue != null ? configuredValue : defaultValue;
        return _elvis;
    }

    public static String getOriginalSourceCode(EObject obj) {
        EObject origin = ProgramCopier.computeOrigin(obj);
        ICompositeNode node = NodeModelUtils.getNode((EObject)origin);
        String _xifexpression = null;
        _xifexpression = node == null ? null : NodeModelUtils.getTokenText((INode)node);
        return _xifexpression;
    }

    public static boolean isPrimitiveType(TypeSpecifier typeSpec) {
        Type _type = null;
        if (typeSpec != null) {
            _type = typeSpec.getType();
        }
        Type type = _type;
        boolean _xifexpression = false;
        if (type instanceof PrimitiveType) {
            _xifexpression = true;
        } else {
            boolean _xifexpression_1 = false;
            if (type instanceof GeneratedType && Objects.equal((Object)type.getName(), (Object)"optional")) {
                Functions.Function1<TypeSpecifier, Boolean> _function = new Functions.Function1<TypeSpecifier, Boolean>(){

                    public Boolean apply(TypeSpecifier x) {
                        return ModelUtils.isPrimitiveType(x);
                    }
                };
                _xifexpression_1 = IterableExtensions.forall((Iterable)typeSpec.getTypeArguments(), (Functions.Function1)_function);
            } else {
                _xifexpression_1 = false;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static VariableDeclaration getUnderlyingVariableDeclaration(EObject decl) {
        if (decl instanceof VariableDeclaration) {
            return ModelUtils._getUnderlyingVariableDeclaration((VariableDeclaration)decl);
        }
        if (decl instanceof ElementReferenceExpression) {
            return ModelUtils._getUnderlyingVariableDeclaration((ElementReferenceExpression)decl);
        }
        if (decl instanceof FeatureCall) {
            return ModelUtils._getUnderlyingVariableDeclaration((FeatureCall)decl);
        }
        if (decl instanceof ArrayAccessExpression) {
            return ModelUtils._getUnderlyingVariableDeclaration((ArrayAccessExpression)decl);
        }
        if (decl != null) {
            return ModelUtils._getUnderlyingVariableDeclaration(decl);
        }
        if (decl == null) {
            return ModelUtils._getUnderlyingVariableDeclaration(null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(decl).toString());
    }

    public static Optional<EList<Parameter>> getAccessorParameters(EObject apt) {
        if (apt instanceof AnonymousProductType) {
            return ModelUtils._getAccessorParameters((AnonymousProductType)apt);
        }
        if (apt instanceof NamedProductType) {
            return ModelUtils._getAccessorParameters((NamedProductType)apt);
        }
        if (apt instanceof StructureType) {
            return ModelUtils._getAccessorParameters((StructureType)apt);
        }
        if (apt instanceof Operation) {
            return ModelUtils._getAccessorParameters((Operation)apt);
        }
        if (apt != null) {
            return ModelUtils._getAccessorParameters(apt);
        }
        if (apt == null) {
            return ModelUtils._getAccessorParameters(null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(apt).toString());
    }

    public static Iterable<Pair<TypeSpecifier, Argument>> getFunctionCallArguments(EObject functionCall) {
        if (functionCall instanceof ElementReferenceExpression) {
            return ModelUtils._getFunctionCallArguments((ElementReferenceExpression)functionCall);
        }
        if (functionCall instanceof FeatureCall) {
            return ModelUtils._getFunctionCallArguments((FeatureCall)functionCall);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(functionCall).toString());
    }

    public static class PreventRecursionAdapter
    extends AdapterImpl {
        public static boolean isMarked(EObject obj) {
            Functions.Function1<Adapter, Boolean> _function = new Functions.Function1<Adapter, Boolean>(){

                public Boolean apply(Adapter it) {
                    return it instanceof PreventRecursionAdapter;
                }
            };
            return IterableExtensions.exists((Iterable)obj.eAdapters(), (Functions.Function1)_function);
        }

        public static PreventRecursionAdapter applyTo(EObject target) {
            PreventRecursionAdapter adapter = new PreventRecursionAdapter();
            target.eAdapters().add((Object)adapter);
            return adapter;
        }

        public static boolean removeFromBySearch(EObject target) {
            Predicate<Adapter> _function = new Predicate<Adapter>(){

                @Override
                public boolean test(Adapter it) {
                    return it instanceof PreventRecursionAdapter;
                }
            };
            return target.eAdapters().removeIf((Predicate)_function);
        }

        public boolean removeFrom(EObject target) {
            return target.eAdapters().remove((Object)this);
        }
    }
}

