/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import com.google.inject.Inject;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.mita.program.generator.IPlatformTimeGenerator;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TimeEventGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject(optional=true)
    protected IPlatformExceptionGenerator exceptionGenerator;
    @Inject(optional=true)
    protected IPlatformTimeGenerator timeGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CompositeGeneratorNode generateHeader(final CompilationContext context) {
        final CodeFragment exceptionType = this.exceptionGenerator.getExceptionType();
        Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration e) {
                EventSource _event = e.getEvent();
                return _event instanceof TimeIntervalEvent;
            }
        };
        final Iterable allTimeEventHandler = IterableExtensions.filter(context.getAllEventHandlers(), (Functions.Function1)_function);
        final IPlatformTimeGenerator generator = this.timeGenerator;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)exceptionType);
                _builder.append((Object)" SetupTime(void);");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)exceptionType);
                _builder.append((Object)" EnableTime(void);");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                for (EventHandlerDeclaration handler : allTimeEventHandler) {
                    _builder.append((Object)exceptionType);
                    _builder.append((Object)" ");
                    String _enableName = TimeEventGenerator.this._generatorUtils.getEnableName(handler);
                    _builder.append((Object)_enableName);
                    _builder.append((Object)"(void);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                CodeFragment _generateAdditionalHeaderContent = generator.generateAdditionalHeaderContent(context);
                _builder.append((Object)_generateAdditionalHeaderContent);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).toHeader(context, "MITA_TIME_H");
    }

    public CompositeGeneratorNode generateImplementation(final CompilationContext context) {
        IPlatformExceptionGenerator exceptionGenerator = this.exceptionGenerator;
        final IPlatformTimeGenerator generator = this.timeGenerator;
        final CodeFragment exceptionType = exceptionGenerator.getExceptionType();
        Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration e) {
                EventSource _event = e.getEvent();
                return _event instanceof TimeIntervalEvent;
            }
        };
        final Iterable allTimeEventHandler = IterableExtensions.filter(context.getAllEventHandlers(), (Functions.Function1)_function);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)exceptionType);
                _builder.append((Object)" SetupTime(void)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateTimeSetup = generator.generateTimeSetup(context);
                _builder.append((Object)_generateTimeSetup, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return NO_EXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)exceptionType);
                _builder.append((Object)" EnableTime(void)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)exceptionType, "\t");
                _builder.append((Object)" result = NO_EXCEPTION;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateTimeGoLive = generator.generateTimeGoLive(context);
                _builder.append((Object)_generateTimeGoLive, "\t");
                _builder.newLineIfNotEmpty();
                for (EventHandlerDeclaration event : allTimeEventHandler) {
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"result = ");
                    String _enableName = TimeEventGenerator.this._generatorUtils.getEnableName(event);
                    _builder.append((Object)_enableName, "\t");
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if(result != NO_EXCEPTION)");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return result;");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return NO_EXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                for (EventHandlerDeclaration event_1 : allTimeEventHandler) {
                    _builder.append((Object)exceptionType);
                    _builder.append((Object)" ");
                    String _enableName_1 = TimeEventGenerator.this._generatorUtils.getEnableName(event_1);
                    _builder.append((Object)_enableName_1);
                    _builder.append((Object)"(void)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    CodeFragment _generateTimeEnable = generator.generateTimeEnable(context, event_1);
                    _builder.append((Object)_generateTimeEnable, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return NO_EXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                }
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("MitaTime.h", false).toImplementation(context);
    }
}

