/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import com.google.inject.Inject;
import org.eclipse.mita.base.types.ExceptionTypeDeclaration;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.xbase.lib.Extension;

public class ExceptionGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject(optional=true)
    protected IPlatformExceptionGenerator exceptionGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CompositeGeneratorNode generateHeader(final CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#define NO_EXCEPTION ");
                CodeFragment _noExceptionStatement = ExceptionGenerator.this.exceptionGenerator.getNoExceptionStatement();
                _builder.append((Object)_noExceptionStatement);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                Iterable<ExceptionTypeDeclaration> _allExceptionsUsed = context.getAllExceptionsUsed();
                for (ExceptionTypeDeclaration exception : _allExceptionsUsed) {
                    _builder.append((Object)"#define ");
                    String _baseName = ExceptionGenerator.this._generatorUtils.getBaseName(exception);
                    _builder.append((Object)_baseName);
                    _builder.append((Object)" ");
                    CodeFragment _generateExceptionCodeFor = ExceptionGenerator.this.exceptionGenerator.generateExceptionCodeFor(context, (Type)exception);
                    _builder.append((Object)_generateExceptionCodeFor);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return this.codeFragmentProvider.create(_client).toHeader(context, "MITA_EXCEPTIONS_H");
    }
}

