/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.ExceptionTypeDeclaration;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.NativeType;
import org.eclipse.mita.base.types.PrimitiveType;
import org.eclipse.mita.base.types.Singleton;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.generator.AbstractTypeGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IGenerator;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.mita.program.generator.internal.GeneratorRegistry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TypeGenerator
implements IGenerator {
    @Inject(optional=true)
    protected IPlatformExceptionGenerator exceptionGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected GeneratorRegistry generatorRegistry;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;

    public CodeFragment code(TypeSpecifier typeSpec) {
        CodeFragment _xifexpression = null;
        _xifexpression = typeSpec == null ? CodeFragment.EMPTY : this.code(typeSpec.getType(), typeSpec);
        return _xifexpression;
    }

    protected CodeFragment _code(final Singleton singleton, TypeSpecifier typeSpec) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _structType = TypeGenerator.this._generatorUtils.getStructType((ComplexType)singleton);
                _builder.append((Object)_structType);
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    protected CodeFragment _code(final AnonymousProductType productType, TypeSpecifier typeSpec) {
        boolean _greaterThan;
        int _length = ((Object[])Conversions.unwrapArray((Object)productType.getTypeSpecifiers(), Object.class)).length;
        boolean bl = _greaterThan = _length > 1;
        if (_greaterThan) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    CodeFragment _structType = TypeGenerator.this._generatorUtils.getStructType((ComplexType)productType);
                    _builder.append((Object)_structType);
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        return this.code((TypeSpecifier)IterableExtensions.head((Iterable)productType.getTypeSpecifiers()));
    }

    protected CodeFragment _code(final NamedProductType productType, TypeSpecifier typeSpec) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _structType = TypeGenerator.this._generatorUtils.getStructType((ComplexType)productType);
                _builder.append((Object)_structType);
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    protected CodeFragment _code(final SumType sumType, TypeSpecifier typeSpec) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _structType = TypeGenerator.this._generatorUtils.getStructType((ComplexType)sumType);
                _builder.append((Object)_structType);
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    protected CodeFragment _code(ExceptionTypeDeclaration exception, TypeSpecifier typeSpec) {
        return this.exceptionGenerator.getExceptionType();
    }

    protected CodeFragment _code(GeneratedType type, TypeSpecifier typeSpec) {
        AbstractTypeGenerator _generator = this.generatorRegistry.getGenerator(type);
        CodeFragment _generateTypeSpecifier = null;
        if (_generator != null) {
            _generateTypeSpecifier = _generator.generateTypeSpecifier(typeSpec, (EObject)type);
        }
        return _generateTypeSpecifier;
    }

    protected CodeFragment _code(final ComplexType type, TypeSpecifier typeSpec) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = type.getName();
                _builder.append((Object)_name);
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    protected CodeFragment _code(final EnumerationType type, TypeSpecifier typeSpec) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = type.getName();
                _builder.append((Object)_name);
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    protected CodeFragment _code(final NativeType type, TypeSpecifier typeSpec) {
        boolean _tripleNotEquals;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _cName = type.getCName();
                _builder.append((Object)_cName);
            }
        };
        CodeFragment result = this.codeFragmentProvider.create(_client);
        String _header = type.getHeader();
        boolean bl = _tripleNotEquals = _header != null;
        if (_tripleNotEquals) {
            result = result.addHeader(type.getHeader(), true);
        }
        return result;
    }

    protected CodeFragment _code(final PrimitiveType type, TypeSpecifier typeSpec) {
        CodeFragment _xifexpression = null;
        String _name = type.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)"string");
        if (_equals) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"char*");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client);
        } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = type.getName();
                    _builder.append((Object)_name);
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_1);
        }
        return _xifexpression;
    }

    protected CodeFragment _code(AbstractSystemResource type, TypeSpecifier typeSpec) {
        throw new UnsupportedOperationException("Cannot use system resources as types yet");
    }

    protected CodeFragment _code(Type type, TypeSpecifier typeSpec) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Mita implementation error: missing type ");
        _builder.append((Object)type);
        throw new UnsupportedOperationException(_builder.toString());
    }

    protected CodeFragment code(Type productType, TypeSpecifier typeSpec) {
        if (productType instanceof AnonymousProductType) {
            return this._code((AnonymousProductType)productType, typeSpec);
        }
        if (productType instanceof NamedProductType) {
            return this._code((NamedProductType)productType, typeSpec);
        }
        if (productType instanceof Singleton) {
            return this._code((Singleton)productType, typeSpec);
        }
        if (productType instanceof EnumerationType) {
            return this._code((EnumerationType)productType, typeSpec);
        }
        if (productType instanceof GeneratedType) {
            return this._code((GeneratedType)productType, typeSpec);
        }
        if (productType instanceof NativeType) {
            return this._code((NativeType)productType, typeSpec);
        }
        if (productType instanceof SumType) {
            return this._code((SumType)productType, typeSpec);
        }
        if (productType instanceof ComplexType) {
            return this._code((ComplexType)productType, typeSpec);
        }
        if (productType instanceof ExceptionTypeDeclaration) {
            return this._code((ExceptionTypeDeclaration)productType, typeSpec);
        }
        if (productType instanceof PrimitiveType) {
            return this._code((PrimitiveType)productType, typeSpec);
        }
        if (productType instanceof AbstractSystemResource) {
            return this._code((AbstractSystemResource)productType, typeSpec);
        }
        if (productType != null) {
            return this._code(productType, typeSpec);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(productType, typeSpec).toString());
    }
}

