/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.formatting;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.services.ProgramDslGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.Extension;

public class ProgramDslFormatter
extends AbstractDeclarativeFormatter {
    @Inject
    @Extension
    private ProgramDslGrammarAccess grammar;

    protected void configureFormatting(FormattingConfig c) {
        c.setAutoLinewrap(120);
        this.formatCurlyBrackets(c);
        this.formatRoundBrackets(c);
        this.formatSemicolon(c);
        this.formatComma(c);
        this.formatComments(c);
        this.formatTypeDeclaration(c);
        this.formatGeneratedType(c);
        this.formatStructureField(c);
        this.formatEnumerator(c);
        this.formatGeneratedFunctionDefinition(c);
        this.formatFeatureCalls(c);
        this.formatIfElse(c);
        this.formatForLoop(c);
        this.formatCatchFinally(c);
        this.formatAllTypeSpecifiers(c);
        this.formatPostFixExpression(c);
    }

    public void formatCurlyBrackets(final FormattingConfig config) {
        Consumer<Pair<Keyword, Keyword>> _function = new Consumer<Pair<Keyword, Keyword>>(){

            @Override
            public void accept(Pair<Keyword, Keyword> it) {
                config.setLinewrap(1, 1, 2).after((EObject)it.getFirst());
                config.setIndentationIncrement().after((EObject)it.getFirst());
                config.setLinewrap(1, 1, 2).before((EObject)it.getSecond());
                config.setIndentationDecrement().before((EObject)it.getSecond());
                config.setLinewrap(1, 1, 2).after((EObject)it.getSecond());
            }
        };
        this.grammar.findKeywordPairs("{", "}").forEach(_function);
    }

    public void formatRoundBrackets(final FormattingConfig config) {
        Consumer<Keyword> _function = new Consumer<Keyword>(){

            @Override
            public void accept(Keyword it) {
                config.setNoSpace().before((EObject)it);
                config.setNoSpace().after((EObject)it);
            }
        };
        this.grammar.findKeywords(new String[]{"("}).forEach(_function);
        Consumer<Keyword> _function_1 = new Consumer<Keyword>(){

            @Override
            public void accept(Keyword it) {
                config.setNoSpace().before((EObject)it);
            }
        };
        this.grammar.findKeywords(new String[]{")"}).forEach(_function_1);
    }

    public void formatSemicolon(final FormattingConfig config) {
        Consumer<Keyword> _function = new Consumer<Keyword>(){

            @Override
            public void accept(Keyword it) {
                config.setLinewrap(1, 1, 2).after((EObject)it);
                config.setNoSpace().before((EObject)it);
            }
        };
        this.grammar.findKeywords(new String[]{";"}).forEach(_function);
    }

    public void formatComma(final FormattingConfig config) {
        Consumer<Keyword> _function = new Consumer<Keyword>(){

            @Override
            public void accept(Keyword it) {
                config.setNoSpace().before((EObject)it);
            }
        };
        this.grammar.findKeywords(new String[]{","}).forEach(_function);
    }

    public void formatComments(FormattingConfig config) {
        config.setLinewrap(0, 1, 2).before((EObject)this.grammar.getSL_COMMENTRule());
        config.setLinewrap(0, 1, 2).after((EObject)this.grammar.getSL_COMMENTRule());
        config.setLinewrap(0, 1, 2).before((EObject)this.grammar.getML_COMMENTRule());
        config.setLinewrap(0, 1, 1).after((EObject)this.grammar.getML_COMMENTRule());
    }

    public void formatTypeDeclaration(FormattingConfig config) {
        config.setLinewrap(0, 1, 2).before((EObject)this.grammar.getNativeTypeDeclarationRule());
        config.setLinewrap(0, 1, 2).before((EObject)this.grammar.getStructureTypeDeclarationRule());
        config.setLinewrap(0, 1, 2).before((EObject)this.grammar.getExceptionTypeDeclarationRule());
        config.setLinewrap(0, 1, 2).before((EObject)this.grammar.getEnumerationDeclarationRule());
        config.setLinewrap(0, 1, 2).before((EObject)this.grammar.getGeneratedTypeRule());
    }

    public void formatAllTypeSpecifiers(FormattingConfig config) {
        this.formatTypeSpecifier(this.grammar.getVariableDeclarationAccess());
        this.formatTypeSpecifier((AbstractElementFinder.AbstractParserRuleElementFinder)this.grammar.getGeneratedTypeAccess());
        this.formatTypeSpecifier(this.grammar.getGeneratedFunctionDefinitionAccess());
        this.formatTypeSpecifier(this.grammar.getFunctionDefinitionAccess());
        this.formatTypeSpecifier((AbstractElementFinder.AbstractParserRuleElementFinder)this.grammar.getStructureFieldAccess());
        this.formatTypeSpecifier((AbstractElementFinder.AbstractParserRuleElementFinder)this.grammar.getAnonymousProductTypeAccess());
        this.formatTypeSpecifier((AbstractElementFinder.AbstractParserRuleElementFinder)this.grammar.getProductMemberAccess());
    }

    protected void formatTypeSpecifier(AbstractElementFinder.AbstractParserRuleElementFinder access) {
        Consumer<Pair<Keyword, Keyword>> _function = new Consumer<Pair<Keyword, Keyword>>(){

            @Override
            public void accept(Pair<Keyword, Keyword> k) {
                ProgramDslFormatter.this.getConfig().setNoSpace().after((EObject)k.getFirst());
                ProgramDslFormatter.this.getConfig().setNoSpace().before((EObject)k.getFirst());
                ProgramDslFormatter.this.getConfig().setSpace(" ").before((EObject)k.getSecond());
            }
        };
        access.findKeywordPairs("<", ">").forEach(_function);
    }

    public void formatGeneratedType(FormattingConfig config) {
        config.setIndentationIncrement().before((EObject)this.grammar.getGeneratedTypeAccess().getGeneratorKeyword_7());
        config.setLinewrap(1, 1, 2).before((EObject)this.grammar.getGeneratedTypeAccess().getGeneratorKeyword_7());
        config.setLinewrap(1, 1, 2).before((EObject)this.grammar.getGeneratedTypeAccess().getSizeInferrerKeyword_9());
        config.setLinewrap(1, 1, 2).before((EObject)this.grammar.getGeneratedTypeAccess().getValidatorKeyword_11_0());
        config.setLinewrap(1, 1, 2).before((EObject)this.grammar.getGeneratedTypeConstructorRule());
        config.setIndentationDecrement().after((EObject)this.grammar.getGeneratedTypeAccess().getSemicolonKeyword_13());
    }

    public void formatStructureField(FormattingConfig config) {
        config.setLinewrap(1, 1, 2).before((EObject)this.grammar.getStructureFieldRule());
    }

    public void formatEnumerator(FormattingConfig config) {
        config.setLinewrap(0, 0, 1).before((EObject)this.grammar.getEnumeratorRule());
    }

    public void formatIfElse(FormattingConfig config) {
        config.setNoLinewrap().before((EObject)this.grammar.getIfStatementAccess().getElseKeyword_6_0());
        config.setNoLinewrap().before((EObject)this.grammar.getIfStatementAccess().getElseIfAssignment_5());
    }

    public void formatCatchFinally(FormattingConfig config) {
        config.setNoLinewrap().before((EObject)this.grammar.getTryStatementAccess().getFinallyKeyword_3_0());
        config.setNoLinewrap().before((EObject)this.grammar.getTryStatementAccess().getCatchStatementsAssignment_2());
    }

    public void formatForLoop(final FormattingConfig config) {
        Consumer<Keyword> _function = new Consumer<Keyword>(){

            @Override
            public void accept(Keyword it) {
                config.setNoLinewrap().after((EObject)it);
            }
        };
        this.grammar.getAbstractLoopStatementAccess().findKeywords(new String[]{";"}).forEach(_function);
    }

    public void formatGeneratedFunctionDefinition(FormattingConfig config) {
        config.setIndentationIncrement().before((EObject)this.grammar.getGeneratedFunctionDefinitionAccess().getGeneratorKeyword_9());
        config.setLinewrap(1, 1, 2).before((EObject)this.grammar.getGeneratedFunctionDefinitionAccess().getGeneratorKeyword_9());
        config.setLinewrap(1, 1, 2).before((EObject)this.grammar.getGeneratedFunctionDefinitionAccess().getValidatorKeyword_11_0());
        config.setIndentationDecrement().after((EObject)this.grammar.getGeneratedFunctionDefinitionAccess().getSemicolonKeyword_12());
    }

    public void formatFeatureCalls(final FormattingConfig config) {
        Consumer<Keyword> _function = new Consumer<Keyword>(){

            @Override
            public void accept(Keyword it) {
                config.setNoSpace().around((EObject)it);
            }
        };
        this.grammar.findKeywords(new String[]{"."}).forEach(_function);
    }

    public void formatPostFixExpression(FormattingConfig config) {
        config.setNoSpace().before((EObject)this.grammar.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_1_0());
    }
}

