/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import java.util.List;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class SignatureInformation {
    @NonNull
    private String label;
    private Either<String, MarkupContent> documentation;
    private List<ParameterInformation> parameters;
    @ProtocolSince(value="3.16.0")
    private Integer activeParameter;

    public SignatureInformation() {
    }

    public SignatureInformation(@NonNull String label) {
        this.label = (String)Preconditions.checkNotNull((Object)label, (String)"label");
    }

    public SignatureInformation(@NonNull String label, String documentation, List<ParameterInformation> parameters) {
        this(label);
        this.setDocumentation(documentation);
        this.parameters = parameters;
    }

    public SignatureInformation(@NonNull String label, MarkupContent documentation, List<ParameterInformation> parameters) {
        this(label);
        this.setDocumentation(documentation);
        this.parameters = parameters;
    }

    @NonNull
    public String getLabel() {
        return this.label;
    }

    public void setLabel(@NonNull String label) {
        this.label = (String)Preconditions.checkNotNull((Object)label, (String)"label");
    }

    public Either<String, MarkupContent> getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(Either<String, MarkupContent> documentation) {
        this.documentation = documentation;
    }

    public void setDocumentation(String documentation) {
        if (documentation == null) {
            this.documentation = null;
            return;
        }
        this.documentation = Either.forLeft((Object)documentation);
    }

    public void setDocumentation(MarkupContent documentation) {
        if (documentation == null) {
            this.documentation = null;
            return;
        }
        this.documentation = Either.forRight((Object)documentation);
    }

    public List<ParameterInformation> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterInformation> parameters) {
        this.parameters = parameters;
    }

    @ProtocolSince(value="3.16.0")
    public Integer getActiveParameter() {
        return this.activeParameter;
    }

    @ProtocolSince(value="3.16.0")
    public void setActiveParameter(Integer activeParameter) {
        this.activeParameter = activeParameter;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("label", (Object)this.label);
        b.add("documentation", this.documentation);
        b.add("parameters", this.parameters);
        b.add("activeParameter", (Object)this.activeParameter);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureInformation other = (SignatureInformation)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.documentation == null ? other.documentation != null : !this.documentation.equals(other.documentation)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.activeParameter == null ? other.activeParameter != null : !this.activeParameter.equals(other.activeParameter));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.documentation == null ? 0 : this.documentation.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return 31 * result + (this.activeParameter == null ? 0 : this.activeParameter.hashCode());
    }
}

