/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codelens;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4e.operations.codelens.CodeLensProvider;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.swt.events.MouseEvent;

public class LSPCodeMining
extends LineHeaderCodeMining {
    private CodeLens codeLens;
    private final LanguageServerWrapper languageServerWrapper;
    private final IDocument document;

    public LSPCodeMining(CodeLens codeLens, IDocument document, LanguageServerWrapper languageServerWrapper, CodeLensProvider provider) throws BadLocationException {
        super(codeLens.getRange().getStart().getLine(), document, (ICodeMiningProvider)provider, null);
        this.codeLens = codeLens;
        this.languageServerWrapper = languageServerWrapper;
        this.document = document;
        this.setLabel(LSPCodeMining.getCodeLensString(codeLens));
    }

    protected static @Nullable String getCodeLensString(CodeLens codeLens) {
        Command command = codeLens.getCommand();
        if (command == null || command.getTitle().isEmpty()) {
            return null;
        }
        return command.getTitle();
    }

    protected CompletableFuture<@Nullable Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        return this.languageServerWrapper.getServerCapabilitiesAsync().thenCompose(capabilities -> {
            Boolean resolveProvider = capabilities.getCodeLensProvider().getResolveProvider();
            if (resolveProvider == null || !resolveProvider.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.languageServerWrapper.execute(languageServer -> languageServer.getTextDocumentService().resolveCodeLens(this.codeLens)).thenAccept(resolvedCodeLens -> {
                if (resolvedCodeLens != null) {
                    this.codeLens = resolvedCodeLens;
                    this.setLabel(LSPCodeMining.getCodeLensString(resolvedCodeLens));
                }
            });
        });
    }

    public final @Nullable Consumer<MouseEvent> getAction() {
        Command command = this.codeLens.getCommand();
        if (command != null && command.getCommand() != null && !command.getCommand().isEmpty()) {
            return this::performAction;
        }
        return null;
    }

    private void performAction(MouseEvent mouseEvent) {
        ServerCapabilities serverCapabilities = this.languageServerWrapper.getServerCapabilities();
        ExecuteCommandOptions provider = serverCapabilities == null ? null : serverCapabilities.getExecuteCommandProvider();
        Command command = this.codeLens.getCommand();
        if (provider != null && provider.getCommands().contains(command.getCommand())) {
            this.languageServerWrapper.execute(ls -> ls.getWorkspaceService().executeCommand(new ExecuteCommandParams(command.getCommand(), command.getArguments())));
        } else {
            CommandExecutor.executeCommandClientSide(command, this.document);
        }
    }
}

