/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EditorToOutlineAdapterFactory
implements IAdapterFactory {
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final Map<IEditorPart, LanguageServer> LANG_SERVER_CACHE = Collections.synchronizedMap(new HashMap());

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        IEditorPart editorPart;
        IEditorInput editorInput;
        if (adapterType == IContentOutlinePage.class && adaptableObject instanceof IEditorPart && (editorInput = (editorPart = (IEditorPart)adaptableObject).getEditorInput()) != null && LanguageServersRegistry.getInstance().canUseLanguageServer(editorInput)) {
            LanguageServer server = LANG_SERVER_CACHE.remove(adaptableObject);
            if (server != null) {
                return adapterType.cast(EditorToOutlineAdapterFactory.createOutlinePage(editorPart, server));
            }
            IDocument document = LSPEclipseUtils.getDocument(editorInput);
            if (document != null) {
                CompletableFuture<List<@NonNull LanguageServer>> languageServers = LanguageServiceAccessor.getLanguageServers(document, capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentSymbolProvider()));
                List<@NonNull Object> servers = Collections.emptyList();
                try {
                    servers = languageServers.get(50L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    EditorToOutlineAdapterFactory.refreshContentOutlineAsync(languageServers, editorPart);
                }
                catch (ExecutionException e) {
                    LanguageServerPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    LanguageServerPlugin.logError(e);
                    Thread.currentThread().interrupt();
                }
                if (!servers.isEmpty()) {
                    LanguageServer languageServer = (LanguageServer)servers.get(0);
                    return adapterType.cast(EditorToOutlineAdapterFactory.createOutlinePage(editorPart, languageServer));
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IContentOutlinePage.class};
    }

    private static CNFOutlinePage createOutlinePage(IEditorPart editorPart, @NonNull LanguageServer languageServer) {
        ITextEditor textEditor = null;
        if (editorPart instanceof ITextEditor) {
            textEditor = (ITextEditor)editorPart;
        }
        return new CNFOutlinePage(languageServer, textEditor);
    }

    private static void refreshContentOutlineAsync(CompletableFuture<List<@NonNull LanguageServer>> languageServers, IEditorPart editorPart) {
        languageServers.thenAcceptAsync(servers -> {
            if (!servers.isEmpty()) {
                Display.getDefault().asyncExec(() -> {
                    IViewPart viewPart;
                    IWorkbenchPage page = UI.getActivePage();
                    if (page != null && (viewPart = page.findView(OUTLINE_VIEW_ID)) instanceof ContentOutline) {
                        LANG_SERVER_CACHE.put(editorPart, (LanguageServer)servers.get(0));
                        ((ContentOutline)viewPart).partActivated((IWorkbenchPart)editorPart);
                    }
                });
            }
        });
    }
}

